/*
 * PIR sensor keyboard driver for Arduino UNO R3
 * by Bjarke Viksoe
 */

#include <avr/interrupt.h>
#include <avr/power.h>
#include <avr/sleep.h>

#define USB_SCANCODE_POWER       0x66

int ledPin = 13;                // choose the pin for the LED
int inputPin = 2;               // choose the input pin (for PIR sensor)
int pirState = LOW;             // we start, assuming no motion detected
int val = 0;                    // variable for reading the pin status
int incoming = 0;               // response from atmega16u2 chip
uint8_t buf[8] = { 0 };         // keyboard report buffer


void setup()
{
  DDRD &= B00000011;            // set Arduino pins 2 to 7 as inputs, leaves 0 & 1 (RX & TX) as is
  DDRB = B00000000;             // set pins 8 to 13 as inputs
  PORTD |= B11111100;           // enable pullups on pins 2 to 7, leave pins 0 and 1 alone
  PORTB |= B11111111;           // enable pullups on pins 8 to 13

  pinMode(ledPin, OUTPUT);      // declare LED as output
  pinMode(inputPin, INPUT);     // declare sensor as input

  Serial.begin(9600);
  delay(200);
}

void sendWakeupToKeyboard()
{
  buf[2] = USB_SCANCODE_POWER;
  Serial.write(buf, 8);         // send keypress
  delay(100);
  buf[0] = 0; 
  buf[2] = 0;
  Serial.write(buf, 8);         // release key  
}

void blinkLed(int p)
{
   for(val = 0; val < 5; val++) {
     delay(p);
     digitalWrite(ledPin, HIGH);  // turn LED ON
     delay(p);
     digitalWrite(ledPin, LOW);   // turn LED OFF
   }
}

void sleepNow()
{
    // set pin 2 as interrupt and attach handler:
    attachInterrupt(0, pinInterrupt, CHANGE);
    delay(100);

    set_sleep_mode(SLEEP_MODE_IDLE);
    sleep_enable();
    sleep_mode();
    // ... we wake up here
    sleep_disable();
}

void pinInterrupt(void)
{
    detachInterrupt(0);
}

void loop()
{
  val = digitalRead(inputPin);   // read input value
  if (val == HIGH) {             // check if the input is HIGH
    digitalWrite(ledPin, HIGH);  // turn LED ON
    if (pirState == LOW) {
      pirState = HIGH;
      sendWakeupToKeyboard();
    }
  }
  else {
    digitalWrite(ledPin, LOW);   // turn LED OFF
    if (pirState == HIGH) {
      pirState = LOW;
    }
  }

  if (Serial.available() > 0) {
    incoming = Serial.read();
    if (incoming == 0x66) blinkLed(50);   // ACK in normal mode
    if (incoming == 0x33) blinkLed(100);  // ACK in suspended mode
  }

  sleepNow();
}
