// XmliteTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "XmlParser.h"


class CXmlConfig : public CXMLElementHandler
{
public:
   int iValue;
   bool bValue;
   std::wstring sValue;
   std::wstring sDescription;
   typedef struct ITEM { int a; };
   std::vector<ITEM> aList;

   CXmlConfig() : bValue(false), iValue(0)
   { }

   XML_DEFINE_TEMP( ITEM* pTempItem );

   BEGIN_XML_PARSE_MAP()
      BEGIN_XML_ELEMENT("Data")
         XML_ATTRIB_STR("strValue", sValue)
         XML_ATTRIB_INT("intValue", iValue)
         XML_ATTRIB_BOOL("boolValue", bValue)
      END_XML_ELEMENT()
      BEGIN_XML_ELEMENT("Item")
         XML_ATTRIB_INIT( ITEM t; aList.push_back(t); pTempItem = &aList.back(); )
         XML_ATTRIB_INT("a", pTempItem->a)
      END_XML_ELEMENT()
      XML_CHARDATA_STR("Description", sDescription)
   END_XML_PARSE_MAP()
};



int _tmain(int argc, _TCHAR* argv[])
{
   if( argc < 2 ) {
      printf("USAGE: XmliteTest <xml-filename>");
      return 1;
   }

   HANDLE hFile = ::CreateFile(argv[1], GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
   if( hFile == INVALID_HANDLE_VALUE ) return 1;
   SIZE_T dwFileSize = ::GetFileSize(hFile, NULL);
   LPBYTE pBuffer = (LPBYTE) malloc(dwFileSize);
   DWORD dwBytesRead = 0;
   ::ReadFile(hFile, pBuffer, dwFileSize, &dwBytesRead, NULL);
   ::CloseHandle(hFile);

   CXMLParser parser;
   parser.Create();

   CXmlConfig config;
   parser.SetHandler(&config);

   parser.Parse(pBuffer, dwFileSize);

   free(pBuffer);

   assert( config.sValue == L"ABC" );
   assert( config.iValue == 222 );
   assert( config.bValue == true );
   assert( config.aList.size() == 3 );
   assert( config.sDescription.length() > 20 );

   return 0;
}

