// MapTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "XmlParser.h"


class CXmlConfig : public CXMLElementHandler
{
public:
   std::map<std::wstring, std::wstring> m_map;
   std::wstring sTempName;

   void OnStartElement(LPCWSTR pszName, LPCWSTR* ppszAttribs)
   {
      if( !sTempName.empty() ) sTempName += L".";
      sTempName += pszName;
      while( *ppszAttribs != NULL ) {
         LPCWSTR pszName = *ppszAttribs++;
         std::wstring sValue = *ppszAttribs++;
         std::wstring sKey = sTempName;
         sKey += L"."; sKey += pszName;
         m_map[sKey] = sValue;
      }
   }

   void OnEndElement(LPCWSTR pszName)
   {
      size_t iPos = sTempName.find_last_of('.');
      if( iPos != std::wstring::npos ) sTempName = sTempName.erase(iPos);
   }
};


int _tmain(int argc, _TCHAR* argv[])
{
   if( argc < 2 ) {
      printf("USAGE: MapTest <xml-filename>");
      return 1;
   }

   HANDLE hFile = ::CreateFile(argv[1], GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
   if( hFile == INVALID_HANDLE_VALUE ) return 1;
   SIZE_T dwFileSize = ::GetFileSize(hFile, NULL);
   LPBYTE pBuffer = (LPBYTE) malloc(dwFileSize);
   DWORD dwBytesRead = 0;
   ::ReadFile(hFile, pBuffer, dwFileSize, &dwBytesRead, NULL);
   ::CloseHandle(hFile);

   CXMLParser parser;
   parser.Create();

   CXmlConfig config;
   parser.SetHandler(&config);

   parser.Parse(pBuffer, dwFileSize);

   free(pBuffer);

   assert( config.m_map[L"Configuration.Data.strValue"] == L"ABC" );
   assert( config.m_map[L"Configuration.Data.intValue"] == L"222" );
   assert( config.m_map[L"Configuration.Data.boolValue"] == L"true" );

   return 0;
}

