// ExpatTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include "XmlParser.h"


class CXmlConfig : public CXMLElementHandler
{
public:
   int iValue;
   bool bValue;
   std::string sValue;
   std::string sDescription;
   typedef struct ITEM { int a; };
   std::vector<ITEM> aList;

   CXmlConfig() : bValue(false), iValue(0)
   { }

   XML_DEFINE_TEMP( ITEM* pTempItem );

   BEGIN_XML_PARSE_MAP()
      BEGIN_XML_ELEMENT("Data")
         XML_ATTRIB_STR("strValue", sValue)
         XML_ATTRIB_INT("intValue", iValue)
         XML_ATTRIB_BOOL("boolValue", bValue)
      END_XML_ELEMENT()
      BEGIN_XML_ELEMENT("Item")
         XML_ATTRIB_INIT( ITEM t; aList.push_back(t); pTempItem = &aList.back(); )
         XML_ATTRIB_INT("a", pTempItem->a)
      END_XML_ELEMENT()
      XML_CHARDATA_STR("Description", sDescription)
   END_XML_PARSE_MAP()
};


int _tmain(int argc, _TCHAR* argv[])
{
   if( argc < 2 ) {
      printf("USAGE: ExpatTest <xml-filename>");
      return 1;
   }
   
   char szFilename[300] = { 0 };
   size_t cchConv = 0;
   wcstombs_s(&cchConv, szFilename, 300, argv[1], 256);

   FILE* f = NULL;
   ::fopen_s(&f, szFilename, "rb");
   if( f == NULL ) return 1;
   ::fseek(f, 0, SEEK_END);
   int iSize = ::ftell(f);
   ::fseek(f, 0, SEEK_SET);
   char* pBuffer = (char*) malloc(iSize);
   ::fread(pBuffer, (size_t) iSize, 1, f);
   ::fclose(f);

   CXMLParser parser;
   parser.Create();

   CXmlConfig config;
   parser.SetHandler(&config);

   parser.Parse(pBuffer, iSize);

   free(pBuffer);

   assert( config.sValue == "ABC" );
   assert( config.iValue == 222 );
   assert( config.bValue == true );
   assert( config.aList.size() == 3 );
   assert( config.sDescription.length() > 20 );

   return 0;
}

