// OLE DB Provider for XML
// Copyright (C) 2009-2013 Bjarke Viksoe
// All rights reserved.
//
// The code and information is provided "as-is" without
// warranty of any kind, either expressed or implied.
//
// http://www.viksoe.dk/code/
// Beware of bugs.

// Setup program for the OLE DB Provider for XML

if( checkUAC() ) main();


function checkUAC()
{
	if( WScript.Arguments.length == 0 ) {
		var WSApp = WScript.CreateObject("Shell.Application");
		WSApp.ShellExecute("wscript.exe", "\"" + WScript.ScriptFullName + "\" /uac", "", "runas", 1);
		return false;
	}
	return true;
}

function main()
{
	var bDebug = false;
	var Args = WScript.Arguments;
	if(Args.length > 0 && Args(0) == "/debug")
		bDebug = true;

	// Create shell object
	var WSShell = WScript.CreateObject("WScript.Shell");
	// Create file system object
	var FileSys = WScript.CreateObject("Scripting.FileSystemObject");

	var strValue = FileSys.GetAbsolutePathName(FileSys.GetParentFolderName(WScript.ScriptFullName));
	if(strValue == null || strValue == "")
		strValue = ".";

	var strSourceFolder = strValue;
	if(bDebug)
		WScript.Echo("Source: " + strSourceFolder);

	var oXML = null;
	if( oXML == null ) try { oXML = WScript.CreateObject("MSXML2.DOMDocument.4.0"); } catch(e) { };
	if( oXML == null ) try { oXML = WScript.CreateObject("MSXML2.DOMDocument.6.0"); } catch(e) { };
	if( oXML == null ) {
		WScript.Echo("ERROR: Microsoft XML Parser 4.0 or 6.0 must be installed.");
		return;
	}

	var ret = 0;

	if( ret == 0 ) {
		var strCmd = "regsvr32 /s \"" + strSourceFolder + "\\" + "XmlOleDb32.dll\"";
		if(bDebug)
			WScript.Echo("Cmd: " + strCmd);
		ret = WSShell.Run(strCmd, 1, true)
	}

        if( ret == 0 && WSShell.Environment("Process").Item("PROCESSOR_ARCHITECTURE") == "AMD64" ) {
		var strCmd = "regsvr32 /s \"" + strSourceFolder + "\\" + "XmlOleDb64.dll\"";
		if(bDebug)
			WScript.Echo("Cmd: " + strCmd);
		ret = WSShell.Run(strCmd, 1, true)
        }

	if( ret == 0 )
		WScript.Echo("XML OLEDB successfully registered.");
	else
		WScript.Echo("Failed to register XML OLE DB Driver.\nPlease try to register manually with REGSVR32 utility.");
}
