// ReplIcon.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "WriteRes.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#pragma pack( push )
#pragma pack( 2 )
typedef struct
{
    WORD           idReserved;   // Reserved (must be 0)
    WORD           idType;       // Resource Type (1 for icons)
    WORD           idCount;      // How many images?
    
    BYTE        bWidth;          // Width, in pixels, of the image
    BYTE        bHeight;         // Height, in pixels, of the image
    BYTE        bColorCount;     // Number of colors in image (0 if >=8bpp)
    BYTE        bReserved;       // Reserved ( must be 0)
    WORD        wPlanes;         // Color Planes
    WORD        wBitCount;       // Bits per pixel
    DWORD       dwBytesInRes;    // How many bytes in this resource?
    DWORD       dwImageOffset;   // Where in the file is this image?
} ICONDIRENTRY, *LPICONDIRENTRY;
#pragma pack( pop )

// #pragmas are used here to insure that the structure's
// packing in memory matches the packing of the EXE or DLL.
#pragma pack( push )
#pragma pack( 2 )
typedef struct 
{
   WORD            idReserved;   // Reserved (must be 0)
   WORD            idType;       // Resource type (1 for icons)
   WORD            idCount;      // How many images?
} GRPICONDIR, *LPGRPICONDIR;

typedef struct
{
   BYTE   bWidth;               // Width, in pixels, of the image
   BYTE   bHeight;              // Height, in pixels, of the image
   BYTE   bColorCount;          // Number of colors in image (0 if >=8bpp)
   BYTE   bReserved;            // Reserved
   WORD   wPlanes;              // Color Planes
   WORD   wBitCount;            // Bits per pixel
   DWORD  dwBytesInRes;         // how many bytes in this resource?
   WORD   nID;                  // the ID
} GRPICONDIRENTRY, *LPGRPICONDIRENTRY;
#pragma pack( pop )


/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;

/////////////////////////////////////////////////////////////////////////////
// Error handlers

int ErrorPrintUsage()
{
   cout << _T("USAGE: IconReplacer <res-type> <res.id> <module filename> <resource filename>") << endl;
   cout << _T("by (c) Bjarke Viksoe") << endl;
   cout << endl;
   cout << _T("E.g.: ICONREPLACER.EXE ICON #2 C:\\WinNT\\Explorer.Exe C:\\Temp\\MyIcon.ico") << endl;
   cout << endl;
   return 2; // error code
};

int ErrorPrintMessage(LPCSTR s)
{
   cout << s << endl;
   return 3;
};

int ErrorSystemMessage(LPCTSTR s)
{
   CString sErr = BfxGetErrorMessage( ::GetLastError() );
   // Print error;
   cerr << s << endl;
   cerr << (LPCTSTR)sErr << endl;
   return ErrorPrintUsage();
};

/////////////////////////////////////////////////////////////////////////////
// Misc

LPCTSTR FindIconID(LPCTSTR pstrFilename, LPCTSTR pstrID, ICONDIRENTRY &info)
{
   HINSTANCE hExe;
   HRSRC hRes;
   // Load the module
   hExe = ::LoadLibrary(pstrFilename); 
   if( hExe == NULL ) return (LPCSTR)-1;
   // Locate the icon - assume it is a ICONGROUP
   hRes = ::FindResource(hExe, pstrID, RT_GROUP_ICON); 
   if( hRes!=NULL ) {
      // Load the Icon Group into global memory. 
      LPVOID hResLoad;
      hResLoad = ::LoadResource(hExe, hRes); 
      if (hResLoad == NULL) return (LPCTSTR)-1;
      // Look for the best possible match (or just choose the first).
      GRPICONDIR *pGrp = (GRPICONDIR *)hResLoad;
      GRPICONDIRENTRY *pEntry = (GRPICONDIRENTRY *)(pGrp+1);
      UINT nBestID;
      UINT nBestScore;
      for( int i=0; i<pGrp->idCount; i++ ) {
         if( i==0 ) {
            // The first is always good!
            nBestID = pEntry->nID;
            nBestScore = 1;
         }
         // Calculate match score
         UINT nScore = 0;
         if( (pEntry->bWidth==info.bWidth) && (pEntry->bHeight==info.bHeight) ) nScore += 2;
         if( pEntry->bColorCount==info.bColorCount ) nScore += 1;
         // Better than the rest?
         if( nScore > nBestScore ) {
            nBestID = pEntry->nID;
            nBestScore = nScore;
         };
         pEntry++;
      };
      // Clean up
      ::FreeLibrary(hExe);
      return (LPCTSTR)nBestID;
   }
   // Locate the icon - assume it is a specific icon id
   hRes = ::FindResource(hExe, pstrID, RT_ICON); 
   if( hRes!=NULL ) {
      LPCTSTR ID;
      if( pstrID[0]==_T('#') ) ID = (LPCTSTR)_ttol(pstrID+1); else ID = pstrID;
      ::FreeLibrary(hExe);
      return ID;
   };
   return (LPCSTR)-1;
};


/////////////////////////////////////////////////////////////////////////////
// Main

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
   // initialize MFC and print and error on failure
   if (!AfxWinInit(::GetModuleHandle(NULL), NULL, ::GetCommandLine(), 0)) {
      cerr << _T("Fatal Error: MFC initialization failed.") << endl;
      return 1;
   }

//   test();

   if( argc<5 ) {
      ErrorPrintUsage();
      return 2;
   };

   CString sTypeArg( argv[1] );
   sTypeArg.MakeUpper();
   if( sTypeArg!=_T("ICON") ) {
      return ErrorPrintMessage(_T("Error: Unsupported resource type."));
   };

   CString sID( argv[2] );
   if( sID.IsEmpty() ) {
      return ErrorPrintMessage(_T("Error: Invalid resource ID"));
   };

   CString sModuleFilename( argv[3] );
   if( !BfxFileExists(sModuleFilename) ) {
      return ErrorPrintMessage(_T("Error: Target file does not exists?"));
   };

   CString sResourceFilename( argv[4] );
   if( !BfxFileExists(sResourceFilename) ) {
      return ErrorPrintMessage(_T("Error: Input file does not exists?"));
   };

   LPVOID lpData;
   DWORD cbData;

   // Go and open the file
   HANDLE hFile;
   BOOL fResult;
   DWORD cbRead;
   hFile = ::CreateFile(sResourceFilename,
     GENERIC_READ, 
     FILE_SHARE_READ,
     (LPSECURITY_ATTRIBUTES) NULL, 
     OPEN_EXISTING, 
     FILE_ATTRIBUTE_NORMAL, 
     (HANDLE) NULL); 
   if( hFile == INVALID_HANDLE_VALUE) { 
      return ErrorSystemMessage(_T("Error: Unable to open input file."));
   } 
   // Allocate memory
   ICONDIRENTRY dir;
   fResult = ::ReadFile(hFile, 
      &dir, 
      sizeof(dir), 
      &cbRead, 
      (LPOVERLAPPED) NULL); 
   if( fResult==FALSE ) {
      return ErrorSystemMessage(_T("Error: UnabLe to read from input file."));
   };
   if( dir.idCount != 1 ) {
      ::CloseHandle(hFile);
      return ErrorSystemMessage(_T("Error: Too many icons in source file. Only 1 is supported."));
   };
   cbData = dir.dwBytesInRes;
   lpData = ::LocalAlloc(0, cbData);
   // Spool
   ::SetFilePointer(hFile, dir.dwImageOffset, NULL, FILE_BEGIN);
   // Read actual string
   fResult = ::ReadFile(hFile, 
      lpData, 
      cbData, 
      &cbRead, 
      (LPOVERLAPPED) NULL); 
   if( fResult==FALSE ) {
      return ErrorSystemMessage(_T("Error: UnabLe to read from input file."));
   };
   ::CloseHandle(hFile);

   LPCTSTR ID = FindIconID(sModuleFilename, sID, dir);
   if( (long)ID == -1 ) {
      ::LocalFree(lpData);
      return ErrorPrintMessage(_T("Error: Cannot locate icon resource in target."));
   };

   // Prepare resource update
   HANDLE hRc;
   hRc = ::BeginUpdateResource( sModuleFilename, FALSE );
   if( hRc==NULL ) {
      ::LocalFree(lpData);
      return ErrorSystemMessage(_T("Error: Unable to open target resource."));
   };
   BOOL res;
   res = ::UpdateResource(hRc, RT_ICON, ID, MAKELANGID(LANG_NEUTRAL,SUBLANG_NEUTRAL), lpData, cbData );
   if( hRc==FALSE ) {
      ::EndUpdateResource(hRc, TRUE);
      return ErrorSystemMessage(_T("Error: Unable to write resource to file."));
   };
   res = ::EndUpdateResource(hRc, FALSE);
   if( res==FALSE ) {
      return ErrorSystemMessage(_T("Error: Unable to close updated resource file."));
   };

   // Clean up
   ::LocalFree(lpData);

   return 0;
}

