
#include <windows.h>
#include <ostream.h>
#include <tchar.h>

// Word's File-Information-Block (FIB) structure...   
typedef struct tagFIB {
      WORD magicNumber;      
      // Word 6.0: 0xA5DC      
      // Word 7.0 (95): 0xA5DC
      // Word 8.0 (97): 0xA5EC
      WORD version;   
      // >= 101 for Word 6.0 and higher...
      // Word 6.0: 101      
      // Word 7.0 (95): 104      
      // Word 8.0 (97): 105
} FIB;


LPCTSTR ConvertFileTime(FILETIME &ft)
// Helper function to convert FILETIME to string.
// NOTE: Returns a static string buffer!
{
  static TCHAR szBuffer[64]; 
  SYSTEMTIME st;
  ::FileTimeToSystemTime( &ft, &st );
  TCHAR szDate[32];
  TCHAR szTime[32];
  ::GetDateFormat( LOCALE_USER_DEFAULT, 0, &st, NULL, szDate, sizeof(szDate)/sizeof(TCHAR) );
  ::GetTimeFormat( LOCALE_USER_DEFAULT, 0, &st, NULL, szTime, sizeof(szTime)/sizeof(TCHAR) );
  ::lstrcpy( szBuffer, szDate );
  ::lstrcat( szBuffer, _T(" ") );
  ::lstrcat( szBuffer, szTime );
  return szBuffer;
};


bool Scan(LPCWSTR szFilename)
{
  IStorage *pStg = 0;

  HRESULT Hr;
  Hr = ::StgOpenStorage(szFilename,
    NULL, 
    STGM_SHARE_EXCLUSIVE | STGM_READ,
    NULL, 0, &pStg);
  if( FAILED( Hr ) ) return false;

  IStream *pStream = 0;
  Hr = pStg->OpenStream(L"WordDocument",
    NULL, 
    STGM_SHARE_EXCLUSIVE | STGM_READ,
    0, &pStream);
  if( FAILED( Hr ) ) {
    pStg->Release();
    return false;
  };

  /////////////////////////////////////////
  // We use this part to determine if
  // this is really Word
  //

  // Read Word FIB information...
  DWORD dwCount;
  FIB fib;
  pStream->Read(&fib, sizeof(FIB), &dwCount);
  // TODO: Inspect fib.magicNumber to determine Word version...
  pStream->Release();

  //////////////////////////////////////////////
  // Now read the properties we are interested
  // in.
  //

  IPropertySetStorage *pPropSetStg = 0;
  Hr = pStg->QueryInterface(IID_IPropertySetStorage,(void **)&pPropSetStg);
  if( FAILED(Hr) ) {
    pStg->Release();
    return false;
  };
  IPropertyStorage *pPropStg = 0;
  Hr = pPropSetStg->Open(FMTID_SummaryInformation, STGM_SHARE_EXCLUSIVE | STGM_READ, &pPropStg); 
  if( FAILED(Hr) ) {
    pStg->Release();
    return false;
  };

  // You could have used this instead...
  // This is implemented on WinNT40/SP2 and some Win95 (with IPROP.DLL)
  // Hr = ::StgOpenPropStg(pStg, FMTID_SummaryInformation, PROPSETFLAG_DEFAULT, 0, &pPropStg); 

  ULONG i;
  ULONG nCnt = 4;
  PROPSPEC spec[4];
  PROPVARIANT var[4];

  // Prepare property query result
  for( i=0; i<nCnt; i++ ) ::ZeroMemory(&var[i],sizeof(PROPVARIANT));

  // Specify the properties we want returned.
  // (A complete list can be found in OBJIDL.H)
  spec[0].ulKind = PRSPEC_PROPID; spec[0].propid = PIDSI_TITLE;
  spec[1].ulKind = PRSPEC_PROPID; spec[1].propid = PIDSI_AUTHOR;
  spec[2].ulKind = PRSPEC_PROPID; spec[2].propid = PIDSI_WORDCOUNT;
  spec[3].ulKind = PRSPEC_PROPID; spec[3].propid = PIDSI_CREATE_DTM;

  // Read properties...
  Hr = pPropStg->ReadMultiple(nCnt, spec, var);
  if( SUCCEEDED(Hr) ) {
    // All properties were loaded, now print them...
    cout << _T("Title: ") << var[0].pszVal << endl;
    cout << _T("Author: ") << var[1].pszVal << endl;
    cout << _T("Word count: ") << var[2].lVal << endl;
    cout << _T("FileTime created: ") << ConvertFileTime(var[3].filetime) << endl;
  };

  // Do some cleanup (::VariantClear() would do this better, but this is not a VARIANT!)
  for( i=0; i<nCnt; i++ ) if( var[i].vt==VT_BSTR ) ::SysFreeString(var[i].bstrVal);

  // Done
  pPropSetStg->Release();  
  pPropStg->Release();  

  pStg->Release();
  return true;
};

int main(int argc, char* argv[])
{
  Scan(L"C:\\temp\\test.doc");
  return 0;
}
