// ThreadManager.h: interface for the CThreadManager class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_THREADMANAGER_H__5B427D96_BB73_11D3_82E6_0080AD509054__INCLUDED_)
#define AFX_THREADMANAGER_H__5B427D96_BB73_11D3_82E6_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

typedef enum tagSessionQueueType {
   QUEUE_WAIT = 1,
   QUEUE_RUNNING = 2,
   QUEUE_STOPPED = 3,
   QUEUE_ALL = 255
} SessionQueueType;

typedef CList<CSession *, CSession *&> CSessionList;


class CThreadManager : public CObject
{
public:
   CThreadManager();
   virtual ~CThreadManager();

// Attributes
public:
   int m_nMaxThreads;
   int m_nTotalThreads;
   int m_nActiveThreads;
protected:
   CCriticalSection m_cs;
   CSessionList m_SessionQueue;
   CSessionList m_IdleQueue;
   CSessionList m_StoppedQueue;

// Operations
public:
   // Transparently fake that we are also a CCriticalSection
   operator CSyncObject *() { return &m_cs; };
   //
   void Close();
   BOOL ScheduleRun();
   void AddSession(CSession *pSession);
   //
   void ThreadSleep();
   void ThreadResume();
   void ThreadStop();
   //
   CSession *FindSession(LONG ID, SessionQueueType Type = QUEUE_ALL);
   void GetSessions(CSessionList &List, SessionQueueType Type = QUEUE_ALL);
   //
   BOOL HasRunningThreads();

protected:
   BOOL ScheduleNewThreads();
   BOOL MoveStoppedThreads();
   BOOL RemoveKilledThreads();
   BOOL CheckForKilledThreads();
   void StopRunningThreads();
};

#endif // !defined(AFX_THREADMANAGER_H__5B427D96_BB73_11D3_82E6_0080AD509054__INCLUDED_)
