// ThreadFunctions.cpp: implementation of the ThreadFunctions class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "WebPageLoader.h"
#include "ThreadFunctions.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// Helper functions
//////////////////////////////////////////////////////////////////////

BOOL BfxHasValidExtension(CString sURL, CString sExtensions, BOOL bAcceptDefault)
{
   ASSERT(sURL.Find('\\') < 0);
   
   // Check if it's a image....
   // Extract extension first
   sURL.MakeLower();
   sExtensions.MakeLower();
   int pos;
   pos = sURL.ReverseFind(_T('/'));
   if( pos >= 0 ) sURL = sURL.Mid(pos + 1);
   pos = sURL.Find(_T('?'));
   if( pos >= 0 ) sURL = sURL.Left(pos);
   pos = sURL.Find(_T('#'));
   if( pos >= 0 ) sURL = sURL.Left(pos);
   
   // Get file extension.
   // It could still be a HTML request for a path but with
   // the default HTML page (ie "/" which gets "/index.html")
   // on the server.
   pos = sURL.ReverseFind(_T('.'));
   if( pos < 0 ) 
      return bAcceptDefault;
   CString sExt = sURL.Mid(pos + 1);
   
   // Scan known extensions.
   // We look through the defined list of known image extensions
   while( !sExtensions.IsEmpty() ) {
      CString sExtension = BfxRemoveToken(sExtensions, _T(';'));
      if( sExt == sExtension ) return TRUE;
   }
   
   return FALSE;
}

BOOL BfxIsValidSession(CSession *pSession)
{
   ASSERT_VALID(pSession);
   if( pSession==NULL ) return FALSE;
   // NOTE: This is a rough copy of the CObject::IsKindOf() method.
   if( ::IsBadCodePtr((FARPROC)pSession) ) 
      return FALSE;
   if( ::IsBadReadPtr(pSession,sizeof(CSession)) ) 
      return FALSE;
   if( ::IsBadReadPtr(*(void**)pSession, sizeof(void*)) ) 
      return FALSE;
   if( ::IsBadReadPtr(pSession, pSession->GetRuntimeClass()->m_nObjectSize)) 
      return FALSE;
   return TRUE;
}

CString BfxUrlUnescape(const CString& sUrl)
{
   CString sResult;
   DWORD cchLen = MAX_URL_LEN - 1;
   HRESULT Hr = ::UrlUnescape(const_cast<LPTSTR>(static_cast<LPCTSTR>(sUrl)), sResult.GetBuffer(cchLen), &cchLen, 0U);
   sResult.ReleaseBuffer(cchLen);
   return Hr == S_OK ? sResult : sUrl;
}



//////////////////////////////////////////////////////////////////////
//
// ImageScanSession
//
//////////////////////////////////////////////////////////////////////

UINT DownloadSessionThread( LPVOID pParam )
{
   CSession *pSession = (CSession *) pParam;
   
   if( !BfxIsValidSession(pSession) ) return 1;

   ASSERT(pSession->m_Type == TYPE_IMAGESCAN || pSession->m_Type == TYPE_HTMLSCAN);
   ASSERT(pSession->m_Type == TYPE_HTMLSCAN || (!pSession->m_sFormat.IsEmpty() && pSession->m_nStartIndex <= pSession->m_nStopIndex));

   TRACE(_T("Thread %lu starts.\n"), ::GetCurrentThreadId());

   CAutoRefCount ref(pSession);

   pSession->Start();

   // First we want to validate the session...
   bool bOk = true;

   CString sProxy;
   sProxy.Format(_T("http://%s:%ld"), pSession->m_pPreferences->m_sProxy, pSession->m_pPreferences->m_iPort);

   CInternetSession inet( pSession->m_pPreferences->m_sAgentName, 
      pSession->m_iUniqueID, 
      pSession->m_pPreferences->m_bUseProxy ? INTERNET_OPEN_TYPE_PROXY : PRE_CONFIG_INTERNET_ACCESS, 
      pSession->m_pPreferences->m_bUseProxy ? static_cast<LPCTSTR>(sProxy) : NULL );

   TRY
   {
      pSession->SetState(STATE_RUNNING);

      int nItem = 0;
      while( TRUE ) 
      {         
         // Download all scheduled files...
         CDownloadFile *pFile;
         while( (pFile = pSession->GetNextDownload() ) != NULL ) 
         {
            CAutoRefCount ref(pFile);
         
            pFile->Download(pSession, &inet, ++nItem);

            // Do we need to stop
            if( pSession->m_bSleepRequest || pSession->m_bStopRequest || pSession->m_bKillRequest ) {
               pSession->Log(LOGTYPE_WARNING, IDS_LOG_INTERRUPT, "");
               break;
            }
         }
      
         // Reschedule all broken files
         BOOL res = pSession->RescheduleBrokenDownloads(pSession->m_Settings.m_nDownloadRetries);    
         if( res ) pSession->Log(LOGTYPE_LOG, IDS_LOG_RESCHEDULED, "");
      
         // No files to download anymore?
         if( pSession->GetNextDownload() == NULL )
            break;

         // Do we need to stop
         if( pSession->m_bSleepRequest || pSession->m_bStopRequest || pSession->m_bKillRequest )
            break;
      }
   }
   CATCH_ALL( e )
   {      
      ASSERT(FALSE);  // oops...
      TRACE(_T("WebPageLoader: Thread download exception caught!\n"));
   }
   END_CATCH_ALL

   inet.Close();

   // Done
   pSession->Done();

   TRACE(_T("Thread %lu is done.\n"), ::GetCurrentThreadId());

   return 0;
}

