// TargetProp.cpp : implementation file
//

#include "stdafx.h"
#include "WebPageLoader.h"
#include "TargetProp.h"
#include <shlwapi.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CTargetProp property page

IMPLEMENT_DYNCREATE(CTargetProp, CPropertyPage)

CArray<CString, CString> g_aOldPaths;


CTargetProp::CTargetProp() : CPropertyPage(CTargetProp::IDD)
{
   ASSERT(FALSE);
}

CTargetProp::CTargetProp(CSession *pSession) : CPropertyPage(CTargetProp::IDD)
{
   ASSERT_VALID(pSession);
   m_pSession = pSession;

   CSessionDataLock lock(m_pSession);

   BOOL bSuggestPath = TRUE;

   // Load from .ini file
   if( m_pSession->m_State == STATE_UNSCHEDULED && m_pSession->m_Type != TYPE_UNKNOWN )
      _OverrideWithHostSpecificSettings(bSuggestPath);

   //{{AFX_DATA_INIT(CTargetProp)
   m_bAppendSourcePath = m_pSession->m_Settings.m_bAppendSourcePath;
   m_bAppendParentPath = m_pSession->m_Settings.m_bAppendParentPath;
   m_bPreventOutsideURL = m_pSession->m_Settings.m_bPreventOutsideURL;
   m_bPreventOutsideDomain = m_pSession->m_Settings.m_bPreventOutsideDomain;
   m_bDontKeepHTML = m_pSession->m_Settings.m_bDontKeepHTML;
   m_bPrettyPath = m_pSession->m_Settings.m_bPrettyPath;
   m_sPath = m_pSession->m_Settings.m_sDownloadPath;
   m_iDurection = m_pSession->m_Settings.m_nDownloadTime;
   m_nLevel = m_pSession->m_Settings.m_nDownloadLevel;
   m_nRetries = m_pSession->m_Settings.m_nDownloadRetries;
   m_sUrl = m_pSession->m_sURL.IsEmpty() ? m_pSession->m_sSourceImage : m_pSession->m_sURL;
   //}}AFX_DATA_INIT

   // Guess target path...
   if( bSuggestPath 
       && m_pSession->m_State == STATE_UNSCHEDULED 
       && m_pSession->m_Type != TYPE_UNKNOWN ) 
   {
      _SuggestPath();

      if( m_sUrl.Find(_T("file:")) == 0 
              || (m_sUrl.GetLength() > 2 && m_sUrl[1] == _T(':')) ) 
      {
         _SetDefaultsForFileProtocol();
      }
   }

}

CTargetProp::~CTargetProp()
{
}

void CTargetProp::DoDataExchange(CDataExchange* pDX)
{
   CPropertyPage::DoDataExchange(pDX);

   //{{AFX_DATA_MAP(CTargetProp)
   DDX_Control(pDX, IDC_TARGETPATH, m_ctrlPath);
   DDX_Control(pDX, IDC_URL, m_ctrlUrl);
   DDX_Check(pDX, IDC_APPEND_SOURCE_PATH, m_bAppendSourcePath);
   DDX_Check(pDX, IDC_APPEND_PARENT_PATH, m_bAppendParentPath);
   DDX_Check(pDX, IDC_PREVENTOUTSIDE, m_bPreventOutsideURL);
   DDX_Check(pDX, IDC_PREVENTDOMAIN, m_bPreventOutsideDomain);
   DDX_Check(pDX, IDC_DONTKEEP, m_bDontKeepHTML);
   DDX_Check(pDX, IDC_PRETTYPATH, m_bPrettyPath);
   DDX_Text(pDX, IDC_TARGETPATH, m_sPath);
   DDV_MaxChars(pDX, m_sPath, 1024);
   DDX_Text(pDX, IDC_DURATION, m_iDurection);
   DDV_MinMaxInt(pDX, m_iDurection, 1, 240);
   DDX_Text(pDX, IDC_LEVEL, m_nLevel);
   DDV_MinMaxInt(pDX, m_nLevel, 1, 999);
   DDX_Text(pDX, IDC_RETRY, m_nRetries);
   DDV_MinMaxInt(pDX, m_nRetries, 0, 10);
   DDX_Text(pDX, IDC_URL, m_sUrl);
   //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CTargetProp, CPropertyPage)
   //{{AFX_MSG_MAP(CTargetProp)
   ON_NOTIFY(EN_SELCHANGE, IDC_URL, OnSelchangeUrl)
   ON_NOTIFY(EN_LINK, IDC_URL, OnLink)
   ON_BN_CLICKED(IDC_APPEND_SOURCE_PATH, OnAppendSourcePath)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTargetProp message handlers

void CTargetProp::OnOK() 
{
   ASSERT_VALID(m_pSession);

   CSessionDataLock lock(m_pSession);

   m_pSession->m_Settings.m_bAppendSourcePath = m_bAppendSourcePath;
   m_pSession->m_Settings.m_bAppendParentPath = m_bAppendParentPath;
   m_pSession->m_Settings.m_bPreventOutsideURL = m_bPreventOutsideURL;
   m_pSession->m_Settings.m_bPreventOutsideDomain = m_bPreventOutsideDomain;
   m_pSession->m_Settings.m_bDontKeepHTML = m_bDontKeepHTML;
   m_pSession->m_Settings.m_bPrettyPath = m_bPrettyPath;
   m_pSession->m_Settings.m_sDownloadPath = m_sPath;
   m_pSession->m_Settings.m_nDownloadTime = m_iDurection;
   m_pSession->m_Settings.m_nDownloadLevel = m_nLevel;
   m_pSession->m_Settings.m_nDownloadRetries = m_nRetries;

   if( g_aOldPaths.GetSize() == 3 ) 
      g_aOldPaths.RemoveAt(0);
   g_aOldPaths.Add(m_sPath);

   if( ::OpenClipboard(m_hWnd) ) {
      ::EmptyClipboard();
      ::CloseClipboard();
   }

   CPropertyPage::OnOK();
}

BOOL CTargetProp::OnInitDialog() 
{
   CPropertyPage::OnInitDialog();

   OSVERSIONINFO osvi = { 0 };
   osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);   
   ::GetVersionEx(&osvi);

   if( osvi.dwMajorVersion < 5 || (osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 0) ) 
      m_ctrlUrl.SetBackgroundColor(FALSE, ::GetSysColor(COLOR_BTNFACE));

   m_ctrlUrl.SetEventMask(ENM_SELCHANGE | ENM_LINK);

   _SetAutoComplete(m_ctrlPath);

   ::EnableWindow(*GetDlgItem(IDC_DONTKEEP), m_pSession->m_Type != TYPE_IMAGESCAN);
   ::EnableWindow(*GetDlgItem(IDC_PREVENTOUTSIDE), m_pSession->m_Type != TYPE_IMAGESCAN);
   ::EnableWindow(*GetDlgItem(IDC_PREVENTDOMAIN), m_pSession->m_Type != TYPE_IMAGESCAN);

   OnAppendSourcePath();

   m_ctrlUrl.SetSel(-1, -1);
   m_ctrlPath.SetSel(-1, -1);
   m_ctrlPath.SetFocus();
   
   return FALSE;  // return TRUE unless you set the focus to a control
                  // EXCEPTION: OCX Property Pages should return FALSE
}

void CTargetProp::OnAppendSourcePath() 
{
}

void CTargetProp::OnSelchangeUrl(NMHDR* pNMHDR, LRESULT* pResult) 
{
   SELCHANGE *pSelChange = reinterpret_cast<SELCHANGE *>(pNMHDR);

   // Bonus feature: If user selected part of the URL we format
   // it as the new download folder.
   if( pSelChange->chrg.cpMin != pSelChange->chrg.cpMax ) 
   {
      CString sText = m_ctrlUrl.GetSelText();

      sText = BfxUrlUnescape(sText);

      bool bUpperNext = true;
      for( int i = 0; i < sText.GetLength(); i++ ) {
         TCHAR ch = sText.GetAt(i);
         if( bUpperNext ) {
            sText.SetAt(i, _totupper(ch));
            bUpperNext = false;
         }
         else if( _tcschr(_T("_- \\/&+"), ch) != NULL )
            bUpperNext = true;
      }

      sText.Remove('\\');
      sText.Remove('/');
      sText.Remove(' ');
      sText.Remove('_');
      sText.Remove('+');
      sText.Remove('|');
      sText.Remove('=');
      sText.Remove('(');
      sText.Remove(')');
      sText.Remove('\'');
      sText.Remove('\"');

      if( sText.Find(_T(".htm")) >= 0 ) 
         sText = _T("");
      if( sText.Find(_T(".php")) >= 0 ) 
         sText = _T("");
      if( sText.Find(_T("www.")) >= 0 ) 
         sText = _T("");
      if( sText.Find(_T("http:")) >= 0 ) 
         sText = _T("");
      if( sText.Find(_T("https:")) >= 0 ) 
         sText = _T("");
      if( sText.Find(_T("file:")) >= 0 ) 
         sText = _T("");

      static DWORD s_dwLastTick = 0;
      static CString s_sLastPaste = sText;
      if( ::GetTickCount() - s_dwLastTick > 300 || s_sLastPaste != sText )
         if( !sText.IsEmpty() ) 
            m_ctrlPath.ReplaceSel(sText, FALSE);
      s_dwLastTick = ::GetTickCount();
      s_sLastPaste = sText;
   }

   *pResult = 0;
}

void CTargetProp::OnLink(NMHDR* pNMHDR, LRESULT* pResult) 
{
   *pResult = 0;
}

BOOL CTargetProp::OnSetActive() 
{
   m_sUrl = (m_pSession->m_sURL.IsEmpty() ? m_pSession->m_sSourceImage : m_pSession->m_sURL);
   m_ctrlUrl.SetWindowText(m_sUrl);	

   return CPropertyPage::OnSetActive();
}


/////////////////////////////////////////////////////////////////////////////
// CTargetProp helper function

void CTargetProp::_OverrideWithHostSpecificSettings(BOOL& bSuggestPath)
{
   CString sIniFile = BfxGetAppPath() + _T("WebPageLoader.ini");
   CString sKey = m_pSession->GetBaseDomain();
   int iValue;
   TCHAR szValue[200] = { 0 };
   if( (iValue = ::GetPrivateProfileInt(sKey,    _T("MaxThreads"),            -1, sIniFile)) >= 0 ) m_pSession->m_pPreferences->m_nThreads = iValue;
   if( (iValue = ::GetPrivateProfileInt(sKey,    _T("Level"),                 -1, sIniFile)) >= 0 ) m_pSession->m_Settings.m_nDownloadLevel = iValue;
   if( (iValue = ::GetPrivateProfileInt(sKey,    _T("Retries"),               -1, sIniFile)) >= 0 ) m_pSession->m_Settings.m_nDownloadRetries = iValue;
   if( (iValue = ::GetPrivateProfileInt(sKey,    _T("Timeout"),               -1, sIniFile)) >= 0 ) m_pSession->m_Settings.m_nDownloadTime = iValue;
   if( (iValue = ::GetPrivateProfileInt(sKey,    _T("SpecialTrick"),          -1, sIniFile)) >= 0 ) m_pSession->m_Settings.m_iSpecialTrick = iValue;
   if( (iValue = ::GetPrivateProfileString(sKey, _T("Randomize"),             _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_bRandomize = (szValue[0] == 'Y');
   if( (iValue = ::GetPrivateProfileString(sKey, _T("AppendPath"),            _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_bAppendSourcePath = (szValue[0] == 'Y');
   if( (iValue = ::GetPrivateProfileString(sKey, _T("DontKeepHtml"),          _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_bDontKeepHTML = (szValue[0] == 'Y');
   if( (iValue = ::GetPrivateProfileString(sKey, _T("ImagesInParentFolder"),  _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_bAppendParentPath = (szValue[0] == 'Y');
   if( (iValue = ::GetPrivateProfileString(sKey, _T("PreventOutsideURL"),     _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_bPreventOutsideURL = (szValue[0] == 'Y');
   if( (iValue = ::GetPrivateProfileString(sKey, _T("PreventOutsideDomain"),  _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_bPreventOutsideDomain = (szValue[0] == 'Y');
   if( (iValue = ::GetPrivateProfileString(sKey, _T("DownloadPath"),          _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_sDownloadPath = szValue, bSuggestPath = FALSE;
   if( (iValue = ::GetPrivateProfileInt(sKey,    _T("FileSizeFilter"),        -1, sIniFile)) >= 0 ) m_pSession->m_Settings.m_iFileSizeFilter = iValue, m_pSession->m_Settings.m_bUseFileSizeFilter = TRUE;
   if( (iValue = ::GetPrivateProfileString(sKey, _T("FilterBanners"),         _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_bSkipBanners = (szValue[0] == 'Y');
   if( (iValue = ::GetPrivateProfileString(sKey, _T("FilterReoccouring"),     _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_bPreventRepeating = (szValue[0] == 'Y');
   if( (iValue = ::GetPrivateProfileString(sKey, _T("PriorityFilter"),        _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_sPriorityFileNameFilter = szValue, m_pSession->m_Settings.m_bUsePriorityFileNameFilter = TRUE;
   if( (iValue = ::GetPrivateProfileString(sKey, _T("ExcludeFilter"),         _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_sExcludeFileNameFilter = szValue, m_pSession->m_Settings.m_bUseExcludeFileNameFilter = TRUE;
   if( (iValue = ::GetPrivateProfileString(sKey, _T("ImageTagFilter"),        _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_sImageTagFilter = szValue, m_pSession->m_Settings.m_bUseImageTagFilter = TRUE;
   if( (iValue = ::GetPrivateProfileString(sKey, _T("ImageFilenameFilter"),   _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_sImageFileNameFilter = szValue, m_pSession->m_Settings.m_bUseImageFileNameFilter = TRUE;
   if( (iValue = ::GetPrivateProfileString(sKey, _T("HtmlFilenameFilter"),    _T(""), szValue, 199, sIniFile)) > 0 ) m_pSession->m_Settings.m_sHtmlFileNameFilter = szValue, m_pSession->m_Settings.m_bUseHtmlFileNameFilter = TRUE;
}

void CTargetProp::_SetDefaultsForFileProtocol()
{
   m_nLevel = 3;
   m_bAppendSourcePath = TRUE;
   m_bAppendParentPath = FALSE;
   m_bPreventOutsideURL = FALSE;
   m_bPreventOutsideDomain = FALSE;
}

void CTargetProp::_SuggestPath()
{
   TCHAR szCommonPath1[MAX_PATH] = { 0 };
   TCHAR szCommonPath2[MAX_PATH] = { 0 };
   if( g_aOldPaths.GetSize() == 3 ) {
      if( m_sPath == m_pSession->m_Settings.m_sDownloadPath ) {
         if( ::PathCommonPrefix(g_aOldPaths.GetAt(0), g_aOldPaths.GetAt(1), szCommonPath1) > 0 ) {
            if( ::PathCommonPrefix(g_aOldPaths.GetAt(1), g_aOldPaths.GetAt(2), szCommonPath2) > 0 ) {
               if( _tcscmp(szCommonPath1, szCommonPath2) == 0 ) {
                  ::PathAddBackslash(szCommonPath1);
                  m_sPath = szCommonPath1;
               }
            }
         }
      }
      if( m_sPath == m_pSession->m_Settings.m_sDownloadPath ) {
         if( ::PathCommonPrefix(g_aOldPaths.GetAt(0), g_aOldPaths.GetAt(2), szCommonPath1) > 0 ) {
            if( ::PathCommonPrefix(szCommonPath1, g_aOldPaths.GetAt(1), szCommonPath2) > 0 ) {
               ::PathAddBackslash(szCommonPath1);
               m_sPath = szCommonPath1;
            }
         }
      }
      if( m_sPath == m_pSession->m_Settings.m_sDownloadPath ) {
         if( ::PathCommonPrefix(g_aOldPaths.GetAt(0), g_aOldPaths.GetAt(2), szCommonPath1) > 0 ) {
            ::PathAddBackslash(szCommonPath1);
            m_sPath = szCommonPath1;
         }
      }
   }
}

void CTargetProp::_SetAutoComplete(HWND hwnd, DWORD dwOptions /* = 0*/)
{
   typedef HRESULT (WINAPI *SHAUTOCOMPLETE)(HWND,DWORD);
   // A pointer-to-function-with-the-return-type-and-parameters-of-SHAutoComplete
   SHAUTOCOMPLETE pfnSHAutoComplete = 
      (SHAUTOCOMPLETE)::GetProcAddress( ::LoadLibrary(_T("SHLWAPI.DLL")), 
      "SHAutoComplete");
   if( pfnSHAutoComplete != NULL )
      pfnSHAutoComplete(hwnd, dwOptions);
}

