// ItemView.h : interface of the CSessionView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_ITEMVIEW_H__7D36D30F_BACE_11D3_82E5_0080AD509054__INCLUDED_)
#define AFX_ITEMVIEW_H__7D36D30F_BACE_11D3_82E5_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


class CSessionView : public CListView
{
protected: // create from serialization only
   CSessionView();
   DECLARE_DYNCREATE(CSessionView)

// Attributes
public:
   CDoc* GetDocument();
   CImageList m_ImageList;

// Operations
public:
   void CreateItems();
   void RefreshItems(BOOL bAll=FALSE);
   //
   int GetSelectedItem();
   LONG GetSelectedSessionID();
protected:
   void UpdateListItem(CListCtrl &ctlList, CSession *pSession, int idx, BOOL bForce);

   static int _SessionStateToImage(const CSession *pSession);

// Overrides
   // ClassWizard generated virtual function overrides
   //{{AFX_VIRTUAL(CSessionView)
   public:
   virtual void OnDraw(CDC* pDC);  // overridden to draw this view
   virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
   protected:
   virtual void OnInitialUpdate(); // called first time after construct
   //}}AFX_VIRTUAL

// Implementation
public:
   virtual ~CSessionView();
#ifdef _DEBUG
   virtual void AssertValid() const;
   virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
   //{{AFX_MSG(CSessionView)
   afx_msg void OnItemChanged(NMHDR* pNMHDR, LRESULT* pResult);
   afx_msg void OnEditRefresh();
   afx_msg void OnDelete();
   afx_msg void OnUpdateDelete(CCmdUI* pCmdUI);
   afx_msg void OnDestroy();
   afx_msg void OnTimer(UINT nIDEvent);
   afx_msg void OnDblclk(NMHDR* pNMHDR, LRESULT* pResult);
   afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
   //}}AFX_MSG
   afx_msg void OnStyleChanged(int nStyleType, LPSTYLESTRUCT lpStyleStruct);
   DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in ItemView.cpp
inline CDoc* CSessionView::GetDocument()
   { return (CDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_ITEMVIEW_H__7D36D30F_BACE_11D3_82E5_0080AD509054__INCLUDED_)
