// SessionSettings.h: interface for the CSessionSettings class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SESSIONSETTINGS_H__7E1379A3_BAEA_11D3_82E5_0080AD509054__INCLUDED_)
#define AFX_SESSIONSETTINGS_H__7E1379A3_BAEA_11D3_82E5_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma warning( disable : 4800 )


class CSessionInfo
{
public:
   CTime    m_tStarted;
   CTime    m_tStopped;
   LONGLONG m_llBytesDownloaded;
   int      m_nFilesDownloaded;
   int      m_nFilesSkipped;
   int      m_nFilesFailed;
   //
   CString m_sServer;  // HTTP Server session was started on
   CString m_sPage;    // HTTP Page  session was started on

public:
   CSessionInfo() : m_tStarted(0), m_tStopped(0), m_llBytesDownloaded(0), m_nFilesDownloaded(0), m_nFilesSkipped(0), m_nFilesFailed(0)
   { }
};


typedef enum tagDuplicate { DUP_SKIP, DUP_OVERWRITE, DUP_RENAME } Duplicate;


class CSessionSettings
{
public:
   CString m_sDownloadPath;
   bool    m_bAppendSourcePath;
   bool    m_bAppendParentPath;
   int     m_nDownloadLevel;
   int     m_nDownloadTime;
   int     m_nDownloadRetries;
   bool    m_bPreventOutsideURL;
   bool    m_bPreventOutsideDomain;
   bool    m_bDontKeepHTML;
   bool    m_bPrettyPath;
   bool    m_bRandomize;
   int     m_iSpecialTrick;
   //
   CString m_sFileExtensions;
   //
   bool    m_bUseImageFileNameFilter;
   CString m_sImageFileNameFilter;
   //
   bool    m_bUseImageTagFilter;
   CString m_sImageTagFilter;
   //
   bool    m_bUseHtmlFileNameFilter;
   CString m_sHtmlFileNameFilter;
   //
   bool    m_bUseExcludeFileNameFilter;
   CString m_sExcludeFileNameFilter;
   //
   bool    m_bUsePriorityFileNameFilter;
   CString m_sPriorityFileNameFilter;
   //
   bool    m_bUseImmediateDownload;
   //
   bool m_bUseFileSizeFilter;
   long m_iFileSizeFilter;
   //
   bool m_bSkipBanners;
   bool m_bPreventRepeating; 
   //
   Duplicate m_Duplicates;
   bool m_bPrefixRename;

public:
   CSessionSettings();

   void Load();
   void Save();
};


#endif // !defined(AFX_SESSIONSETTINGS_H__7E1379A3_BAEA_11D3_82E5_0080AD509054__INCLUDED_)
