// SessionSettings.cpp: implementation of the CSessionSettings class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "WebPageLoader.h"
#include "SessionSettings.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CSessionSettings::CSessionSettings()
{
}


void CSessionSettings::Load()
{
   CWinApp *app = AfxGetApp();
   ASSERT_VALID(app);

   static LPCTSTR szSection = _T("Session");

   m_sDownloadPath = app->GetProfileString(szSection, _T("DownloadPath"), _T("C:\\Download"));
   m_bAppendSourcePath = (bool)app->GetProfileInt(szSection, _T("AppendSourcePath"), 0);
   m_bAppendParentPath = (bool)app->GetProfileInt(szSection, _T("AppendParentPath"), 0);
   //
   m_nDownloadLevel = app->GetProfileInt(szSection, _T("DownloadLevel"), 2);
   m_nDownloadTime = app->GetProfileInt(szSection, _T("DownloadTime"), 30);
   m_nDownloadRetries = app->GetProfileInt(szSection, _T("DownloadRetries"), 5);
   m_bPreventOutsideURL = (bool)app->GetProfileInt(szSection, _T("PreventOutsideURL"), 1);
   m_bPreventOutsideDomain = (bool)app->GetProfileInt(szSection, _T("PreventOutsideDomain"), 1);
   m_bDontKeepHTML = (bool)app->GetProfileInt(szSection, _T("DontKeepHTML"), 0);
   m_bPrettyPath = (bool)app->GetProfileInt(szSection, _T("PrettyPath"), 0);
   m_bRandomize = (bool)app->GetProfileInt(szSection, _T("Randomize"), 0);
   m_sFileExtensions = app->GetProfileString(szSection, _T("FileExtensions"), _T("mp3;jpg;jpeg;jpe;gif;bmp;png"));
   //
   m_bUseHtmlFileNameFilter = (bool)app->GetProfileInt(szSection, _T("UseHtmlFileNameFilter"), 0);
   m_sHtmlFileNameFilter = app->GetProfileString(szSection, _T("HtmlFileNameFilter"), _T("*mypage*"));
   //
   m_bUseImageFileNameFilter = (bool)app->GetProfileInt(szSection, _T("UseImageFileNameFilter"), 0);
   m_sImageFileNameFilter = app->GetProfileString(szSection, _T("ImageFileNameFilter"), _T("*[0-9]*"));
   //
   m_bUseImageTagFilter = (bool)app->GetProfileInt(szSection, _T("UseImageTagFilter"), 0);
   m_sImageTagFilter = app->GetProfileString(szSection, _T("ImageTagFilter"), _T("*gallery*"));
   //
   m_bUseExcludeFileNameFilter = (bool)app->GetProfileInt(szSection, _T("UseExcludeFilter"), 0);
   m_sExcludeFileNameFilter = app->GetProfileString(szSection, _T("ExcludeFilter"), _T("*x250*"));
   //
   m_bUsePriorityFileNameFilter = (bool)app->GetProfileInt(szSection, _T("UsePriorityFilter"), 0);
   m_sPriorityFileNameFilter = app->GetProfileString(szSection, _T("PriorityFilter"), _T("*/page/*"));
   //
   m_bUseFileSizeFilter = (bool)app->GetProfileInt(szSection, _T("UseFileSizeFilter"), 1);
   m_iFileSizeFilter = app->GetProfileInt(szSection, _T("FileSizeFilter"), 10);
   //
   m_bSkipBanners = (bool)app->GetProfileInt(szSection, _T("SkipBanners"), 1);
   m_bPreventRepeating = (bool)app->GetProfileInt(szSection, _T("PreventRepeating"), 1);
   //
   m_Duplicates = (Duplicate)app->GetProfileInt(szSection, _T("DuplicateAction"), (int)DUP_SKIP);
   m_bPrefixRename = (bool)app->GetProfileInt(szSection, _T("PrefixRename"), 1);
   //
   m_bUseImmediateDownload = FALSE;
   m_iSpecialTrick = 0;
}

void CSessionSettings::Save()
{
   CWinApp *app = AfxGetApp();
   ASSERT_VALID(app);
   
   static LPCTSTR szSection = _T("Session");

   app->WriteProfileString(szSection, _T("DownloadPath"), m_sDownloadPath);
   app->WriteProfileInt(szSection, _T("AppendSourcePath"), (int)m_bAppendSourcePath);
   app->WriteProfileInt(szSection, _T("AppendParentPath"), (int)m_bAppendParentPath);
   //
   app->WriteProfileInt(szSection, _T("DownloadLevel"), m_nDownloadLevel);
   app->WriteProfileInt(szSection, _T("DownloadTime"), m_nDownloadTime);
   app->WriteProfileInt(szSection, _T("DownloadRetries"), m_nDownloadRetries);
   app->WriteProfileInt(szSection, _T("PreventOutsideURL"), (int)m_bPreventOutsideURL);
   app->WriteProfileInt(szSection, _T("PreventOutsideDomain"), (int)m_bPreventOutsideDomain);
   app->WriteProfileInt(szSection, _T("DontKeepHTML"), (int)m_bDontKeepHTML);
   app->WriteProfileInt(szSection, _T("PrettyPath"), (int)m_bPrettyPath);
   app->WriteProfileInt(szSection, _T("Randomize"), (int)m_bRandomize);
   app->WriteProfileString(szSection, _T("FileExtensions"), m_sFileExtensions);
   //
   app->WriteProfileInt(szSection, _T("UseImageFileNameFilter"), (int)m_bUseImageFileNameFilter);
   app->WriteProfileString(szSection, _T("ImageFileNameFilter"), m_sImageFileNameFilter);
   //
   app->WriteProfileInt(szSection, _T("UseHtmlFileNameFilter"), (int)m_bUseHtmlFileNameFilter);
   app->WriteProfileString(szSection, _T("HtmlFileNameFilter"), m_sHtmlFileNameFilter);
   //
   app->WriteProfileInt(szSection, _T("UseExcludeFilter"), (int)m_bUseExcludeFileNameFilter);
   app->WriteProfileString(szSection, _T("ExcludeFilter"), m_sExcludeFileNameFilter);
   //
   app->WriteProfileInt(szSection, _T("UsePriorityFilter"), (int)m_bUsePriorityFileNameFilter);
   app->WriteProfileString(szSection, _T("PriorityFilter"), m_sPriorityFileNameFilter);
   //
   app->WriteProfileInt(szSection, _T("UseFileSizeFilter"), (int)m_bUseFileSizeFilter);
   app->WriteProfileInt(szSection, _T("FileSizeFilter"), m_iFileSizeFilter);
   //
   app->WriteProfileInt(szSection, _T("SkipBanners"), (int)m_bSkipBanners);
   app->WriteProfileInt(szSection, _T("PreventRepeating"), (int)m_bPreventRepeating);
   //
   app->WriteProfileInt(szSection, _T("DuplicateAction"), (int)m_Duplicates);
   app->WriteProfileInt(szSection, _T("PrefixRename"), (int)m_bPrefixRename);
}

