// Session.h: interface for the CSession class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_SESSION_H__5B427D98_BB73_11D3_82E6_0080AD509054__INCLUDED_)
#define AFX_SESSION_H__5B427D98_BB73_11D3_82E6_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


typedef enum tagLogType {
   LOGTYPE_LOG,
   LOGTYPE_WARNING,
   LOGTYPE_ERROR
} LogType;

typedef enum tagSessionType { 
   TYPE_UNKNOWN, 
   TYPE_HTMLSCAN, 
   TYPE_IMAGESCAN 
} SessionType;

typedef enum tagSessionState { 
   STATE_UNSCHEDULED, 
   STATE_QUEUED,
   STATE_CONNECTING,
   STATE_RUNNING,
   STATE_SLEEPING,
   STATE_STOPPED,
   STATE_KILLED,
   STATE_DONE 
} SessionState;


class CLog
{
public:
   LogType Type;
   CTime tTime;
   UINT uMsgID;
   CString sPage;
};

typedef CArray<CLog, CLog&> CLogArray;


UINT __stdcall HashKey(CString key);

typedef CMap<CString, CString, char, char> CFileHashMap;


class CFileList : public CList< CDownloadFile *, CDownloadFile *& >
{
public:
   virtual ~CFileList();
};




class CSession : public CObject, public CRefCount
{
   DECLARE_DYNCREATE(CSession)
public:
   friend class CSessionDataLock;
   friend class CSessionFilesLock;
   friend class CSessionHashLock;
   friend class CSessionLogLock;
   friend class CThreadManager;
   
   volatile LONG m_iUniqueID;
   //
   SessionState m_State;      //< Current session state
   SessionState m_OldState;   //< We use this for display update detection
   bool m_bSleepRequest;      //< Someone wants to pause us as soon as possible?
   bool m_bStopRequest;       //< Someone wants us to exit as soon as possible?
   bool m_bKillRequest;       //< Someone wants us to exit not?

   SessionType m_Type;
   //
   // Type: Html Scan
   CString m_sURL;
   // Type: Image Scan
   CString m_sSourceImage;
   CString m_sFormat;
   int     m_nStartIndex;
   int     m_nStopIndex;
   //
   CString m_sUsername;
   CString m_sPassword;

   typedef CArray<HANDLE, HANDLE> CThreadArray;

   CFileList m_Files;          //< Files Manager
   CFileHashMap m_FilesHash;   //< Files hash map
   CThreadArray m_Threads;     //< Array of thread handles
   CLogArray m_Logs;           //< File download logs
   //
   CSessionInfo m_Info;
   CSessionSettings m_Settings;
   CPreferences *m_pPreferences;
   //
   CDownloadFile *m_pCurrentDownloadFile;

protected: 
   CCriticalSection m_csSession;
   CCriticalSection m_csFiles;
   CCriticalSection m_csHash;
   CCriticalSection m_csLog;

public:
   CSession();
   ~CSession();

   void Create(SessionType Type, const CSessionSettings& Info, CPreferences* pPrefs);
   //
   void Start();
   void Done();
   //
   BOOL Abort(BOOL& bWasOnline);
   //
   BOOL ScheduleNewDownload();
   BOOL RescheduleBrokenDownloads(int iMaxAttempts);
   CDownloadFile *GetNextDownload();
   //
   void Log(LogType Type, UINT uMsgID, CString sPage);
   void PostUpdate(UINT uMsg, WPARAM wParam = 0, LPARAM lParam = 0);
   //
   void SetState(SessionState State);
   CString GetBaseDomain() const;
   void RandomizeFiles(DWORD dwTimeout);
};


class CSessionDataLock : public CSingleLock
{
public:
   CSessionDataLock(CSession* pSession) : CSingleLock( &pSession->m_csSession, TRUE )
   { }
};

class CSessionFilesLock : public CSingleLock
{
public:
   CSessionFilesLock(CSession* pSession) : CSingleLock( &pSession->m_csFiles, TRUE )
   { }
};

class CSessionHashLock : public CSingleLock
{
public:
   CSessionHashLock(CSession* pSession) : CSingleLock( &pSession->m_csHash, TRUE )
   { }
};

class CSessionLogLock : public CSingleLock
{
public:
   CSessionLogLock(CSession* pSession) : CSingleLock( &pSession->m_csLog, TRUE )
   { }
};



#endif // !defined(AFX_SESSION_H__5B427D98_BB73_11D3_82E6_0080AD509054__INCLUDED_)
