#if !defined(AFX_REFCOUNT_H__20000521_845D_D551_7A12_0080AD509054__INCLUDED_)
#define AFX_REFCOUNT_H__20000521_845D_D551_7A12_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////////////
// Simple Reference Counting classes
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2018 Bjarke viksoe.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed unmodified by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//


class CRefCount
{
public:
   CRefCount() : m_lRefCount(1)
   { }

   virtual ~CRefCount()
   { }

   LONG AddRef()
   {
      return ::InterlockedIncrement(&m_lRefCount);
   }

   LONG Release()
   {
      LONG lResult;
      if( (lResult = ::InterlockedDecrement(&m_lRefCount)) == 0 )
         delete this;
      return lResult;
   }

protected:
   LONG m_lRefCount;
};


class CAutoRefCount
{
public:
   CAutoRefCount(CRefCount* pRef, BOOL bInitiallyLock = TRUE) : m_pRef(pRef), m_bLocked(FALSE)
   {
      if( bInitiallyLock )
         Lock();
   }

   ~CAutoRefCount()
   {
      Unlock();
   }
   
   void Lock()
   {
      if( m_bLocked ) 
         return;
      //m_bLocked = (m_pRef->AddRef() > 0);
      m_pRef->AddRef();
      m_bLocked = TRUE;
   }
   
   void Unlock()
   {
      if( !m_bLocked )
         return;
      m_pRef->Release();
      m_bLocked = FALSE;
   }

   BOOL IsLocked() const 
   { 
      return m_bLocked; 
   }

protected:
   CRefCount *m_pRef;
   BOOL m_bLocked;
};


#endif // !defined(AFX_REFCOUNT_H__20000521_845D_D551_7A12_0080AD509054__INCLUDED_)

