// ProxyProp.cpp : implementation file
//

#include "stdafx.h"
#include "WebPageLoader.h"
#include "ProxyProp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CProxyProp property page

IMPLEMENT_DYNCREATE(CProxyProp, CPropertyPage)

CProxyProp::CProxyProp() : CPropertyPage(CProxyProp::IDD)
{
   ASSERT(FALSE);
}

CProxyProp::CProxyProp(CSession *pSession) : CPropertyPage(CProxyProp::IDD)
{
   ASSERT_VALID(pSession);

   m_pSession = pSession;

   //{{AFX_DATA_INIT(CProxyProp)
   m_lPort = m_pSession->m_pPreferences->m_iPort;
   m_sProxy = m_pSession->m_pPreferences->m_sProxy;
   m_bUseSSL = m_pSession->m_pPreferences->m_bUseSSL;
   m_bUseProxy = m_pSession->m_pPreferences->m_bUseProxy;
   //}}AFX_DATA_INIT  
}

CProxyProp::~CProxyProp()
{
}

void CProxyProp::DoDataExchange(CDataExchange* pDX)
{
   CPropertyPage::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CProxyProp)
   DDX_Text(pDX, IDC_PORT, m_lPort);
   DDX_Text(pDX, IDC_PROXY, m_sProxy);
   DDX_Check(pDX, IDC_SSL, m_bUseSSL);
   DDX_Check(pDX, IDC_USEPROXY, m_bUseProxy);
   //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CProxyProp, CPropertyPage)
	//{{AFX_MSG_MAP(CProxyProp)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CProxyProp message handlers

void CProxyProp::OnOK() 
{
   ASSERT_VALID(m_pSession);

   CSessionDataLock lock(m_pSession);

   m_pSession->m_pPreferences->m_bUseProxy = m_bUseProxy;
   m_pSession->m_pPreferences->m_bUseSSL = m_bUseSSL;
   m_pSession->m_pPreferences->m_sProxy = m_sProxy;
   m_pSession->m_pPreferences->m_iPort = m_lPort;

   CPropertyPage::OnOK();
}
