// Preferences.cpp: implementation of the CPreferences class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "WebPageLoader.h"
#include "Preferences.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


CPreferences::CPreferences()
{
}

void CPreferences::Load()
{
   CWinApp *app = AfxGetApp();
   
   static LPCTSTR szSection = _T("Settings");

   m_nThreads = app->GetProfileInt(szSection, _T("Threads"), 4);
   m_bDeleteThreadWhenDone = (BOOL) app->GetProfileInt(szSection, _T("DeleteThreadWhenDone"), 0);
   m_bClipboardListener = (BOOL) app->GetProfileInt(szSection, _T("ClipboardListener"), 1);
   m_bCompatibilityMode = (BOOL) app->GetProfileInt(szSection, _T("CompatibilityMode"), 0);
   m_bQuitWhenDone = (BOOL) app->GetProfileInt(szSection, _T("QuitWhenDone"), 0);
   m_sAgentName = app->GetProfileString(szSection, _T("AgentName"), _T("WebPageConsumer"));
   m_bUseProxy = (BOOL) app->GetProfileInt(szSection, _T("UseProxy"), 0);
   m_bUseSSL = (BOOL) app->GetProfileInt(szSection, _T("UseSSL"), 0);
   m_sProxy = app->GetProfileString(szSection, _T("Proxy"), _T(""));
   m_iPort = app->GetProfileInt(szSection, _T("Port"), 8080);
   m_nFilesDownloaded = 0;
   m_llBytesDownloaded = 0;
}

void CPreferences::Save()
{
   CWinApp *app = AfxGetApp();

   static LPCTSTR szSection = _T("Settings");

   app->WriteProfileInt(szSection, _T("Threads"), m_nThreads);
   app->WriteProfileInt(szSection, _T("DeleteThreadWhenDone"), (int)m_bDeleteThreadWhenDone);
   app->WriteProfileInt(szSection, _T("ClipboardListener"), (int)m_bClipboardListener);
   app->WriteProfileInt(szSection, _T("CompatibilityMode"), (int)m_bCompatibilityMode);
   app->WriteProfileInt(szSection, _T("QuitWhenDone"), (int)m_bQuitWhenDone);
   app->WriteProfileString(szSection, _T("AgentName"), m_sAgentName);
   app->WriteProfileInt(szSection, _T("UseProxy"), (int)m_bUseProxy);
   app->WriteProfileInt(szSection, _T("UseSSL"), (int)m_bUseSSL);
   app->WriteProfileString(szSection, _T("Proxy"), m_sProxy);
   app->WriteProfileInt(szSection, _T("Port"), m_iPort);
}
