// PrefProp.cpp : implementation file
//

#include "stdafx.h"
#include "WebPageLoader.h"
#include "PrefProp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrefProp property page

IMPLEMENT_DYNCREATE(CPrefProp, CPropertyPage)

CPrefProp::CPrefProp() : CPropertyPage(CPrefProp::IDD)
{
   ASSERT(FALSE);
}

CPrefProp::CPrefProp(CSession *pSession) : CPropertyPage(CPrefProp::IDD)
{
   ASSERT_VALID(pSession);

   m_pSession = pSession;

   //{{AFX_DATA_INIT(CPrefProp)
   m_iThreads = m_pSession->m_pPreferences->m_nThreads;
   m_bDelete = m_pSession->m_pPreferences->m_bDeleteThreadWhenDone;
   m_bClipboard = m_pSession->m_pPreferences->m_bClipboardListener;
   m_bCompatibility = m_pSession->m_pPreferences->m_bCompatibilityMode;
   m_bQuit = m_pSession->m_pPreferences->m_bQuitWhenDone;
   m_nBrowser = -1;
   //}}AFX_DATA_INIT

   if( m_pSession->m_pPreferences->m_sAgentName.Find(_T("WebPageConsumer"))>=0 ) 
      m_nBrowser = 0;
   else if( m_pSession->m_pPreferences->m_sAgentName.Find(_T("Microsoft"))>=0 ) 
      m_nBrowser = 1;
   else if( m_pSession->m_pPreferences->m_sAgentName.Find(_T("MSIE"))>=0 ) 
      m_nBrowser = 1;
   else
      m_nBrowser = 0; // default (if illegal name)
   
}

CPrefProp::~CPrefProp()
{
}

void CPrefProp::DoDataExchange(CDataExchange* pDX)
{
   CPropertyPage::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CPrefProp)
   DDX_Text(pDX, IDC_THREADS, m_iThreads);
   DDV_MinMaxInt(pDX, m_iThreads, 1, 16);
   DDX_Check(pDX, IDC_DELETEWHENDONE, m_bDelete);
   DDX_Check(pDX, IDC_CLIPBOARD, m_bClipboard);
   DDX_Check(pDX, IDC_COMPATIBILITY, m_bCompatibility);
   DDX_Check(pDX, IDC_QUITWHENDONE, m_bQuit);
   DDX_CBIndex(pDX, IDC_BROWSER, m_nBrowser);
   //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPrefProp, CPropertyPage)
   //{{AFX_MSG_MAP(CPrefProp)
      // NOTE: the ClassWizard will add message map macros here
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPrefProp message handlers

void CPrefProp::OnOK() 
{
   ASSERT_VALID(m_pSession);

   CSessionDataLock lock(m_pSession);

   m_pSession->m_pPreferences->m_nThreads = m_iThreads;
   m_pSession->m_pPreferences->m_bDeleteThreadWhenDone = m_bDelete;
   m_pSession->m_pPreferences->m_bClipboardListener = m_bClipboard;
   m_pSession->m_pPreferences->m_bQuitWhenDone = m_bQuit;
   m_pSession->m_pPreferences->m_bCompatibilityMode = m_bCompatibility;

   switch( m_nBrowser ) {
   case 0:
      m_pSession->m_pPreferences->m_sAgentName = _T("WebPageConsumer");
      break;
   case 1:
      m_pSession->m_pPreferences->m_sAgentName = _T("Mozilla/4.0 (compatible; MSIE 9.0; Windows NT 5.0)");
      break;
   }

   CPropertyPage::OnOK();
}
