// MainProp.cpp : implementation file
//

#include "stdafx.h"
#include "WebPageLoader.h"
#include "MainProp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHtmlProp property page

IMPLEMENT_DYNCREATE(CHtmlProp, CPropertyPage)

static CString s_sOldUrl;
static CString s_sOldUsername;
static CString s_sOldPassword;


CHtmlProp::CHtmlProp() : CPropertyPage(CHtmlProp::IDD)
{
   ASSERT(FALSE);
}

CHtmlProp::CHtmlProp(CSession *pSession) : CPropertyPage(CHtmlProp::IDD)
{
   ASSERT_VALID(pSession);

   m_pSession = pSession;

   CSessionDataLock lock(m_pSession);

   //{{AFX_DATA_INIT(CHtmlProp)
   m_sURL = m_pSession->m_sURL;
   m_sUsername = m_pSession->m_sUsername;
   m_sPassword = m_pSession->m_sPassword;
   //}}AFX_DATA_INIT
}

CHtmlProp::~CHtmlProp()
{
}

void CHtmlProp::DoDataExchange(CDataExchange* pDX)
{
   CPropertyPage::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CHtmlProp)
   DDX_Control(pDX, IDC_URL, m_ctlURL);
   DDX_Text(pDX, IDC_URL, m_sURL);
   DDV_MaxChars(pDX, m_sURL, 1024);
   DDX_Text(pDX, IDC_USERNAME, m_sUsername);
   DDX_Text(pDX, IDC_PASSWORD, m_sPassword);
   //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CHtmlProp, CPropertyPage)
   //{{AFX_MSG_MAP(CHtmlProp)
   ON_EN_KILLFOCUS(IDC_USERNAME, OnKillfocusUsername)
   ON_EN_CHANGE(IDC_URL, OnChangeUrl)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHtmlProp message handlers

BOOL CHtmlProp::OnInitDialog() 
{
   CPropertyPage::OnInitDialog();
   
   BOOL bAllowEdit = (m_pSession->m_State == STATE_UNSCHEDULED || m_pSession->m_State == STATE_QUEUED);

   m_ctlURL.SetReadOnly( !bAllowEdit );
   
   // Use password from previous URL
   if( m_sURL.Left(15) == s_sOldUrl.Left(15) ) {
      m_sUsername = s_sOldUsername;
      m_sPassword = s_sOldPassword;      
   }

   UpdateData(FALSE);

   return TRUE;  // return TRUE unless you set the focus to a control
                 // EXCEPTION: OCX Property Pages should return FALSE
}

void CHtmlProp::OnOK() 
{
   ASSERT_VALID(m_pSession);

   // Clean up the URL string from all the crap
   // a user with 10 thumbs may have caused :-)
   m_sURL.Remove(_T('\r'));
   m_sURL.Remove(_T('\n'));
   m_sURL.Remove(_T('\t'));
   m_sURL.TrimLeft();
   m_sURL.TrimRight();

   m_sURL = BfxUrlUnescape(m_sURL);

   if( !m_sUsername.IsEmpty() ) {
      s_sOldUrl = m_sURL;
      s_sOldUsername = m_sUsername;
      s_sOldPassword = m_sPassword;
   }

   CSessionDataLock lock(m_pSession);

   m_pSession->m_sURL = m_sURL;
   m_pSession->m_sUsername = m_sUsername;
   m_pSession->m_sPassword = m_sPassword;

   lock.Unlock();
   
   CPropertyPage::OnOK();
}

void CHtmlProp::OnKillfocusUsername() 
{
   UpdateData(TRUE);

   if( m_sUsername == s_sOldUsername && !m_sUsername.IsEmpty() ) 
      m_sPassword = s_sOldPassword;

   UpdateData(FALSE);
}

BOOL CHtmlProp::OnApply() 
{
   // TODO: Add your specialized code here and/or call the base class
   return CPropertyPage::OnApply();
}

void CHtmlProp::OnChangeUrl() 
{
   UpdateData(TRUE);
}
