// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include "WebPageLoader.h"

#include "MainFrm.h"
#include "Doc.h"

#include "SessionView.h"
#include "LogView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TIMER_ID 11


/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
   //{{AFX_MSG_MAP(CMainFrame)
   ON_WM_CREATE()
   ON_WM_CLOSE()
   ON_WM_TIMER()
   ON_COMMAND(ID_TOOL_WEBPAGEMAKE, OnToolWebpagemake)
   ON_UPDATE_COMMAND_UI(ID_TOOL_WEBPAGEMAKE, OnUpdateToolWebpagemake)
   //}}AFX_MSG_MAP
   // Global help commands
   ON_UPDATE_COMMAND_UI_RANGE(ID_VIEW_LOG, ID_VIEW_FILES, OnUpdateViewStyles)
   ON_COMMAND_RANGE(ID_VIEW_LOG, ID_VIEW_FILES, OnViewStyle)
   //
   ON_COMMAND(ID_HELP, CFrameWnd::OnHelp)
   ON_COMMAND(ID_CONTEXT_HELP, CFrameWnd::OnContextHelp)
   ON_COMMAND(ID_DEFAULT_HELP, CFrameWnd::OnHelpFinder)
   ON_MESSAGE(WM_POWERBROADCAST, OnPowerBroadcast) 
   // Custom
   ON_MESSAGE(WM_SCHEDULE, OnSchedule) 
   ON_MESSAGE(WM_CREATEITEMS, OnCreateItems) 
   ON_MESSAGE(WM_CREATENODES, OnCreateNodes) 
   ON_MESSAGE(WM_CREATENODES_REMAINING, OnCreateNodesRemaining) 
   ON_MESSAGE(WM_REFRESHITEMS, OnRefreshItems) 
   ON_MESSAGE(WM_REFRESHNODES, OnRefreshNodes) 
END_MESSAGE_MAP()

static LPCTSTR szSection = _T("Settings");

static UINT indicators[] =
{
   ID_SEPARATOR,           // status line indicator
   ID_SEPARATOR,
   ID_SEPARATOR,
   ID_SEPARATOR,
};


/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
{
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
   CWinApp *app = AfxGetApp();

   if( CFrameWnd::OnCreate(lpCreateStruct) == -1 )
      return -1;
   
   if( !m_wndToolBar.CreateEx(this) ||
       !m_wndToolBar.LoadToolBar(IDR_MAINFRAME) )
   {
      TRACE0("Failed to create toolbar\n");
      return -1;      // fail to create
   }

   if( !m_wndReBar.Create(this) ||
       !m_wndReBar.AddBar(&m_wndToolBar) )
   {
      TRACE0("Failed to create rebar\n");
      return -1;      // fail to create
   }

   if( !m_wndStatusBar.Create(this) ||
       !m_wndStatusBar.SetIndicators(indicators,
       sizeof(indicators)/sizeof(UINT)) )
   {
      TRACE0("Failed to create status bar\n");
      return -1;      // fail to create
   }

   UINT id;
   UINT style;
   int xsize;
   m_wndStatusBar.GetPaneInfo(1, id, style, xsize);
   m_wndStatusBar.SetPaneInfo(1, id, SBPS_NOBORDERS, 10);
   m_wndStatusBar.GetPaneInfo(2, id, style, xsize);
   m_wndStatusBar.SetPaneInfo(2, id, style, 218);
   m_wndStatusBar.SetPaneInfo(3, id, SBPS_NOBORDERS, 10);

   m_wndToolBar.SetBarStyle(m_wndToolBar.GetBarStyle() |
      CBRS_TOOLTIPS | CBRS_FLYBY);

   CRect rc( 0, 0, 50, 20 );
   m_wndClipboard.CreateEx(0,
         AfxRegisterWndClass(
            0,
            ::LoadCursor(NULL, IDC_ARROW),
            (HBRUSH)(COLOR_WINDOW + 1)),
         _T("WebPageLoader Clipboard listener"),
         WS_POPUP,
         rc,
         this,
         0);

   // Resize window
   CString s;
   s = app->GetProfileString(szSection, _T("Window"), _T("30,30,600,300"));
   int x, y, width, height;
   if( 4 == _stscanf( s, _T("%d,%d,%d,%d"), &x, &y, &width, &height ) )
      SetWindowPos(NULL, x, y, width, height, 0);

   SetTimer(TIMER_ID, 5000, NULL);

    return 0;
}

BOOL CMainFrame::OnCreateClient(LPCREATESTRUCT /*lpcs*/,
                                CCreateContext* pContext)
{
   CWinApp *app = AfxGetApp();

   // Create splitter window
   if( !m_wndSplitter.CreateStatic(this, 2, 1) )
      return FALSE;

   int split_cy = app->GetProfileInt(szSection, _T("SplitterHeight"), 100);

   if( !m_wndSplitter.CreateView(0, 0, RUNTIME_CLASS(CSessionView), CSize(100, split_cy), pContext) ||
       !m_wndSplitter.CreateView(1, 0, RUNTIME_CLASS(CLogView), CSize(100, 100), pContext) )
   {
      m_wndSplitter.DestroyWindow();
      return FALSE;
   }

   return TRUE;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
   if( !CFrameWnd::PreCreateWindow(cs) ) 
      return FALSE;
   cs.style &= (~FWS_ADDTOTITLE);
   return TRUE;
}


void CMainFrame::OnClose() 
{
   CWinApp *app = AfxGetApp();

   CDoc *pDoc = (CDoc *)GetActiveDocument();

   if( pDoc->m_ThreadManager.HasRunningThreads() )
      if( IDNO == AfxMessageBox(IDS_STILL_RUNNING, MB_YESNO | MB_ICONQUESTION) ) 
         return;

   GetTopPane()->SetFocus();

   pDoc->m_ThreadManager.Close();

   // Write window position and size...
   if( !IsIconic() ) {
      CRect rc;
      GetWindowRect(&rc);
      CString s;
      s.Format(_T("%d,%d,%d,%d"), rc.left, rc.top, rc.Width(), rc.Height());
      app->WriteProfileString(szSection, _T("Window"), s);
   }
   
   CFrameWnd::OnClose();
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
   CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
   CFrameWnd::Dump(dc);
}

#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// Helpers

CSessionView* CMainFrame::GetTopPane()
{
   CWnd* pWnd = m_wndSplitter.GetPane(0, 0);
   CSessionView* pView = DYNAMIC_DOWNCAST(CSessionView, pWnd);
   return pView;
}

CLogView* CMainFrame::GetBottomPane()
{
   CWnd* pWnd = m_wndSplitter.GetPane(1, 0);
   CLogView* pView = DYNAMIC_DOWNCAST(CLogView, pWnd);
   return pView;
}


/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers

LRESULT CMainFrame::OnPowerBroadcast(WPARAM wParam, LPARAM lParam)
{
   if( wParam == PBT_APMQUERYSUSPEND ) {
      CDoc *pDoc = (CDoc*) GetActiveDocument();
      ASSERT_KINDOF(CDoc,pDoc);
      if( pDoc->m_ThreadManager.m_nActiveThreads > 0 ) 
         return BROADCAST_QUERY_DENY;
   }
   return CMainFrame::Default();
} 

LRESULT CMainFrame::OnSchedule(WPARAM wParam, LPARAM lParam)
{
   OnTimer(TIMER_ID);
   return 0;
} 

void CMainFrame::OnTimer(UINT nIDEvent) 
{
   if( nIDEvent==TIMER_ID ) 
   {
      CDoc *pDoc = (CDoc *)GetActiveDocument();
      ASSERT_KINDOF(CDoc,pDoc);

      pDoc->ThreadSchedule();

      // The file download status needs regular updates.
      // (It shows how many bytes downloaded)
      if( GetBottomPane()->m_dwStyle == ID_VIEW_STATUS )
         GetBottomPane()->RefreshItems();
   }

   CFrameWnd::OnTimer(nIDEvent);
}

LRESULT CMainFrame::OnCreateItems(WPARAM wParam, LPARAM lParam)
{
   CWaitCursor cursor;

   // Remove queued messages
   MSG msg = { 0 }; 
   while( ::PeekMessage(&msg, m_hWnd, WM_CREATEITEMS, WM_CREATEITEMS, PM_REMOVE) ) 
      /* */;
   
   // Update
   GetTopPane()->CreateItems();
   
   return (LRESULT)0;
} 

LRESULT CMainFrame::OnClearNodes(WPARAM wParam, LPARAM lParam)
{
   CWaitCursor cursor;
   
   GetBottomPane()->ClearItems();
   
   return (LRESULT)0;
}

LRESULT CMainFrame::OnCreateNodes(WPARAM wParam, LPARAM lParam)
{
   CWaitCursor cursor;

   // Remove queued messages
   MSG msg = { 0 }; 
   while( ::PeekMessage(&msg, m_hWnd, WM_CREATENODES, WM_CREATENODES, PM_REMOVE) ) 
      /* */;
   
   // Update
   GetBottomPane()->CreateItems();

   return (LRESULT)0;
}

LRESULT CMainFrame::OnCreateNodesRemaining(WPARAM wParam, LPARAM lParam)
{
   static HCURSOR hcurWait = ::LoadCursor(NULL, MAKEINTRESOURCE(IDC_APPSTARTING));
   HCURSOR hcurPrev = ::SetCursor(hcurWait);
   
   GetBottomPane()->CreateItemsRemaining();
   
   ::SetCursor(hcurPrev);
   return (LRESULT)0;
}

LRESULT CMainFrame::OnRefreshItems(WPARAM wParam, LPARAM lParam)
{
   // Remove queued messages
   MSG msg = { 0 }; 
   while( ::PeekMessage(&msg, m_hWnd, WM_REFRESHITEMS, WM_REFRESHITEMS, PM_REMOVE) ) 
      /* */;
   
   // Update
   GetTopPane()->RefreshItems();  
   
   return (LRESULT)0;
} 

LRESULT CMainFrame::OnRefreshNodes(WPARAM wParam, LPARAM lParam)
{
   // wParam must be the SessionID of the currently selected
   // Session or if we saw multiple refresh we just update stuff!
   BOOL bRefresh = (GetTopPane()->GetSelectedSessionID() == (LONG)wParam);
   
   // Remove queued messages
   MSG msg = { 0 }; 
   while( ::PeekMessage(&msg, m_hWnd, WM_REFRESHITEMS, WM_REFRESHITEMS, PM_REMOVE) ) 
      bRefresh |= (GetTopPane()->GetSelectedSessionID() == (LONG)msg.wParam);
   
   if( bRefresh ) 
      GetBottomPane()->RefreshItems();

   return (LRESULT)0;
};

void CMainFrame::OnUpdateViewStyles(CCmdUI* pCmdUI)
{
   CLogView *pView = GetBottomPane();
   if( pView == NULL )
      pCmdUI->Enable(FALSE);
   else {
      pCmdUI->Enable();
      DWORD dwStyle = pView->m_dwStyle;
      BOOL bChecked = FALSE;
      switch( pCmdUI->m_nID ) {
      case ID_VIEW_LOG:
         bChecked = (dwStyle == ID_VIEW_LOG);
         break;
      case ID_VIEW_STATUS:
         bChecked = (dwStyle == ID_VIEW_STATUS);
         break;
      case ID_VIEW_FILES:
         bChecked = (dwStyle == ID_VIEW_FILES);
         break;
      default:
         bChecked = FALSE;
         break;
      }
      pCmdUI->SetRadio(bChecked ? 1 : 0);
   }
}

void CMainFrame::OnViewStyle(UINT nCommandID)
{
   CLogView* pView = GetBottomPane();
   if (pView == NULL) return;
   pView->m_dwStyle = nCommandID;
   OnCreateNodes(0, 0);
   m_wndSplitter.SetActivePane(0, 0);
};

void CMainFrame::OnToolWebpagemake() 
{
   CString sFilename = BfxGetAppPath() + _T("WebPageMaker.exe");
   ::ShellExecute(m_hWnd, _T("open"), sFilename, NULL, NULL, SW_SHOW);
}

void CMainFrame::OnUpdateToolWebpagemake(CCmdUI* pCmdUI) 
{
   static BOOL s_bUpdated = FALSE;
   static BOOL s_bEnabled = FALSE;
   if( !s_bUpdated ) {
      CString sFilename = BfxGetAppPath() + _T("WebPageMaker.exe");
      s_bEnabled = BfxFileExists(sFilename);
      s_bUpdated = TRUE;
   }
   pCmdUI->Enable(s_bEnabled);
}

