// FileView.h : interface of the CLogView class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_FILEVIEW_H__7D36D311_BACE_11D3_82E5_0080AD509054__INCLUDED_)
#define AFX_FILEVIEW_H__7D36D311_BACE_11D3_82E5_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CDoc;

class CLogView : public CListView
{
protected: // create from serialization only
   CLogView();
   DECLARE_DYNCREATE(CLogView)

// Attributes
public:
   CDoc* GetDocument();
   CImageList m_ImageList;
   DWORD m_dwStyle;
   int m_iLastActive;

// Operations
public:
   void ClearItems();
   void CreateItems();
   void CreateItemsRemaining();
   void RefreshItems();

protected:
   void _RefreshLogs();
   void _RefreshFiles();
   void _RefreshStatus();
   void _GetLogCache(int iFromIdx, int iToIdx);
   void _GetFileCache(int iFromIdx, int iToIdx);
   void _GetStatusCache(int iFromIdx, int iToIdx);
   void _GetSelectedFiles(CSession* pSession, CArray<CDownloadFile*, CDownloadFile*&>& aFiles);

   static int _FileStateToImage(const CDownloadFile* pFile);

// Overrides
   // ClassWizard generated virtual function overrides
   //{{AFX_VIRTUAL(CLogView)
   public:
   virtual void OnDraw(CDC* pDC);  // overridden to draw this view
   virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
   protected:
   virtual void OnInitialUpdate(); // called first time after construct
   //}}AFX_VIRTUAL

// Implementation
public:
   virtual ~CLogView();
#ifdef _DEBUG
   virtual void AssertValid() const;
   virtual void Dump(CDumpContext& dc) const;
#endif

protected:
   typedef struct CACHEITEM {
      int iItem;
      CString sTitle;
      int iImage;
   } CACHEITEM;
   
   CArray<CACHEITEM, CACHEITEM&> m_aCache;

// Generated message map functions
protected:
   //{{AFX_MSG(CLogView)
   afx_msg void OnEditRefresh();
   afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
   afx_msg void OnSize(UINT nType, int cx, int cy);
   afx_msg void OnDelete();
   afx_msg void OnGivePriority();
   afx_msg void OnMoveUp();
   afx_msg void OnMoveDown();
   afx_msg void OnRandomize();
   afx_msg void OnCopy();
   afx_msg void OnOpenBrowser();
   afx_msg void OnGotoActive();
   afx_msg void OnIgnoreFilename();
   afx_msg void OnIgnoreDomain();
   afx_msg void OnUpdateDelete(CCmdUI* pCmdUI);
   afx_msg void OnUpdateGivePriority(CCmdUI* pCmdUI);
   afx_msg void OnUpdateMoveUp(CCmdUI* pCmdUI);
   afx_msg void OnUpdateMoveDown(CCmdUI* pCmdUI);
   afx_msg void OnUpdateCopy(CCmdUI* pCmdUI);
   afx_msg void OnUpdateOpenBrowser(CCmdUI* pCmdUI);
   afx_msg void OnUpdateRandomize(CCmdUI* pCmdUI);
   afx_msg void OnUpdateGotoActive(CCmdUI* pCmdUI);
   afx_msg void OnUpdateIgnoreFilename(CCmdUI* pCmdUI);
   afx_msg void OnUpdateIgnoreDomain(CCmdUI* pCmdUI);
	afx_msg void OnGetdispInfo(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnOdcacheHint(NMHDR* pNMHDR, LRESULT* pResult);
	//}}AFX_MSG
   DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in FileView.cpp
inline CDoc* CLogView::GetDocument()
   { return (CDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_FILEVIEW_H__7D36D311_BACE_11D3_82E5_0080AD509054__INCLUDED_)
