// ImageProp.cpp : implementation file
//

#include "stdafx.h"
#include "WebPageLoader.h"
#include "ImageProp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CImageProp property page

IMPLEMENT_DYNCREATE(CImageProp, CPropertyPage)

static CString s_sOldUrl;
static CString s_sOldUsername;
static CString s_sOldPassword;


CImageProp::CImageProp() : CPropertyPage(CImageProp::IDD)
{
   ASSERT(FALSE);
}

CImageProp::CImageProp(CSession *pSession) : CPropertyPage(CImageProp::IDD)
{
   ASSERT_VALID(pSession);
   m_pSession = pSession;
   m_iMin = m_iMax = 0;

   CSessionDataLock lock(m_pSession);

   //{{AFX_DATA_INIT(CImageProp)
   m_sDestImage = m_sImage;
   m_sImage = m_pSession->m_sSourceImage;
   m_sFormat = m_pSession->m_sFormat;
   m_nStartIndex = m_pSession->m_nStartIndex;
   m_nStopIndex = m_pSession->m_nStopIndex;
   m_sCount.Format(_T("%d"), m_nStopIndex - m_nStartIndex + 1);
   m_sUsername = m_pSession->m_sUsername;
   m_sPassword = m_pSession->m_sPassword;
   //}}AFX_DATA_INIT
}

CImageProp::~CImageProp()
{
}

void CImageProp::DoDataExchange(CDataExchange* pDX)
{
   CPropertyPage::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CImageProp)
   DDX_Control(pDX, IDC_SRCFILENAME, m_ctlSrcFilename);
   DDX_Control(pDX, IDC_SPIN, m_ctlSpin);
   DDX_Text(pDX, IDC_DESTFILENAME, m_sDestImage);
   DDX_Text(pDX, IDC_SRCFILENAME, m_sImage);
   DDV_MaxChars(pDX, m_sImage, 1024);
   DDX_Text(pDX, IDC_COUNT, m_sCount);
   DDX_Text(pDX, IDC_USERNAME, m_sUsername);
   DDX_Text(pDX, IDC_PASSWORD, m_sPassword);
   //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CImageProp, CPropertyPage)
   //{{AFX_MSG_MAP(CImageProp)
   ON_EN_CHANGE(IDC_SRCFILENAME, OnChangeSrcFilename)
   ON_EN_KILLFOCUS(IDC_USERNAME, OnKillfocusUsername)
   ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN, OnDeltaposSpin)
   ON_EN_SETFOCUS(IDC_SRCFILENAME, OnSetfocusSrcFilename)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CImageProp message handlers

BOOL CImageProp::OnInitDialog() 
{
   CPropertyPage::OnInitDialog();

   BOOL bAllowEdit = m_pSession->m_State == STATE_UNSCHEDULED || m_pSession->m_State == STATE_QUEUED;
   m_ctlSrcFilename.SetReadOnly( !bAllowEdit );
   m_ctlSpin.EnableWindow( bAllowEdit );
   
   if( bAllowEdit )
      OnChangeSrcFilename();
   else
      m_sDestImage.Format(m_sFormat, m_nStopIndex);

   UpdateData(FALSE);
   
   return TRUE;  // return TRUE unless you set the focus to a control
                 // EXCEPTION: OCX Property Pages should return FALSE
}

void CImageProp::OnOK() 
{
   ASSERT_VALID(m_pSession);

   if( !AfxIsValidAddress(m_pSession, sizeof(*m_pSession)) ) {
      CPropertyPage::OnOK();
      return;
   }

   // Clean up the URL string from all the crap
   // a user with 10 thumbs may have caused :-)
   m_sURL.Remove(_T('\r'));
   m_sURL.Remove(_T('\n'));
   m_sURL.Remove(_T('\t'));
   m_sURL.TrimLeft();
   m_sURL.TrimRight();

   m_sURL.Replace(_T("%20"), _T(" ")); // TODO: Use ::InternetCrackUrl
   m_sURL.Replace(_T("%7E"), _T("~")); // TODO: Use ::InternetCrackUrl
   m_sURL.Replace(_T("%7e"), _T("~")); // TODO: Use ::InternetCrackUrl
   m_sURL.Replace(_T("%25"), _T("%")); // TODO: Use ::InternetCrackUrl

   CSessionDataLock lock(m_pSession);

   m_pSession->m_sURL = m_sURL;
   m_pSession->m_sSourceImage = m_sImage;
   m_pSession->m_sFormat = m_sFormat;
   m_pSession->m_nStartIndex = m_nStartIndex;
   m_pSession->m_nStopIndex = m_nStopIndex;

   if( !m_sUsername.IsEmpty() ) {
      s_sOldUrl = m_sURL;
      s_sOldUsername = m_sUsername;
      s_sOldPassword = m_sPassword;
   }

   m_pSession->m_sUsername = m_sUsername;
   m_pSession->m_sPassword = m_sPassword;

   CPropertyPage::OnOK();
}

void CImageProp::OnChangeSrcFilename() 
{
   UpdateData(TRUE);

   m_sURL.Empty();
   m_sFormat.Empty();
   m_sDestImage = m_sImage;
   m_iMin = m_iMax = 0;

   CString s;
   CString sURL;
   s = m_sImage;
   s.MakeLower();

   if( s.Left(7) != _T("http://") ) {
      CPropertySheet *pSheet = (CPropertySheet *)GetParent();
      ASSERT_KINDOF(CPropertySheet,pSheet);
      UpdateData(FALSE);
      return;
   }
   if( s.Left(8) != _T("https://") ) {
      CPropertySheet *pSheet = (CPropertySheet *)GetParent();
      ASSERT_KINDOF(CPropertySheet,pSheet);
      UpdateData(FALSE);
      return;
   }

   // Use password from previous URL
   if( s.Left(15) == s_sOldUrl.Left(15) ) {
      m_sUsername = s_sOldUsername;
      m_sPassword = s_sOldPassword;      
   }

   int i;

   // Find the counter
   int digit_pos;
   digit_pos = 0;
   for( i = s.GetLength() - 1; i >= 0; i-- ) {
      TCHAR c = s[i];
      if( c==_T('/') ) 
         break;
      if( c==_T(':') ) 
         break;
      if( c==_T('\\') ) 
         break;
      if( _istdigit(c) ) { 
         digit_pos = i; 
         break; 
      }
   }
   if( digit_pos == 0 ) {
      UpdateData(FALSE);
      return;
   }

   // Count how many digits and get default index
   int digit_len = 0;
   CString sIndex;
   m_iMax = 0;
   for( i = digit_pos; i >= 0; i-- ) {
      TCHAR c = s[i];
      if( !_istdigit(c) ) 
         break;
      sIndex = CString(c) + sIndex;
      digit_len++;
      m_iMax = 9 + (m_iMax * 10);
      if( digit_len == 8 ) 
         break;
   };

   // Build format string
   s = m_sImage.Left(digit_pos - digit_len + 1);
   sURL = s;
   if( digit_len > 1 ) {
      CString tmp;
      tmp.Format(_T("%%0%dd"), digit_len);
      s += tmp;
      sURL += CString(_T('?'), digit_len);
   }
   else {
      s += _T("%d");
      sURL += _T('?');
      m_iMax = 999;
   }
   if( digit_pos < m_sImage.GetLength() ) {
      s += m_sImage.Mid(digit_pos+1);
      sURL += m_sImage.Mid(digit_pos+1);
   }

   // Ok, set new data
   long idx = _ttol(sIndex);
   m_iMin = idx;
   m_sFormat = s;
   m_nStartIndex = idx;
   m_nStopIndex = idx;
   m_sURL = sURL;
   m_sDestImage.Format(s, idx);
   m_ctlSpin.SetRange32(m_iMin,m_iMax);
   m_ctlSpin.SetPos(idx);
   m_sCount = _T("1");

   UpdateData(FALSE);
}

void CImageProp::OnDeltaposSpin(NMHDR* pNMHDR, LRESULT* pResult) 
{
   NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;

   UpdateData(TRUE);

   // Calc new position
   int pos = pNMUpDown->iPos + pNMUpDown->iDelta;
   if( pos < m_iMin ) pos = m_iMin;
   if( pos > m_iMax ) pos = m_iMax;
   m_nStopIndex = pos;
   m_sDestImage.Format(m_sFormat, pos);
   // Set number of images
   m_sCount.Format(_T("%ld"), pos - m_iMin + 1);

   UpdateData(FALSE);

   if( !AfxIsValidAddress(m_pSession, sizeof(*m_pSession)) ) {
      m_ctlSrcFilename.SetReadOnly( TRUE );
      m_ctlSpin.EnableWindow( FALSE );
   }

   *pResult = 0;
}

void CImageProp::OnSetfocusSrcFilename() 
{
   m_ctlSrcFilename.SetSel(0,-1,TRUE);
}

BOOL CImageProp::OnKillActive() 
{
   if( m_sFormat.IsEmpty() ) {
      AfxMessageBox(IDS_ERR_IMAGEURL);
      return FALSE;
   }
   return CPropertyPage::OnKillActive();
}

void CImageProp::OnKillfocusUsername() 
{
   UpdateData(TRUE);
   if( m_sUsername == s_sOldUsername && !m_sUsername.IsEmpty() ) 
      m_sPassword = s_sOldPassword;
   UpdateData(FALSE);
}

BOOL CImageProp::OnApply() 
{
   if( m_nStopIndex - m_nStartIndex <= 1 )
      if( IDNO == AfxMessageBox(IDS_NO_IMAGES, MB_YESNO | MB_ICONQUESTION) ) 
         return FALSE;
   return CPropertyPage::OnApply();
}

