// FileProp.cpp : implementation file
//

#include "stdafx.h"
#include "WebPageLoader.h"
#include "FileProp.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFileProp property page

IMPLEMENT_DYNCREATE(CFileProp, CPropertyPage)

CFileProp::CFileProp() : CPropertyPage(CFileProp::IDD)
{
   ASSERT(FALSE);
}

CFileProp::CFileProp(CSession *pSession) : CPropertyPage(CFileProp::IDD)
{
   ASSERT_VALID(pSession);
   m_pSession = pSession;

   //{{AFX_DATA_INIT(CFileProp)
   m_Duplicates = m_pSession->m_Settings.m_Duplicates;
   m_sExtensions = m_pSession->m_Settings.m_sFileExtensions;
   m_sHtmlFileNameFilter = m_pSession->m_Settings.m_sHtmlFileNameFilter;
   m_sImageTagFilter = m_pSession->m_Settings.m_sImageTagFilter;
   m_sImageFileNameFilter = m_pSession->m_Settings.m_sImageFileNameFilter;
   m_sExcludeFileNameFilter = m_pSession->m_Settings.m_sExcludeFileNameFilter;
   m_sPriorityFileNameFilter = m_pSession->m_Settings.m_sPriorityFileNameFilter;
   m_iFileSizeFilter = m_pSession->m_Settings.m_iFileSizeFilter;
   m_bUseHtmlFileNameFilter = m_pSession->m_Settings.m_bUseHtmlFileNameFilter;
   m_bUseImageTagFilter = m_pSession->m_Settings.m_bUseImageTagFilter;
   m_bUseImageFileNameFilter = m_pSession->m_Settings.m_bUseImageFileNameFilter;
   m_bUseExcludeFileNameFilter = m_pSession->m_Settings.m_bUseExcludeFileNameFilter;
   m_bUsePriorityFileNameFilter = m_pSession->m_Settings.m_bUsePriorityFileNameFilter;
   m_bUseFileSizeFilter = m_pSession->m_Settings.m_bUseFileSizeFilter;
   m_bSkipBanners = m_pSession->m_Settings.m_bSkipBanners;
   m_bSkipReoccouring = m_pSession->m_Settings.m_bPreventRepeating;
   //}}AFX_DATA_INIT

   if( m_pSession->m_Settings.m_bPrefixRename ) 
      m_iPrefix = 0; 
   else 
      m_iPrefix = 1;
}

CFileProp::~CFileProp()
{
}

void CFileProp::DoDataExchange(CDataExchange* pDX)
{
   CPropertyPage::DoDataExchange(pDX);
   //{{AFX_DATA_MAP(CFileProp)
   DDX_Control(pDX, IDC_PREFIX, m_ctlPrefix);
   DDX_Control(pDX, IDC_HTML_FILENAME_FILTER, m_ctlHtmlFileNameFilter);
   DDX_Control(pDX, IDC_IMAGE_FILENAME_FILTER, m_ctlImageFileNameFilter);
   DDX_Control(pDX, IDC_IMAGE_TAG_FILTER, m_ctlImageTagFilter);
   DDX_Control(pDX, IDC_FILESIZE_FILTER, m_ctlFilesizeFilter);
   DDX_Control(pDX, IDC_EXCLUDE_FILENAME_FILTER, m_ctlExcludeFilter);
   DDX_Control(pDX, IDC_PRIORITY_FILENAME_FILTER, m_ctlPriorityFilter);
   DDX_CBIndex(pDX, IDC_DUPLICATES, m_Duplicates);
   DDX_Text(pDX, IDC_EXTENSIONS, m_sExtensions);
   DDV_MaxChars(pDX, m_sExtensions, 256);
   DDX_Text(pDX, IDC_FILESIZE_FILTER, m_iFileSizeFilter);
   DDX_Text(pDX, IDC_HTML_FILENAME_FILTER, m_sHtmlFileNameFilter);
   DDX_Text(pDX, IDC_IMAGE_TAG_FILTER, m_sImageTagFilter);
   DDX_Text(pDX, IDC_IMAGE_FILENAME_FILTER, m_sImageFileNameFilter);
   DDX_Text(pDX, IDC_EXCLUDE_FILENAME_FILTER, m_sExcludeFileNameFilter);
   DDX_Text(pDX, IDC_PRIORITY_FILENAME_FILTER, m_sPriorityFileNameFilter);
   DDV_MinMaxInt(pDX, m_iFileSizeFilter, 1, 500);
   DDX_Check(pDX, IDC_USE_FILESIZE_FILTER, m_bUseFileSizeFilter);
   DDX_Check(pDX, IDC_USE_HTML_FILENAME_FILTER, m_bUseHtmlFileNameFilter);
   DDX_Check(pDX, IDC_USE_IMAGE_TAG_FILTER, m_bUseImageTagFilter);
   DDX_Check(pDX, IDC_USE_IMAGE_FILENAME_FILTER, m_bUseImageFileNameFilter);
   DDX_Check(pDX, IDC_USE_EXCLUDE_FILENAME_FILTER, m_bUseExcludeFileNameFilter);
   DDX_Check(pDX, IDC_USE_PRIORITY_FILENAME_FILTER, m_bUsePriorityFileNameFilter);
   DDX_CBIndex(pDX, IDC_PREFIX, m_iPrefix);
   DDX_Check(pDX, IDC_SKIPBANNERS, m_bSkipBanners);
   DDX_Check(pDX, IDC_SKIPREOCCOURING, m_bSkipReoccouring);
   //}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CFileProp, CPropertyPage)
   //{{AFX_MSG_MAP(CFileProp)
   ON_BN_CLICKED(IDC_USE_HTML_FILENAME_FILTER, OnHtmlFilterName)
   ON_BN_CLICKED(IDC_USE_IMAGE_TAG_FILTER, OnImageFilterTag)
   ON_BN_CLICKED(IDC_USE_IMAGE_FILENAME_FILTER, OnImageFilterName)
   ON_BN_CLICKED(IDC_USE_FILESIZE_FILTER, OnFilterSize)
   ON_BN_CLICKED(IDC_USE_EXCLUDE_FILENAME_FILTER, OnExcludeFilter)
   ON_BN_CLICKED(IDC_USE_PRIORITY_FILENAME_FILTER, OnPriorityFilter)
   ON_CBN_SELCHANGE(IDC_DUPLICATES, OnSelChangeDuplicates)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CFileProp message handlers

void CFileProp::OnOK() 
{
   ASSERT_VALID(m_pSession);
   
   CSessionDataLock lock(m_pSession);

   m_pSession->m_Settings.m_Duplicates = (Duplicate)m_Duplicates;
   m_pSession->m_Settings.m_sFileExtensions = m_sExtensions;
   m_pSession->m_Settings.m_sHtmlFileNameFilter = m_sHtmlFileNameFilter;
   m_pSession->m_Settings.m_sImageTagFilter = m_sImageTagFilter;
   m_pSession->m_Settings.m_sImageFileNameFilter = m_sImageFileNameFilter;
   m_pSession->m_Settings.m_sExcludeFileNameFilter = m_sExcludeFileNameFilter;
   m_pSession->m_Settings.m_sPriorityFileNameFilter = m_sPriorityFileNameFilter;
   m_pSession->m_Settings.m_iFileSizeFilter = m_iFileSizeFilter;
   m_pSession->m_Settings.m_bUseHtmlFileNameFilter = m_bUseHtmlFileNameFilter;
   m_pSession->m_Settings.m_bUseImageTagFilter = m_bUseImageTagFilter;
   m_pSession->m_Settings.m_bUseImageFileNameFilter = m_bUseImageFileNameFilter;
   m_pSession->m_Settings.m_bUseExcludeFileNameFilter = m_bUseExcludeFileNameFilter;
   m_pSession->m_Settings.m_bUsePriorityFileNameFilter = m_bUsePriorityFileNameFilter;
   m_pSession->m_Settings.m_bUseFileSizeFilter = m_bUseFileSizeFilter;
   m_pSession->m_Settings.m_bPrefixRename = (m_iPrefix==0);
   m_pSession->m_Settings.m_bSkipBanners = m_bSkipBanners;
   m_pSession->m_Settings.m_bPreventRepeating = m_bSkipReoccouring;

   CPropertyPage::OnOK();
}

BOOL CFileProp::OnKillActive() 
{
   if( UpdateData()==FALSE ) return FALSE;

   if( m_sExtensions.FindOneOf(_T("*?:\\.\"|"))>=0 ) {
      AfxMessageBox(IDS_ERR_EXTENSIONS);
      return FALSE;
   }
   
   return CPropertyPage::OnKillActive();
}

void CFileProp::OnHtmlFilterName() 
{
   UpdateData();   
   m_ctlHtmlFileNameFilter.EnableWindow(m_bUseHtmlFileNameFilter);
}

void CFileProp::OnImageFilterTag() 
{
   UpdateData();   
   m_ctlImageTagFilter.EnableWindow(m_bUseImageTagFilter);
}

void CFileProp::OnImageFilterName() 
{
   UpdateData();   
   m_ctlImageFileNameFilter.EnableWindow(m_bUseImageFileNameFilter);
}

void CFileProp::OnExcludeFilter() 
{
   UpdateData();   
   m_ctlExcludeFilter.EnableWindow(m_bUseExcludeFileNameFilter);
}

void CFileProp::OnPriorityFilter() 
{
   UpdateData();   
   m_ctlPriorityFilter.EnableWindow(m_bUsePriorityFileNameFilter);
}

void CFileProp::OnFilterSize() 
{
   UpdateData();   
   m_ctlFilesizeFilter.EnableWindow(m_bUseFileSizeFilter);
}

BOOL CFileProp::OnInitDialog() 
{
   CPropertyPage::OnInitDialog();

   if( m_bUseHtmlFileNameFilter ) OnHtmlFilterName();
   if( m_bUseImageTagFilter ) OnImageFilterTag();
   if( m_bUseImageFileNameFilter ) OnImageFilterName();
   if( m_bUseExcludeFileNameFilter ) OnExcludeFilter();
   if( m_bUsePriorityFileNameFilter ) OnPriorityFilter();
   if( m_bUseFileSizeFilter ) OnFilterSize();
   
   OnSelChangeDuplicates();

   return TRUE;  // return TRUE unless you set the focus to a control
                 // EXCEPTION: OCX Property Pages should return FALSE
}

void CFileProp::OnSelChangeDuplicates() 
{
   UpdateData();   
   m_ctlPrefix.ShowWindow(m_Duplicates==(int)DUP_RENAME ? SW_SHOW : SW_HIDE);
}

