// DownloadFile.h: interface for the CDownloadFile class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DOWNLOADFILE_H__3CACC793_BC85_11D3_82E7_0080AD509054__INCLUDED_)
#define AFX_DOWNLOADFILE_H__3CACC793_BC85_11D3_82E7_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CSession;

typedef enum tagDownloadState {
   FILESTATE_WAITING,
   FILESTATE_CONNECTING,
   FILESTATE_DOWNLOADING,
   FILESTATE_PARSING,
   FILESTATE_DONE,
   FILESTATE_ERROR,
   FILESTATE_SKIPPED,
   FILESTATE_ALREADYTHERE,
   FILESTATE_BROKEN
} DownloadState;


class CDownloadFile : public CObject, public CRefCount
{
public:
   CDownloadFile();
   virtual ~CDownloadFile();

// Operations
public:
   BOOL Create(CSession *pSession, 
               CString sURL, 
               CString sParentURL, 
               BOOL bIsImage, 
               short nLevel=1);
   BOOL Download(CSession *pSession, CInternetSession *pInet, int iPosition);

   bool IsBusy() const;

   void Abort(BOOL& bWasOnline);

protected:
   BOOL DoDownload(CSession *pSession,
      CInternetSession *inet, 
      CString sServer, CString sPage, INTERNET_PORT nPort,
      DWORD dwType,
      const CString& sFilename,
      CMemFile& fMem);
   BOOL DoParseFile(CSession *pSession, CMemFile& fMem);
   BOOL DoWriteFile(CSession* pSession, const CString& sPath, const CString& sFilename, CMemFile& fMem);

   BOOL GetTargetFilename(CSession *pSession, CString& sPath, CString& sFilename);
   BOOL ValidateFirstBuffer(CSession *pSession,
      const CString& sFilename,
      LPBYTE pBuffer, DWORD dwSize);
   BOOL ValidateURL(CSession *pSession, 
      const CString& sServer, const CString& sPage);
   BOOL ValidateDownloadedFile(CSession *pSession, 
      const CString& sFilename,
      DWORD dwFileSize,
      LPCTSTR strURL);
   BOOL FindToken(const CString& sTxt, int Pos, CString& sResult, CString& sTag, int& endpos);
   BOOL CrackCode(const CString &sTxt, CString& sResult);
   BOOL AddUrl(CSession *pSession, const CString& sValue, const CString& sTag);
   void PrettyPath(CString& sPart);
   CString ExtractURL(CString sValue, const CString& sURL);
   void SpecialTrick1(CSession* pSession, const CString& sHtml, const CString& sUrl);
   void SpecialTrick3(CSession* pSession, CString& sPath, CString& sFile);
   void ReportErrorState(CSession *pSession, DownloadState State, UINT nRes);

// Attributes
public:
   CString m_sURL;                  //< URL to download
   DownloadState m_State;           //< Current download state
   int m_iPriority;                 //< Download priority (0=normal)
   short m_iDownloadAttempts;       //< Number of download attempts
   LONGLONG m_llBytesDownloaded;    //< Bytes downloaded so far
   int m_iLastImage;                //< For internal logview update book-keeping
   BOOL m_bIsImage;                 //< This file is an image file (has image extension)
   BOOL m_bIsHtml;                  //< This file is an HTML file (has <html> tag)
   BOOL m_bSkipRequest;             //< Download marked as skipped
protected:
   CString m_sParentURL;
   CInternetFile* m_pFile;
   short m_nLevel;
   BOOL m_bSkipStoreFile;           //< Don't write file to disk after all
};


#endif // !defined(AFX_DOWNLOADFILE_H__3CACC793_BC85_11D3_82E7_0080AD509054__INCLUDED_)
