// WebPageLoaderDoc.h : interface of the CDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_WEBPAGELOADERDOC_H__7D36D30D_BACE_11D3_82E5_0080AD509054__INCLUDED_)
#define AFX_WEBPAGELOADERDOC_H__7D36D30D_BACE_11D3_82E5_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CDoc : public CDocument
{
protected: // create from serialization only
   CDoc();
   DECLARE_DYNCREATE(CDoc)

// Attributes
public:
   CPreferences m_Preferences;
   CSessionSettings m_SessionSettings;
   CThreadManager m_ThreadManager;

protected:
   CBlocker m_mtxDialogBlock;

// Operations
public:
   CSession *GetSelectedSession();
   void ThreadSchedule();
   //
   void OnNewHtmlScan(LPCTSTR pszURL = NULL, LPCTSTR pszUsername = NULL,LPCTSTR pszPassword = NULL);
   void OnNewImageScan(LPCTSTR pszURL = NULL, LPCTSTR pszUsername = NULL,LPCTSTR pszPassword = NULL);

// Overrides
   // ClassWizard generated virtual function overrides
   //{{AFX_VIRTUAL(CDoc)
   public:
   virtual BOOL OnNewDocument();
   virtual void Serialize(CArchive& ar);
   //}}AFX_VIRTUAL

// Implementation
public:
   virtual ~CDoc();
#ifdef _DEBUG
   virtual void AssertValid() const;
   virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
public:
   afx_msg void OnFileNewHtmlScan();
   afx_msg void OnFileNewImageScan();
public:
   //{{AFX_MSG(CDoc)
   afx_msg void OnPreferences();
   afx_msg void OnEditProperties();
   afx_msg void OnEditBrowse();
   afx_msg void OnUpdateEditProperties(CCmdUI* pCmdUI);
   afx_msg void OnUpdateEditBrowse(CCmdUI* pCmdUI);
   //}}AFX_MSG
   DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WEBPAGELOADERDOC_H__7D36D30D_BACE_11D3_82E5_0080AD509054__INCLUDED_)
