// WebPageLoaderDoc.cpp : implementation of the CDoc class
//

#include "stdafx.h"
#include "WebPageLoader.h"

#include "Doc.h"
#include "MainFrm.h"
#include "SessionView.h"

#include "MainProp.h"
#include "PrefProp.h"
#include "ProxyProp.h"
#include "FileProp.h"
#include "ImageProp.h"
#include "TargetProp.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CDoc

IMPLEMENT_DYNCREATE(CDoc, CDocument)

BEGIN_MESSAGE_MAP(CDoc, CDocument)
   //{{AFX_MSG_MAP(CDoc)
   ON_COMMAND(ID_PREFERENCES, OnPreferences)
   ON_COMMAND(ID_FILE_NEW_HTMLSCAN, OnFileNewHtmlScan)
   ON_COMMAND(ID_FILE_NEW_IMAGESCAN, OnFileNewImageScan)
   ON_COMMAND(ID_EDIT_PROPERTIES, OnEditProperties)
   ON_COMMAND(ID_EDIT_BROWSE, OnEditBrowse)
   ON_UPDATE_COMMAND_UI(ID_EDIT_PROPERTIES, OnUpdateEditProperties)
   ON_UPDATE_COMMAND_UI(ID_EDIT_BROWSE, OnUpdateEditBrowse)
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDoc construction/destruction

CDoc::CDoc()
{
   EnableAutomation();

   AfxOleLockApp();

   m_Preferences.Load();
   
   m_SessionSettings.Load();
}

CDoc::~CDoc()
{
   m_Preferences.Save();  

   m_SessionSettings.Save();

   AfxOleUnlockApp();
}


/////////////////////////////////////////////////////////////////////////////
// CDoc serialization

void CDoc::Serialize(CArchive& ar)
{
   if (ar.IsStoring())
   {
      // TODO: add storing code here
   }
   else
   {
      // TODO: add loading code here
   }
}


/////////////////////////////////////////////////////////////////////////////
// CDoc diagnostics

#ifdef _DEBUG
void CDoc::AssertValid() const
{
   CDocument::AssertValid();
}

void CDoc::Dump(CDumpContext& dc) const
{
   CDocument::Dump(dc);
}
#endif //_DEBUG


/////////////////////////////////////////////////////////////////////////////
// CDoc commands

void CDoc::ThreadSchedule()
{
   m_ThreadManager.m_nMaxThreads = m_Preferences.m_nThreads;

   if( m_ThreadManager.ScheduleRun() == TRUE ) {
      ::AfxGetMainWnd()->PostMessage(WM_REFRESHITEMS);
      ::AfxGetMainWnd()->PostMessage(WM_CREATENODES);
   }

   if( m_Preferences.m_bQuitWhenDone ) {
      if( m_ThreadManager.m_nTotalThreads>0 && m_ThreadManager.m_nActiveThreads==0 ) {
         ::AfxGetMainWnd()->PostMessage(WM_CLOSE);
      }
   }
};

CSession *CDoc::GetSelectedSession()
{
   ASSERT_VALID(::AfxGetMainWnd());
   ASSERT_VALID(((CMainFrame *)::AfxGetMainWnd())->GetTopPane());

   LONG ID = ((CMainFrame *)::AfxGetMainWnd())->GetTopPane()->GetSelectedSessionID();
   if( ID<0 ) return NULL;

   CSingleLock lock( m_ThreadManager, TRUE );
   
   return m_ThreadManager.FindSession(ID);
};


/////////////////////////////////////////////////////////////////////////////
// CDoc commands

BOOL CDoc::OnNewDocument()
{
   if (!CDocument::OnNewDocument())
      return FALSE;

   return TRUE;
}

void CDoc::OnPreferences() 
{
   CSession *pSession = new CSession();
   if( pSession == NULL ) return;
   ASSERT_VALID(pSession);

   pSession->Create(TYPE_UNKNOWN, m_SessionSettings, &m_Preferences);

   CFileProp dlgFilters( pSession );
   CPrefProp dlgPref( pSession );
   CProxyProp dlgProxy( pSession );
   CTargetProp dlgTarget( pSession );

   CPropertySheet sheet;
   CString sTitle;
   sTitle.LoadString(IDS_PROP_GLOBAL);
   sheet.SetTitle(sTitle, PSH_PROPTITLE);
   sheet.m_psh.dwFlags |= PSH_NOAPPLYNOW;
   sheet.AddPage( &dlgPref );
   sheet.AddPage( &dlgTarget );
   sheet.AddPage( &dlgFilters );
   sheet.AddPage( &dlgProxy );
   sheet.DoModal();

   m_SessionSettings = pSession->m_Settings;

   pSession->Release();
}

void CDoc::OnFileNewHtmlScan()
{
   OnNewHtmlScan(NULL);
};

void CDoc::OnNewHtmlScan(LPCTSTR pszURL /*= NULL */,LPCTSTR pszUsername /*= NULL */, LPCTSTR pszPassword /*= NULL*/)
{
   CSingleBlock lock(&m_mtxDialogBlock, TRUE);
   if( !lock.IsLocked() ) return;

   CSession *pSession = new CSession();
   if( pSession == NULL ) return;

   ASSERT_VALID(pSession);
   pSession->Create(TYPE_HTMLSCAN, m_SessionSettings, &m_Preferences);

   // Set some defaults
   if( pszURL != NULL ) {
      pSession->m_sURL = pszURL;
      pSession->m_sUsername = pszUsername;
      pSession->m_sPassword = pszPassword;
   }
   else
      pSession->m_sURL = _T("http://");

   CHtmlProp dlgMain( pSession );
   CTargetProp dlgTarget( pSession );
   CFileProp dlgFilters( pSession );

   CPropertySheet sheet;
   CString sTitle;
   sTitle.LoadString(IDS_PROP_HTMLSCAN);
   sheet.SetTitle(sTitle, PSH_PROPTITLE);
   sheet.m_psh.dwFlags |= PSH_NOAPPLYNOW;
   sheet.AddPage( &dlgMain );
   sheet.AddPage( &dlgTarget );
   sheet.AddPage( &dlgFilters );
   int ret = sheet.DoModal();

   if( ret != IDOK ) {
      pSession->Release();
      return;
   }

   pSession->ScheduleNewDownload();

   m_ThreadManager.AddSession(pSession);
   
   ::AfxGetMainWnd()->PostMessage(WM_SCHEDULE);
   ::AfxGetMainWnd()->PostMessage(WM_REFRESHITEMS);
}

void CDoc::OnFileNewImageScan() 
{
   OnNewImageScan(NULL);
};

void CDoc::OnNewImageScan(LPCTSTR pszURL /*= NULL*/,LPCTSTR pszUsername /*= NULL*/, LPCTSTR pszPassword /*= NULL*/) 
{
   CSingleBlock lock(&m_mtxDialogBlock, TRUE);
   if( !lock.IsLocked() ) return;

   CSession *pSession = new CSession;
   if( pSession == NULL ) return;

   ASSERT_VALID(pSession);
   pSession->Create(TYPE_IMAGESCAN, m_SessionSettings, &m_Preferences);
   // Set some defaults
   if( pszURL != NULL ) {
      pSession->m_sSourceImage = pszURL;
      pSession->m_sUsername = pszUsername;
      pSession->m_sPassword = pszPassword;
   }
   else
      pSession->m_sSourceImage = _T("http://");

   CTargetProp dlgTarget( pSession );
   CImageProp dlgImage( pSession );

   CPropertySheet sheet;
   CString sTitle;
   sTitle.LoadString(IDS_PROP_IMAGESCAN);
   sheet.SetTitle(sTitle, PSH_PROPTITLE);
   sheet.m_psh.dwFlags |= PSH_NOAPPLYNOW;
   sheet.AddPage( &dlgImage );
   sheet.AddPage( &dlgTarget );
   int ret = sheet.DoModal();

   if( ret != IDOK ) {
      pSession->Release();
      return;
   };

   pSession->ScheduleNewDownload();
   
   m_ThreadManager.AddSession(pSession);

   ::AfxGetMainWnd()->PostMessage(WM_SCHEDULE);
   ::AfxGetMainWnd()->PostMessage(WM_REFRESHITEMS);
}

void CDoc::OnEditProperties() 
{
   CSingleBlock lock(&m_mtxDialogBlock, TRUE);
   if( !lock.IsLocked() ) return;

   CSession *pSession = GetSelectedSession();
   ASSERT_VALID(pSession);
   if( pSession == NULL ) return;

   CHtmlProp dlgMain( pSession );
   CImageProp dlgImage( pSession );
   CFileProp dlgFilters( pSession );
   CTargetProp dlgTarget( pSession );

   CPropertySheet sheet;
   CString sTitle;
   sTitle.LoadString(IDS_PROP_SESSION);
   sheet.SetTitle(sTitle, PSH_PROPTITLE);
   sheet.m_psh.dwFlags |= PSH_NOAPPLYNOW;
   if( pSession->m_Type==TYPE_HTMLSCAN ) {
      sheet.AddPage( &dlgMain );
      sheet.AddPage( &dlgTarget );
      sheet.AddPage( &dlgFilters );
   } 
   else {
      sheet.AddPage( &dlgImage );
      sheet.AddPage( &dlgTarget );
   };
   sheet.DoModal();

   ::AfxGetMainWnd()->PostMessage(WM_SCHEDULE);
   ::AfxGetMainWnd()->PostMessage(WM_REFRESHITEMS);
}

void CDoc::OnUpdateEditProperties(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable(GetSelectedSession()!=NULL);
}

void CDoc::OnEditBrowse() 
{
   CSession *pSession = GetSelectedSession();
   ASSERT_VALID(pSession);
   if( pSession == NULL ) return;

   CSessionDataLock lock(pSession);

   ::ShellExecute(::AfxGetMainWnd()->GetSafeHwnd(),
      _T("open"),
      pSession->m_Settings.m_sDownloadPath,
      NULL,
      pSession->m_Settings.m_sDownloadPath,
      SW_SHOW);
}

void CDoc::OnUpdateEditBrowse(CCmdUI* pCmdUI) 
{
   pCmdUI->Enable(GetSelectedSession()!=NULL);
}
