// ClipboardListener.cpp : implementation file
//

#include "stdafx.h"
#include "WebPageLoader.h"
#include "MainFrm.h"
#include "Doc.h"
#include "ClipboardListener.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CClipboardListener

CClipboardListener::CClipboardListener()
{
}

CClipboardListener::~CClipboardListener()
{
}


BEGIN_MESSAGE_MAP(CClipboardListener, CWnd)
   //{{AFX_MSG_MAP(CClipboardListener)
   ON_WM_DRAWCLIPBOARD()
   ON_WM_CREATE()
   ON_WM_CHANGECBCHAIN()
   ON_WM_DESTROY()
   //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CClipboardListener message handlers

int CClipboardListener::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
   if (CWnd::OnCreate(lpCreateStruct) == -1)
      return -1;
   
   m_wndNext.Attach( SetClipboardViewer() );
   
   return 0;
}

void CClipboardListener::OnDestroy() 
{
   ChangeClipboardChain(m_wndNext);    
   m_wndNext.Detach();

   CWnd::OnDestroy();
}

void CClipboardListener::OnDrawClipboard() 
{
//   CWnd::OnDrawClipboard();
   
   // Ok, pass on the clipboard message to other viewers
   if( m_wndNext.m_hWnd!=NULL ) 
      m_wndNext.SendMessage(WM_DRAWCLIPBOARD, 0, 0);

   CMainFrame *mainfrm = (CMainFrame *)AfxGetMainWnd();
   if( mainfrm == NULL ) return;
   
   CDoc *pDoc = (CDoc *)mainfrm->GetActiveDocument();
   if( pDoc == NULL ) return;
   ASSERT_KINDOF(CDoc,pDoc);

   // Are we interested in clipboard stuff, anyway?
   if( !pDoc->m_Preferences.m_bClipboardListener ) 
      return;

#if(WINVER >= 0x0500)
   static DWORD s_dwSequence = 0x666;
   DWORD dwSequence = ::GetClipboardSequenceNumber();
   if( dwSequence == s_dwSequence ) 
      return;
   s_dwSequence = dwSequence;
#endif

   CString sURL;

   // Ok, get text from clipboard
   HGLOBAL hglb; 
   LPTSTR lptstr;    
   if( !::IsClipboardFormatAvailable(CF_TEXT) ) 
      return; 
   if( !::OpenClipboard(this->m_hWnd) ) 
      return; 
   hglb = ::GetClipboardData(CF_TEXT); 
   if( hglb != NULL ) { 
      lptstr = (LPTSTR)  GlobalLock(hglb); 
      if( lptstr != NULL ) { 
         sURL = lptstr;
         GlobalUnlock(hglb); 
      } 
   } 
   ::CloseClipboard();  
   
   // Clean up the clipboard string from all the crap
   // a user with 10 thumbs may have caused :-)
   sURL.Replace(_T("&amp;"), _T("&"));
   sURL.Remove(_T('\r'));
   sURL.Remove(_T('\n'));
   sURL.Remove(_T('\t'));
   sURL.TrimLeft();
   sURL.TrimRight();

   // Is there anything at all?
   if( sURL.IsEmpty() ) 
      return;

   // Just a quick hack to at least catch some badly copied
   // clipboard entries...
   if( sURL.Left(3) == _T("www") ) 
      sURL = _T("http://") + sURL;

   // Look for a username/password embedded in URL
   // A HTTP username/password is formatted like
   // this: http://username.password@www.name.com.
   // NOTE: We know our URL should starts with "http://".
   CString sUsername;
   CString sPassword;
   if( sURL.Left(7) == _T("http://") || sURL.Left(8) == _T("https://") ) {
      int pos = sURL.Find(_T('@'));
      if( pos > 0 ) {
         int slash = sURL.Find(_T("//")) + 2;
         int delim = sURL.Mid(slash).FindOneOf(_T(".:")) + slash;
         if( delim < slash ) return;
         sUsername = sURL.Mid(slash, delim - slash);
         sPassword = sURL.Mid(delim + 1,pos - delim - 1);
         sURL = sURL.Left(slash) + sURL.Mid(pos + 1);
      }
   }

   CString sUrlPart = sURL;
   int pos;
   pos = sUrlPart.Find(_T('?'));
   if( pos > 0 ) sUrlPart = sUrlPart.Left(pos);
   pos = sUrlPart.Find(_T('#'));
   if( pos > 0 ) sUrlPart = sUrlPart.Left(pos);
   sUrlPart.MakeLower();

   // Check if it's an HTML page...
   if( BfxHasValidExtension(sUrlPart, HTML_EXTENSIONS, FALSE) ) {
      ForceForegroundWindow(AfxGetMainWnd()->m_hWnd);
      pDoc->OnNewHtmlScan( sURL, sUsername, sPassword );
      return;
   }

   // Is it an image?
   if( BfxHasValidExtension(sUrlPart, pDoc->m_SessionSettings.m_sFileExtensions, FALSE) ) {
      ForceForegroundWindow(AfxGetMainWnd()->m_hWnd);
      pDoc->OnNewImageScan( sURL, sUsername, sPassword );
      return;
   }

   // If it still looks like an HTML URL, assume it is an HTML page without page part...
   if( sUrlPart.Left(7) == _T("http://") || sUrlPart.Left(8) == _T("https://") ) {
      ForceForegroundWindow(AfxGetMainWnd()->m_hWnd);
      pDoc->OnNewHtmlScan( sURL, sUsername, sPassword );
      return;
   }
}

void CClipboardListener::OnChangeCbChain(HWND hWndRemove, HWND hWndAfter) 
{  
   if( hWndAfter != NULL && hWndRemove == m_wndNext ) {
      m_wndNext.Detach();
      if( hWndAfter != NULL ) 
         m_wndNext.Attach(hWndAfter);
   }
   else {
      if( m_wndNext.m_hWnd != NULL ) 
         m_wndNext.SendMessage(WM_CHANGECBCHAIN, (WPARAM) hWndRemove, (LPARAM) hWndAfter );
   }
   CWnd::OnChangeCbChain(hWndRemove, hWndAfter);
}

bool CClipboardListener::ForceForegroundWindow(HWND hwnd)
{
    // Code from Thomas Stutz @ delphi3000.com
    // Converted to Borland C++ Builder Code by Wolfgang Frisch

    bool Result;

#ifndef SPI_GETFOREGROUNDLOCKTIMEOUT
   #define SPI_GETFOREGROUNDLOCKTIMEOUT        0x2000
   #define SPI_SETFOREGROUNDLOCKTIMEOUT        0x2001
#endif

   OSVERSIONINFO osvi = { 0 };
   osvi.dwOSVersionInfoSize = sizeof (OSVERSIONINFO);
   if( !::GetVersionEx( (OSVERSIONINFO *) &osvi) ) return false;
   DWORD Win32Platform = osvi.dwPlatformId;
   DWORD Win32MajorVersion = osvi.dwMajorVersion;
   DWORD Win32MinorVersion = osvi.dwMinorVersion;

   DWORD nullvalue = 0;

   DWORD ForegroundThreadID;
   DWORD ThisThreadID;
   DWORD timeout;

   if( ::IsIconic(hwnd) ) 
      ::ShowWindow(hwnd, SW_RESTORE);

   if( ::GetForegroundWindow() == hwnd) 
   {
      return true;
   }
   else
   {
     // Windows 98/2000 doesn't want to foreground a window when some other
     // window has keyboard focus
     if( ((Win32Platform == VER_PLATFORM_WIN32_NT) && (Win32MajorVersion > 4))
          || ((Win32Platform == VER_PLATFORM_WIN32_WINDOWS)
               && ((Win32MajorVersion > 4) || ((Win32MajorVersion == 4) 
               && (Win32MinorVersion > 0)))) )
     {
         // Code from Karl E. Peterson, www.mvps.org/vb/sample.htm
         // Converted to Delphi by Ray Lischner
         // Published in The Delphi Magazine 55, page 16

         Result = false;
         ForegroundThreadID = ::GetWindowThreadProcessId(::GetForegroundWindow(),NULL);
         ThisThreadID = ::GetWindowThreadProcessId(hwnd,NULL);
         if( ::AttachThreadInput(ThisThreadID, ForegroundThreadID, true) )
         {
            ::BringWindowToTop(hwnd); // IE 5.5 related hack
           ::SetForegroundWindow(hwnd);
           ::AttachThreadInput(ThisThreadID, ForegroundThreadID, false);
           Result = (::GetForegroundWindow() == hwnd);
         }
         if( !Result )
         {
           // Code by Daniel P. Stasinski
           ::SystemParametersInfo(SPI_GETFOREGROUNDLOCKTIMEOUT, 0, &timeout, 0);
           ::SystemParametersInfo(SPI_SETFOREGROUNDLOCKTIMEOUT, 0, &nullvalue, SPIF_SENDCHANGE);
           ::BringWindowToTop(hwnd); // IE 5.5 related hack
           ::SetForegroundWindow(hwnd);
           ::SystemParametersInfo(SPI_SETFOREGROUNDLOCKTIMEOUT, 0, &timeout, SPIF_SENDCHANGE);
         }
     }
     else
     {
        ::BringWindowToTop(hwnd); // IE 5.5 related hack
        ::SetForegroundWindow(hwnd);
     }
     Result = (::GetForegroundWindow() == hwnd);
   } return Result;
}


extern CApp theApp;

