#if !defined(AFX_BLOCKER_H__20000521_845D_D551_7A12_0080AD509054__INCLUDED_)
#define AFX_BLOCKER_H__20000521_845D_D551_7A12_0080AD509054__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

///////////////////////////////////////////////////////////////////////
// My blocking system.
//  State system that checks if another thread has a lock
//  on the state.
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000 Bjarke viksoe.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed unmodified by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//


class CBlocker
{
public:
   CBlocker(BOOL bInitiallyLock = FALSE)
   {
      m_dwCnt = (bInitiallyLock ? 0 : -1);
   }

   BOOL Lock()
   {
      BOOL bLocked = (::InterlockedIncrement(&m_dwCnt) >= 0);

      if( !bLocked )
         ::InterlockedDecrement(&m_dwCnt);
      
      return bLocked;
   }

   void Unlock()
   {
      ::InterlockedDecrement(&m_dwCnt);
   }
   
   BOOL IsLocked() const
   {
      return m_dwCnt >= 0;
   }

protected:
   LONG m_dwCnt;
};

class CSingleBlock
{
public:
   CSingleBlock(CBlocker *pBlocker, BOOL bInitiallyLock = FALSE) : m_pBlocker(pBlocker), m_bLocked(FALSE)
   {     
      if( bInitiallyLock ) 
         Lock();
   }

   ~CSingleBlock()
   {
      if( m_bLocked ) 
         m_pBlocker->Unlock();
   }
   
   void Lock()
   {
      if( m_bLocked ) 
         return;
      m_bLocked = m_pBlocker->Lock();
   }
   
   void Unlock()
   {
      m_pBlocker->Unlock();
      m_bLocked = FALSE;
   }
   
   BOOL IsLocked() const 
   { 
      return m_bLocked; 
   }

protected:
   CBlocker *m_pBlocker;
   BOOL m_bLocked;
};


#endif // !defined(AFX_BLOCKER_H__20000521_845D_D551_7A12_0080AD509054__INCLUDED_)

