// maindlg.h : interface of the CMainDlg class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINDLG_H__EDEBD7F1_D85D_4061_A698_7C04CD0B7A71__INCLUDED_)
#define AFX_MAINDLG_H__EDEBD7F1_D85D_4061_A698_7C04CD0B7A71__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "HTMLListBox.h"

class CMainDlg : 
   public CAxDialogImpl<CMainDlg>,
   public CMessageFilter, 
   public CIdleHandler
{
public:
   enum { IDD = IDD_MAINDLG };

   CHTMLListCtrl m_list1;
   CHTMLListCtrl m_list2;

   virtual BOOL PreTranslateMessage(MSG* pMsg)
   {
      return IsDialogMessage(pMsg);
   }

   virtual BOOL OnIdle()
   {
      return FALSE;
   }

   BEGIN_MSG_MAP(CMainDlg)
      MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
      COMMAND_ID_HANDLER(IDOK, OnOK)
      COMMAND_ID_HANDLER(IDCANCEL, OnOK)
      NOTIFY_HANDLER(IDC_LIST1, HLN_INITIALIZE, OnList1_Initialize)
      NOTIFY_HANDLER(IDC_LIST1, HLN_INSERTITEM, OnList1_InsertItem)
      NOTIFY_HANDLER(IDC_LIST1, HLN_MOUSEOVER,  OnList1_MouseOver)
      NOTIFY_HANDLER(IDC_LIST1, HLN_MOUSEOUT,   OnList1_MouseOut)
      NOTIFY_HANDLER(IDC_LIST1, HLN_SELCHANGED, OnList1_SelChanged)
      NOTIFY_HANDLER(IDC_LIST2, HLN_INITIALIZE, OnList2_Initialize)
      NOTIFY_HANDLER(IDC_LIST2, HLN_INSERTITEM, OnList2_InsertItem)
      NOTIFY_HANDLER(IDC_LIST2, HLN_SELCHANGED, OnList2_SelChanged)
   END_MSG_MAP()

   LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      // Center the dialog on the screen
      CenterWindow();

      // Set icons
      HICON hIcon = (HICON)::LoadImage(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
         IMAGE_ICON, ::GetSystemMetrics(SM_CXICON), ::GetSystemMetrics(SM_CYICON), LR_DEFAULTCOLOR);
      SetIcon(hIcon, TRUE);
      HICON hIconSmall = (HICON)::LoadImage(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
         IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), LR_DEFAULTCOLOR);
      SetIcon(hIconSmall, FALSE);

      // Register object for message filtering and idle updates
      CMessageLoop* pLoop = _Module.GetMessageLoop();
      ATLASSERT(pLoop != NULL);
      pLoop->AddMessageFilter(this);
      pLoop->AddIdleHandler(this);

      CComboBox cbo = GetDlgItem(IDC_COMBO1);
      cbo.AddString(_T("Name"));
      cbo.AddString(_T("Size"));
      cbo.SelectString(-1,_T("Name"));

      m_list1.SubclassWindow(GetDlgItem(IDC_LIST1), IDR_HTML1);
      m_list2.SubclassWindow(GetDlgItem(IDC_LIST2), IDR_HTML2);

      return TRUE;
   }

   LRESULT OnList1_Initialize(int /*idCtrl*/, LPNMHDR /*pnmh*/, BOOL& /*bHandled*/)
   {
      m_list1.AddString(_T("<CENTER><IMG SRC=res://WayCoolList.exe/#207><BR><SPAN>Change or Remove Programs</SPAN></CENTER>"));
      m_list1.AddString(_T("<CENTER><IMG SRC=res://WayCoolList.exe/#206><BR><SPAN>Add New Programs</SPAN></CENTER>"));
      m_list1.AddString(_T("<CENTER><IMG SRC=res://WayCoolList.exe/#208><BR><SPAN>Add/Remove Windows Components</SPAN></CENTER>"));
      m_list1.SetCurSel(0);
      return 0;
   }

   LRESULT OnList1_InsertItem(int /*idCtrl*/, LPNMHDR pnmh, BOOL& /*bHandled*/)
   {
      LPNMHTMLLIST lpht = (LPNMHTMLLIST)pnmh;
      lpht->pNew->put_className(CComBSTR(L"ITEMUP"));
      return 0;
   }

   LRESULT OnList1_MouseOver(int /*idCtrl*/, LPNMHDR pnmh, BOOL& /*bHandled*/)
   {
      LPNMHTMLLIST lpht = (LPNMHTMLLIST)pnmh;
      if( lpht->iNewIndex!=m_list1.GetCurSel() ) lpht->pNew->put_className(CComBSTR(L"ITEMOVER"));
      return 0;
   }

   LRESULT OnList1_MouseOut(int /*idCtrl*/, LPNMHDR pnmh, BOOL& /*bHandled*/)
   {
      LPNMHTMLLIST lpht = (LPNMHTMLLIST)pnmh;
      if( lpht->iNewIndex!=m_list1.GetCurSel() ) lpht->pNew->put_className(CComBSTR(L"ITEMUP"));
      return 0;
   }

   LRESULT OnList1_SelChanged(int /*idCtrl*/, LPNMHDR pnmh, BOOL& /*bHandled*/)
   {
      LPNMHTMLLIST lpht = (LPNMHTMLLIST)pnmh;
      if( lpht->pNew ) lpht->pNew->put_className(CComBSTR(L"ITEMDOWN"));
      if( lpht->pOld ) lpht->pOld->put_className(CComBSTR(L"ITEMUP"));
      return 0;
   }

   LRESULT OnList2_Initialize(int /*idCtrl*/, LPNMHDR /*pnmh*/, BOOL& /*bHandled*/)
   {
      // Scan the System Registry for Uninstall strings...
      CRegKey reg;
      reg.Open(HKEY_LOCAL_MACHINE, _T("Software\\Microsoft\\Windows\\CurrentVersion\\Uninstall"), KEY_READ);
      DWORD dwCount;
      ::RegQueryInfoKey(reg, NULL, NULL, NULL, &dwCount, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
      const DWORD MAX_NAME_LEN = 128;
      for( DWORD i=0; i<dwCount; i++ ) {
         TCHAR szItem[MAX_NAME_LEN+1] = { 0 };
         DWORD cchItem = MAX_NAME_LEN;
         if( ::RegEnumKey(reg, i, szItem, cchItem)!=ERROR_SUCCESS ) break;
         CRegKey regItem;
         if( regItem.Open(reg, szItem)!=ERROR_SUCCESS ) break;
         szItem[0] = _T('\0');
         cchItem = MAX_NAME_LEN;
#if _ATL_VER >= 0x0700
         regItem.QueryStringValue(_T("DisplayName"), szItem, &cchItem);
#else
         regItem.QueryValue(szItem, _T("DisplayName"), &cchItem);
#endif
         TCHAR szUninstallString[MAX_PATH] = { 0 };
         cchItem = MAX_PATH;
#if _ATL_VER >= 0x0700
         regItem.QueryStringValue(_T("UninstallString"), szUninstallString, &cchItem);
#else
         regItem.QueryValue(szUninstallString, _T("UninstallString"), &cchItem);
#endif
         regItem.Close();

         if( ::lstrlen(szItem) == 0 ) continue;
         if( ::lstrlen(szUninstallString) == 0 ) continue;

         LPTSTR p = szUninstallString;
         LPTSTR pChr;
         if( *p==_T('\"') ) {
            p++;
            pChr = _tcschr(p, _T('\"'));
         }
         else {
            pChr = _tcspbrk(p, _T(" \t,"));
         }
         if( pChr ) *pChr = _T('\0');
         TCHAR szImage[MAX_PATH+10];       
         ::wsprintf(szImage, _T("sysimage://%s/small"), p);
         TCHAR szHTML[500];
         ::wsprintf(szHTML, 
            _T("<IMG SRC=\"%s\" WIDTH=16 HEIGHT=16>")
            _T("<SPAN>&nbsp;%s</SPAN>")
            _T("<DIV CLASS=\"INFODIV\" STYLE=\"display:none\"><BR>")
            _T("<TABLE><TR>")
            _T("<TD WIDTH=\"100%%\">To change this program or remove it from<BR>your computer, click Change/Remove.</TD>")
            _T("<TD><INPUT TYPE=button VALUE=\"Change/Remove\" onclick=\"OnButtonClick()\"></TD>")
            _T("</TR></TABLE>")
            _T("</DIV>"),
            szImage, szItem);
         m_list2.AddString(szHTML);
      }
      return 0;
   }

   LRESULT OnList2_InsertItem(int /*idCtrl*/, LPNMHDR pnmh, BOOL& /*bHandled*/)
   {
      LPNMHTMLLIST lpht = (LPNMHTMLLIST)pnmh;
      lpht->pNew->put_className(CComBSTR(L"ITEMNORMAL"));
      return 0;
   }

   LRESULT OnList2_SelChanged(int /*idCtrl*/, LPNMHDR pnmh, BOOL& /*bHandled*/)
   {
      LPNMHTMLLIST lpht = (LPNMHTMLLIST)pnmh;
      if( lpht->pNew ) lpht->pNew->put_className(CComBSTR(L"ITEMSEL"));
      if( lpht->pOld ) lpht->pOld->put_className(CComBSTR(L"ITEMNORMAL"));
      
      // Call back into HTML to expand/collapse item
      CComPtr<IHTMLDocument2> spDoc;
      m_list2._GetDhtmlDocument(spDoc);
      CComDispatchDriver dd(spDoc);     
      if( lpht->pOld ) {
         CComQIPtr<IDispatch> spDisp(lpht->pOld);
         CComVariant v(spDisp);
         dd.Invoke1(L"OnItemCollapsing", &v);
      }
      if( lpht->pNew ) {
         CComQIPtr<IDispatch> spDisp(lpht->pNew);
         CComVariant v(spDisp);
         dd.Invoke1(L"OnItemExpanding", &v);
      }
      return 0;
   }
    
   LRESULT OnOK(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      CloseDialog(wID);
      return 0;
   }

   void CloseDialog(int nVal)
   {
      DestroyWindow();
      ::PostQuitMessage(nVal);
   }
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINDLG_H__EDEBD7F1_D85D_4061_A698_7C04CD0B7A71__INCLUDED_)
