#if !defined(AFX_HTMLLISTBOX_H__20010607_D1F3_C48F_2458_0080AD509054__INCLUDED_)
#define AFX_HTMLLISTBOX_H__20010607_D1F3_C48F_2458_0080AD509054__INCLUDED_

#pragma once

/////////////////////////////////////////////////////////////////////////////
// HTMLListBox - A HTML List control
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2001 Bjarke Viksoe.
//
// This code may be used in compiled form in any way you desire. This
// source file may be redistributed by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//

#ifndef __cplusplus
  #error ATL requires C++ compilation (use a .cpp suffix)
#endif

#ifndef __ATLAPP_H__
  #error HTMLListBox.h requires atlapp.h to be included first
#endif

#ifndef __ATLCOM_H__
  #error HTMLListBox.h requires atlcom.h to be included first
#endif

#if (_WIN32_IE < 0x0400)
  #error HTMLListBox.h requires _WIN32_IE >= 0x0400
#endif

// My ATL Dynamic Dispatch class
#include "atldispa.h"


/////////////////////////////////////////////////////////////////////////////
// CWebDlgCtrl

template< class T >
class CWebDlgCtrl :
   public CAxWindow
{
public:
   CComPtr<IWebBrowser2> m_spWeb;

   // Initialization

   BOOL Attach(HWND hWnd, UINT nRes)
   {
      ATLASSERT(m_hWnd==NULL);
      ATLASSERT(::IsWindow(hWnd));
      CAxWindow::Attach(hWnd);
      return _Init(nRes);
   }

   // Implementation

   BOOL _Init(UINT nRes)
   {
      HRESULT Hr;
      CComPtr<IUnknown> spUnk;
      Hr = QueryControl(IID_IUnknown, (LPVOID*) &spUnk);
      ATLASSERT(SUCCEEDED(Hr));
      if( FAILED(Hr) ) return FALSE;

      CComQIPtr<IServiceProvider> spSP(spUnk);
      ATLASSERT(spSP);
      if( spSP==NULL ) return FALSE;

      // Get to the IE Web Browser
      Hr = spSP->QueryService(IID_IWebBrowserApp, &m_spWeb);
      ATLASSERT(SUCCEEDED(Hr));
      if( FAILED(Hr) ) return FALSE;
     
      // Turn off text selection and right-click menu
      CComPtr<IAxWinAmbientDispatch> spHost;
      Hr = QueryHost(IID_IAxWinAmbientDispatch, (LPVOID*) &spHost);
      if( SUCCEEDED(Hr) ) {
         spHost->put_AllowContextMenu(VARIANT_FALSE);
         spHost->put_DocHostFlags(DOCHOSTUIFLAG_DIALOG | DOCHOSTUIFLAG_NO3DBORDER | DOCHOSTUIFLAG_DISABLE_HELP_MENU);
      }
      // Turn off some more of the ugly IE stuff
      m_spWeb->put_RegisterAsBrowser(VARIANT_FALSE);
      m_spWeb->put_RegisterAsDropTarget(VARIANT_FALSE);
      m_spWeb->put_AddressBar(VARIANT_FALSE);
#pragma warning(disable: 4310) // cast truncates constant value
      m_spWeb->put_Offline(VARIANT_TRUE);
#pragma warning(default: 4310) // cast truncates constant value

      T* pT = static_cast<T*>(this);
      pT->_ExternalInit();

      CComVariant vEmpty;
      TCHAR szFileName[MAX_PATH];
      ::GetModuleFileName(_Module.GetModuleInstance(), szFileName, MAX_PATH);
      TCHAR szRes[MAX_PATH+10];
      ::wsprintf(szRes, _T("res://%s/%0d"), szFileName, nRes);
      CComVariant vURL(szRes);
      Hr = m_spWeb->Navigate2(&vURL, &vEmpty, &vEmpty, &vEmpty, &vEmpty);
      ATLASSERT(SUCCEEDED(Hr));
      if( FAILED(Hr) ) return FALSE;
      return TRUE;
   }

   BOOL _GetDhtmlDocument(CComPtr<IHTMLDocument2> &spDoc) const
   {
      ATLASSERT(m_spWeb);
      CComPtr<IDispatch> spDisp;
      HRESULT Hr = m_spWeb->get_Document(&spDisp);
      if( FAILED(Hr) ) return FALSE;
      CComQIPtr<IHTMLDocument2> spHTML(spDisp);
      if( spHTML==NULL ) return FALSE;
      spDoc = spHTML;
      return TRUE;
   }

   BOOL _GetDhtmlElement(LPCOLESTR pstrName, CComPtr<IHTMLElement> &spEl) const
   {
      ATLASSERT(pstrName);
      CComPtr<IHTMLDocument2> spDoc;
      if( _GetDhtmlDocument(spDoc)==FALSE ) return FALSE;
      HRESULT Hr;
      CComPtr<IHTMLElementCollection> spElements;
      Hr = spDoc->get_all(&spElements);
      if( FAILED(Hr) ) return FALSE;
      CComVariant vName(pstrName);
      CComVariant vIndex = (SHORT)0;
      CComPtr<IDispatch> spDisp;
      Hr = spElements->item(vName, vIndex, &spDisp);
      if( FAILED(Hr) ) return FALSE;
      CComQIPtr<IHTMLElement> spElement(spDisp);
      if( spElement==NULL ) return FALSE;
      spEl = spElement;
      return TRUE;
   }

   BOOL _GetDhtmlChildElement(CComPtr<IHTMLElement> &spEl, int iIndex, CComPtr<IHTMLElement> &spChild) const
   {
      ATLASSERT(spEl);
      CComPtr<IDispatch> spDisp;
      if( FAILED(spEl->get_children(&spDisp)) ) return FALSE;
      CComQIPtr<IHTMLElementCollection> spColl( spDisp );
      if( spColl==NULL ) return FALSE;
      spDisp.Release();
      CComVariant vEmpty;
      if( FAILED(spColl->item(CComVariant(iIndex), vEmpty, &spDisp)) ) return FALSE;
      CComQIPtr<IHTMLElement> spElement(spDisp);
      if( spElement==NULL ) return FALSE;
      spChild = spElement;
      return TRUE;
   }

   // Overridables

   void _ExternalInit()
   {
   }
};


/////////////////////////////////////////////////////////////////////////////
// CHTMLListCtrl

#define HLN_FIRST LVN_FIRST

#define HLN_SELCHANGING         (HLN_FIRST-0)
#define HLN_SELCHANGED          (HLN_FIRST-1)
#define HLN_MOUSEOUT            (HLN_FIRST-2)
#define HLN_MOUSEOVER           (HLN_FIRST-3)
#define HLN_INSERTITEM          (HLN_FIRST-4)
#define HLN_DELETEITEM          (HLN_FIRST-5)
#define HLN_INITIALIZE          (HLN_FIRST-6)

typedef struct
{
   NMHDR hdr;
   IHTMLElement* pOld;
   IHTMLElement* pNew;
   int iOldIndex;
   int iNewIndex;
} NMHTMLLIST, *LPNMHTMLLIST;

template< class T >
class CHTMLListImpl :
   public CWebDlgCtrl<T>,
   public IDispDynImpl<T>
{
public:
   int m_nCurSel;
   int m_nCount;

   // Implementation

   CHTMLListImpl() : m_nCount(0), m_nCurSel(-1)
   {
   }

   LPARAM _SendNotify(UINT code, IHTMLElement* pOld, IHTMLElement* pNew)
   {
      NMHTMLLIST nm;
      ::ZeroMemory(&nm, sizeof(nm));
      nm.hdr.hwndFrom = m_hWnd;
      nm.hdr.idFrom = GetDlgCtrlID();
      nm.hdr.code = code;
      nm.pNew = pNew;
      nm.pOld = pOld;
      if( pNew!=NULL ) nm.iNewIndex = GetItemIndex(pNew);
      if( pOld!=NULL ) nm.iOldIndex = GetItemIndex(pOld);
      return (LPARAM)::SendMessage(GetParent(), WM_NOTIFY, nm.hdr.idFrom, (LPARAM) &nm);
   }

   // Message Handlers (IDispatch really)

   void _stdcall OnInitialize()
   {
      _SendNotify(HLN_INITIALIZE, NULL, NULL);
   }

   void _stdcall OnClick(IDispatch* pDisp)
   {
      CComQIPtr<IHTMLElement> spEl(pDisp);
      if( _SendNotify(NM_CLICK, NULL, spEl)==0 ) {
         int iIndex = GetItemIndex(spEl);
         if( iIndex!=m_nCurSel ) SetCurSel(iIndex);
      }
   }

   void _stdcall OnMouseOver(IDispatch* pDisp)
   {
      CComQIPtr<IHTMLElement> spEl(pDisp);
      _SendNotify(HLN_MOUSEOVER, NULL, spEl);
   }

   void _stdcall OnMouseOut(IDispatch* pDisp)
   {
      CComQIPtr<IHTMLElement> spEl(pDisp);
      _SendNotify(HLN_MOUSEOUT, NULL, spEl);
   }

   void _stdcall OnMouseMove(IDispatch* pDisp)
   {
      CComQIPtr<IHTMLElement> spEl(pDisp);
      _SendNotify(NM_HOVER, NULL, spEl);
   }

   // Operations

   BOOL SubclassWindow(HWND hWnd, UINT nRes)
   {
      return Attach(hWnd, nRes);
   }

   BOOL AddScript(LPCTSTR pstr)
   {
      ATLASSERT(::IsWindow(m_hWnd));
      CComPtr<IHTMLDocument2> spDoc;
      if( _GetDhtmlDocument(spDoc)==FALSE ) return FALSE;
      CComPtr<IHTMLElement> spBody;
      if( FAILED(spDoc->get_body(&spBody)) ) return FALSE;
      CComBSTR bstr = pstr;
      spBody->insertAdjacentHTML(CComBSTR(L"afterBegin"), bstr);
      return TRUE;
   }

   int GetCount() const
   {
      ATLASSERT(::IsWindow(m_hWnd));
      return m_nCount;
   }
   int AddString(LPCTSTR lpszHTML)
   {
      ATLASSERT(::IsWindow(m_hWnd));
      ATLASSERT(!::IsBadStringPtr(lpszHTML,-1));
      // Create a new inner DIV element and insert it as outer DIV child.
      CComPtr<IHTMLElement> spEl;
      if( _GetDhtmlElement(L"inner", spEl)==FALSE ) return -1;
      CComBSTR bstr;
      TCHAR szBuffer[80];
      ::wsprintf(szBuffer, _T("<DIV INDEX=%d"), m_nCount);
      bstr = szBuffer;
      bstr += L" onclick=\"window.external.OnClick(this)\" onmouseover=\"window.external.OnMouseOver(this)\" onmouseout=\"window.external.OnMouseOut(this)\"  onmousemove=\"window.external.OnMouseMove(this)\">";
      bstr += lpszHTML;
      bstr += L"</DIV>";
      if( FAILED(spEl->insertAdjacentHTML(CComBSTR(L"beforeEnd"), bstr)) ) return -1;
      // Ok, we got one more element
      m_nCount++;
      // Send notification
      CComPtr<IHTMLElement> spElNew;
      if( _GetDhtmlChildElement(spEl, m_nCount-1, spElNew)==FALSE ) return -1;
      _SendNotify(HLN_INSERTITEM, NULL, spElNew);
      return m_nCount-1;
   }
   BOOL DeleteString(UINT nIndex)
   {
      ATLASSERT(::IsWindow(m_hWnd));
      ATLASSERT(false); // not implemented
      nIndex;
      return FALSE;
   }
   void ResetContent()
   {
      ATLASSERT(::IsWindow(m_hWnd));
      CComPtr<IHTMLElement> spEl;
      if( _GetDhtmlElement(L"inner", spEl)==FALSE ) return;
      spEl->put_innerHTML(CComBSTR(""));
      m_nCount = 0;
      m_nCurSel = -1;
   }
   int FindString(int nStartAfter, LPCTSTR lpszItem) const
   {
      ATLASSERT(::IsWindow(m_hWnd));
      ATLASSERT(!::IsBadStringPtr(lpszItem, -1));
      ATLASSERT(nStartAfter>=0 && nStartAfter<m_nCount);
      CComPtr<IHTMLElement> spEl;
      if( _GetDhtmlElement(L"inner", spEl)==FALSE ) return -1;
      CComPtr<IDispatch> spDisp;
      spEl->get_children(&spDisp);
      CComQIPtr<IHTMLElementCollection> spColl(spDisp);
      if( spColl==NULL ) return -1;
      long cnt;
      spColl->get_length(&cnt);
      CComBSTR bstrID(L"ITEMDATA");
      CComVariant vEmpty;
      USES_CONVERSION;
      LPCOLESTR pwstrItem = T2COLE(lpszItem);
      for( int i=nStartAfter; i>=0 && i<cnt; i++ ) {
         CComPtr<IDispatch> spDisp;
         if( FAILED(spColl->item(CComVariant(i), vEmpty, &spDisp)) ) return -1;
         CComQIPtr<IHTMLElement> spEl(spDisp);
         CComVariant vRes;
         if( FAILED(spEl->getAttribute(bstrID, 0, &vRes)) ) return -1;
         ATLASSERT(vRes.vt==VT_BSTR);
         if( wcscmp(vRes.bstrVal, pwstrItem)==0 ) return i;
      }
      return 0;
   }
   BOOL GetItemData(int iIndex, LPTSTR lpszString, UINT cchMax) const
   {
      ATLASSERT(::IsWindow(m_hWnd));
      ATLASSERT(!::IsBadWritePtr(lpszString, cchMax));
      CComPtr<IHTMLElement> spEl;
      if( _GetDhtmlElement(L"inner", spEl)==FALSE ) return FALSE;
      CComPtr<IHTMLElement> spChild;
      if( _GetDhtmlChildElement(spEl, iIndex, spChild)==FALSE ) return FALSE;
      CComVariant vData;
      if( FAILED(spChild->getAttribute(CComBSTR(L"ITEMDATA"), 0, &vData)) ) return FALSE;
      ATLASSERT(vData.vt==VT_BSTR);
      USES_CONVERSION;
      ::lstrcpyn(lpszString, OLE2CT(vData.bstrVal), cchMax);
      return TRUE;
   }
   BOOL SetItemData(int iIndex, LPCTSTR lpszString) const
   {
      ATLASSERT(::IsWindow(m_hWnd));
      ATLASSERT(!::IsBadStringPtr(lpszString, -1));
      CComPtr<IHTMLElement> spEl;
      if( _GetDhtmlElement(L"inner", spEl)==FALSE ) return FALSE;
      CComPtr<IHTMLElement> spChild;
      if( _GetDhtmlChildElement(spEl, iIndex, spChild)==FALSE ) return FALSE;
      CComVariant vData = lpszString;
      if( FAILED(spChild->setAttribute(CComBSTR(L"ITEMDATA"), vData, 0)) ) return FALSE;
      return TRUE;
   }
   int GetItemIndex(IHTMLElement* pEl) const
   {
      ATLASSERT(::IsWindow(m_hWnd));
      ATLASSERT(pEl);
      if(pEl==NULL ) return -1;
      CComVariant vID;
      if( FAILED(pEl->getAttribute(CComBSTR(L"INDEX"), 0, &vID)) ) return -1;
      ATLASSERT(vID.vt==VT_BSTR);
      vID.ChangeType(VT_I4);
      return vID.lVal;
   }
   int GetCurSel() const
   {
      ATLASSERT(::IsWindow(m_hWnd));
      return m_nCurSel;
   }
   int SetCurSel(int nSelect)
   {
      ATLASSERT(::IsWindow(m_hWnd));
      ATLASSERT(nSelect>=-1 && nSelect<m_nCount);
      CComPtr<IHTMLElement> spEl;
      if( _GetDhtmlElement(L"inner", spEl)==FALSE ) return -1;
      CComPtr<IHTMLElement> spOld;
      CComPtr<IHTMLElement> spNew;
      if( m_nCurSel>=0 ) _GetDhtmlChildElement(spEl, m_nCurSel, spOld);
      if( nSelect>=0 ) _GetDhtmlChildElement(spEl, nSelect, spNew);
      int nOldSel = m_nCurSel;
      if( _SendNotify(HLN_SELCHANGING, spOld, spNew)==0 ) {
         m_nCurSel = nSelect;
         _SendNotify(HLN_SELCHANGED, spOld, spNew);
      }
      return nOldSel;
   }
};

class CHTMLListCtrl :
   public CHTMLListImpl<CHTMLListCtrl>
{
public:
   BEGIN_DISPATCH_MAP(CHTMLListCtrl)
      DISP_METHOD1(OnClick,      VT_EMPTY, VT_DISPATCH)
      DISP_METHOD1(OnMouseOver,  VT_EMPTY, VT_DISPATCH)
      DISP_METHOD1(OnMouseOut,   VT_EMPTY, VT_DISPATCH)
      DISP_METHOD1(OnMouseMove,  VT_EMPTY, VT_DISPATCH)
      DISP_METHOD0(OnInitialize, VT_EMPTY)
   END_DISPATCH_MAP()

   void _ExternalInit()
   {
      SetExternalDispatch(static_cast<IDispatch*>(this));
   }
};

#endif // !defined(AFX_HTMLLISTBOX_H__20010607_D1F3_C48F_2458_0080AD509054__INCLUDED_)

