// maindlg.h : interface of the CMainDlg class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_MAINDLG_H__66DFE0DA_AD21_4884_B746_43EE9A8502FF__INCLUDED_)
#define AFX_MAINDLG_H__66DFE0DA_AD21_4884_B746_43EE9A8502FF__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "ImageListBox2.h"


class CMainDlg : public CDialogImpl<CMainDlg>
{
public:
   enum { IDD = IDD_MAINDLG };

   CFont m_boldFont;
   CFont m_smallFont;
   
   CImageListBoxCtrl m_list;

   CImageList m_imgDark;
   CImageList m_imgLight;

   BEGIN_MSG_MAP(CMainDlg)
      MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
      COMMAND_ID_HANDLER(ID_APP_ABOUT, OnAppAbout)
      COMMAND_ID_HANDLER(IDOK, OnOK)
      COMMAND_ID_HANDLER(IDCANCEL, OnCancel)
      REFLECT_NOTIFICATIONS()
   END_MSG_MAP()

   LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      // center the dialog on the screen
      CenterWindow();

      // set icons
      HICON hIcon = (HICON)::LoadImage(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
         IMAGE_ICON, ::GetSystemMetrics(SM_CXICON), ::GetSystemMetrics(SM_CYICON), LR_DEFAULTCOLOR);
      SetIcon(hIcon, TRUE);
      HICON hIconSmall = (HICON)::LoadImage(_Module.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
         IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), LR_DEFAULTCOLOR);
      SetIcon(hIconSmall, FALSE);

      LOGFONT lf;
      ::GetObject(GetFont(), sizeof(LOGFONT), &lf);
      lf.lfWeight = FW_BOLD;
      m_boldFont.CreateFontIndirect(&lf);
      lf.lfWeight = FW_NORMAL;
      if( lf.lfHeight<0 ) lf.lfHeight += 2;
      m_smallFont.CreateFontIndirect(&lf);

      // NOTE: The image size determines the list-item height !!!!

      //m_imgDark.CreateFromImage(IDB_IMAGES_DARK, 40, 10, RGB(255,0,255), IMAGE_BITMAP, 0);
      //m_imgLight.CreateFromImage(IDB_IMAGES_LIGHT, 40, 10, RGB(255,0,255), IMAGE_BITMAP, 0);
      m_imgDark.Create(IDB_IMAGES_DARK, 40, 0, RGB(255,0,255));
      m_imgLight.Create(IDB_IMAGES_LIGHT, 40, 0, RGB(255,0,255));

      RECT rcClient;
      GetClientRect(&rcClient);

      ILBSETTINGS cfg;
      m_list.SubclassWindow(GetDlgItem(IDC_LIST));
      m_list.SetImageList(m_imgLight, ILSIL_NORMAL);
      m_list.SetFont(m_boldFont);
      m_list.SetSmallFont(m_smallFont);

      m_list.GetPreferences(&cfg);
      cfg.clrHighlite = RGB(247,247,247);
      cfg.clrHighliteText = RGB(0,0,0);
      cfg.clrHighliteBorder = RGB(148,150,148);
      cfg.clrText = RGB(0,0,0);
      cfg.clrBackground = RGB(255,255,255);
      cfg.sizeMargin.cx = cfg.sizeMargin.cy = 1;
      cfg.sizeSubIndent.cx = 10;
      cfg.sizeSubIndent.cy = 4;
      m_list.SetPreferences(cfg);

      ILBITEM item = { 0 };
      item.mask = ILBIF_TEXT | ILBIF_SUBTEXT | ILBIF_IMAGE | ILBIF_STYLE | ILBIF_FORMAT;
      item.iItem = 0;
      item.pszText = _T("Menu data");
      item.pszSubText = _T("Displays the menu");
      item.format = DT_LEFT;
      item.iImage = 5;
      item.style = ILBS_IMGRIGHT | ILBS_SELROUND;
      m_list.InsertItem(&item);
      item.iItem = 1;
      item.pszText = _T("Show toolbar data");
      item.pszSubText = _T("Displays the toolbar.");
      m_list.InsertItem(&item);

      m_list.SelectItem(0);

      return TRUE;
   }

   LRESULT OnAppAbout(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      CSimpleDialog<IDD_ABOUTBOX, FALSE> dlg;
      dlg.DoModal();
      return 0;
   }

   LRESULT OnOK(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      // TODO: Add validation code 
      EndDialog(wID);
      return 0;
   }

   LRESULT OnCancel(WORD /*wNotifyCode*/, WORD wID, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      EndDialog(wID);
      return 0;
   }
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft eMbedded Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_MAINDLG_H__66DFE0DA_AD21_4884_B746_43EE9A8502FF__INCLUDED_)
