#if !defined(AFX_ATLVBEVENTS_H__6B3ABF84_BEF6_11D3_82EA_0080AD509054__INCLUDED_)
#define AFX_ATLVBEVENTS_H__6B3ABF84_BEF6_11D3_82EA_0080AD509054__INCLUDED_

#pragma once

#ifndef __ATLWIN_H__
   #error atlvbevents.h requires atlwin.h to be included first
#endif

////////////////////////////////////////////////////////////////////////////
// atlvbevents.h - Visual Basic 6.0 event message maps
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000-2001 Bjarke Viksoe.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//
// Implements the standard VB mouse and keyboard events
// for an ActiveX control.
//
// Several things are assumed in this class:
//  * The proper IDL entries are present.
//  * Connection Point is set up.
//  * Add a "m_bDesignMode" flag in the base class to reflect the 
//    ambient DISPID_AMBIENT_USERMODE property.
//  * Derive from the helper class.
//  * Chain the Message Map:
//    E.g. CHAIN_MSG_MAP(CVbMouseEvents<CBase>)
//

// VB Mouse events:
//   [id(DISPID_CLICK)] void Click();
//   [id(DISPID_DBLCLICK)] void DblClick();
//   [id(DISPID_MOUSEMOVE)] void MouseMove([in] short Button, [in] short Shift, [in] OLE_XPOS_PIXELS x, [in] OLE_YPOS_PIXELS y);
//   [id(DISPID_MOUSEDOWN)] void MouseUp([in] short Button, [in] short Shift, [in] OLE_XPOS_PIXELS x, [in] OLE_YPOS_PIXELS y);
//   [id(DISPID_MOUSEUP)] void MouseDown([in] short Button, [in] short Shift, [in] OLE_XPOS_PIXELS x, [in] OLE_YPOS_PIXELS y);
template<class T>
class ATL_NO_VTABLE CVbMouseEvents
{
public:
   // Message map
   BEGIN_MSG_MAP(CVbMouseEvents)
      MESSAGE_HANDLER(WM_MOUSEMOVE, OnMouseMove)
      MESSAGE_HANDLER(WM_LBUTTONDOWN, OnButtonDown)
      MESSAGE_HANDLER(WM_RBUTTONDOWN, OnButtonDown)
      MESSAGE_HANDLER(WM_MBUTTONDOWN, OnButtonDown)
      MESSAGE_HANDLER(WM_LBUTTONUP, OnButtonUp)
      MESSAGE_HANDLER(WM_RBUTTONUP, OnButtonUp)
      MESSAGE_HANDLER(WM_MBUTTONUP, OnButtonUp)
      MESSAGE_HANDLER(WM_LBUTTONDBLCLK, OnButtonDblClick)
   END_MSG_MAP()

   LRESULT OnMouseMove(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
   {
      bHandled = FALSE;
      T* pT = static_cast<T*>(this);
      if( pT->m_bDesignMode ) return 0; // not in design mode     
      short Button, Shift;
      OLE_XPOS_PIXELS x;
      OLE_YPOS_PIXELS y;
      GetMouseInfo(wParam, lParam, Button, Shift, x, y);
      pT->Fire_MouseMove(Button, Shift, x, y);
      return 0;
   }
   LRESULT OnButtonUp(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
   {
      bHandled = FALSE;
      T* pT = static_cast<T*>(this);
      if( pT->m_bDesignMode ) return 0; // not in design mode      
      short Button, Shift;
      OLE_XPOS_PIXELS x;
      OLE_YPOS_PIXELS y;
      GetMouseInfo(wParam, lParam, Button, Shift, x, y);
      pT->Fire_MouseUp(Button, Shift, x, y);
      return 0;
   }
   LRESULT OnButtonDown(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
   {
      bHandled = FALSE;
      T* pT = static_cast<T*>(this);
      if( pT->m_bDesignMode ) return 0; // not in design mode
      // Generate mouse down event      
      short Button, Shift;
      OLE_XPOS_PIXELS x;
      OLE_YPOS_PIXELS y;
      GetMouseInfo(wParam, lParam, Button, Shift, x, y);
      pT->Fire_MouseDown(Button, Shift, x, y);
      // In case of a left-button mouse-click we need to
      // generate Click,
      if( (wParam & MK_LBUTTON)==0 ) return 0;
      pT->Fire_Click();
      return 0;
   }
   LRESULT OnButtonDblClick(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM lParam, BOOL& bHandled)
   {
      bHandled = FALSE;
      T* pT = static_cast<T*>(this);
      if( pT->m_bDesignMode ) return 0; // not in design mode
      pT->Fire_DblClick();
      return 0;
   }

   void GetMouseInfo(WPARAM wParam, LPARAM lParam, 
                     short &Button, short &Shift, 
                     OLE_XPOS_PIXELS &x, OLE_YPOS_PIXELS &y) const
   {
      Button = 0;
      Shift = 0;
      if( wParam & MK_LBUTTON ) Button |= 1;
      if( wParam & MK_RBUTTON ) Button |= 2;
      if( wParam & MK_MBUTTON ) Button |= 4;
      if( wParam & MK_SHIFT ) Shift |= 1;
      if( wParam & MK_CONTROL ) Shift |= 2;
      if( ::GetKeyState(VK_MENU)<0 ) Shift |= 4;
      //
      x = (OLE_XPOS_PIXELS) GET_X_LPARAM(lParam);
      y = (OLE_YPOS_PIXELS) GET_Y_LPARAM(lParam);
   }
};

// VB Key events:
//   [id(DISPID_KEYDOWN)] void KeyDown(short KeyCode, short Shift);      
//   [id(DISPID_KEYUP)] void KeyUp(short KeyCode, short Shift);      
//   [id(DISPID_KEYPRESS)] void KeyPress(short* KeyAscii);
// Remember to fix IConnectionPointImpl, which in ATL30 has problems
// with the VT_BYREF type for DISPID_KEYPRESS.
template<class T>
class ATL_NO_VTABLE CVbKeyEvents
{
public:
   // Message map
   BEGIN_MSG_MAP(CVbKeyEvents)
      MESSAGE_HANDLER(WM_KEYDOWN, OnKeyDown)
      MESSAGE_HANDLER(WM_KEYUP, OnKeyUp)
      MESSAGE_HANDLER(WM_CHAR, OnChar)
   END_MSG_MAP()

   LRESULT OnKeyUp(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
   {
      bHandled = FALSE;
      T* pT = static_cast<T*>(this);
      if( pT->m_bDesignMode ) return 0; // not in design mode
      short Shift, Key;
      GetKeyInfo(wParam, lParam, Shift, Key);
      pT->Fire_KeyUp(Key, Shift);
      return 0;
   }
   LRESULT OnKeyDown(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
   {
      bHandled = FALSE;
      T* pT = static_cast<T*>(this);
      if( pT->m_bDesignMode ) return 0; // not in design mode
      short Shift, Key;
      GetKeyInfo(wParam, lParam, Shift, Key);
      pT->Fire_KeyDown(Key, Shift);
      return 0;
   }
   LRESULT OnChar(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& bHandled)
   {
      bHandled = FALSE;
      T* pT = static_cast<T*>(this);
      if( pT->m_bDesignMode ) return 0; // not in design mode
      short Key = (short)wParam;
      pT->Fire_KeyPress(&Key);
      // TODO: Figure out what to do if 'Key' has been changed.
      return 0;
   }

   void GetKeyInfo(WPARAM wParam, LPARAM /*lParam*/, 
                                  short &Shift, short &Key) const
   {
      Shift = 0;
      if( ::GetKeyState(VK_SHIFT)<0 ) Shift |= 1;
      if( ::GetKeyState(VK_CONTROL)<0 ) Shift |= 2;
      if( ::GetKeyState(VK_MENU)<0 ) Shift |= 4;
      //
      Key = (short)wParam;
   }
};

#endif // !defined(AFX_ATLVBEVENTS_H__6B3ABF84_BEF6_11D3_82EA_0080AD509054__INCLUDED_)
