// AtlHelpers.h: interface for the AtlHelpers class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ATLHELPERS_H__6B3ABF84_BEF6_11D3_82EA_0080AD509054__INCLUDED_)
#define AFX_ATLHELPERS_H__6B3ABF84_BEF6_11D3_82EA_0080AD509054__INCLUDED_

#pragma once
//
// atlhelpers.h - My ATL helper functions
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000-2001 Bjarke Viksoe.
//
// This code may be used in compiled form in any way you desire. This
// source file may be redistributed by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//

#ifndef __ATLCOM_H__
   #error atlhelpers.h requires atlcom.h to be included first
#endif

// Neat macros someone always leaves out
#ifndef lengthof
   #define lengthof(x) (sizeof(x)/sizeof(*x))
#endif

#ifndef offsetof
  #define offsetof(type, field) ((int)&((type*)0)->field)
#endif


// The annoying missing VARIANT type!
// Use this to construct an optional VARIANT argument value.
// A lot of old COM implementations actually check for this code
// for their optional automation arguments.
// Usage: CComVariant vEmpty(VT_MISSING)
#define VT_MISSING DISP_E_PARAMNOTFOUND, VT_ERROR

//
// ATL error handlers and validating macros
//
#ifdef _DEBUG
#define HR(expr) if(FAILED(Hr=expr)) { _CrtDbgReport(_CRT_ASSERT, __FILE__, __LINE__, NULL, #expr); _CrtDbgBreak(); return Hr; }
#define VALIDATE_POINTER(p) ATLASSERT(p); if(!p) return E_POINTER
#define VALIDATE_OUT_POINTER(p) ATLASSERT(p); if(!p) return E_POINTER; else *p=NULL
#else
#define HR(expr) if(FAILED(Hr=expr)) return Hr
#define VALIDATE_POINTER(p) if(!p) return E_POINTER
#define VALIDATE_OUT_POINTER(p) if(!p) return E_POINTER; else *p=NULL
#endif
#define USE_ARG(arg) arg

//
// Conversions
//
#define BOOL_TO_VARIANTBOOL(f) ((f) ? VARIANT_TRUE : VARIANT_FALSE)
#define VARIANTBOOL_TO_BOOL(f) ((f)!=VARIANT_FALSE)

//
// BSTR and other methods missing in ATL library
//
inline HRESULT CComVariant_CopyTo(VARIANT* dest, VARIANT* src) 
{
   return ::VariantCopy(dest, src);
}

//
// The great Auto Memory Release template class,
// which is located in the ATL OleDB file. We don't
// want to include atldb.h all the time, so here is
// the class.
//
#ifndef __ATLDB_H
template <class T>
class CRunTimeFree
{
public:
   static void Free(T* pData) { delete [] pData; }
};
template <class T>
class CComFree
{
public:
   static void Free(T* pData) { ::CoTaskMemFree(pData); }
};
template <class T, class DeAllocator = CRunTimeFree< T > >
class CAutoMemRelease
{
public:
   CAutoMemRelease()
   {
      m_pData = NULL;
   }
   CAutoMemRelease(T* pData)
   {
      m_pData = pData;
   }
   ~CAutoMemRelease()
   {
      Attach(NULL);
   }
   void Attach(T* pData)
   {
      DeAllocator::Free(m_pData);
      m_pData = pData;
   }
   T* Detach()
   {
      T* pTemp = m_pData;
      m_pData = NULL;
      return pTemp;
   }
   T* m_pData;
};
#endif

//
// "Copy Policy" helper functions for implementing collections.
// These are mostly ripped from the book "ATL Internals" by Rector & Sells.
//
struct _CopyBSTR
{
  static HRESULT copy(BSTR* p1, BSTR* p2)
  {
    HRESULT hr = S_OK;
    (*p1) = (LPOLESTR)::SysAllocString(*p2);
    if (*p1 == NULL) hr = E_OUTOFMEMORY;
    return hr;
  }
  static void init(LPOLESTR* p) { *p = NULL; }
  static void destroy(LPOLESTR* p) { ::SysFreeString(*p);}
};
#if _ATL_VER < 0x0700 
template< class T >
struct _CopyVariantFromAdaptItf 
{
   static HRESULT copy(VARIANT* p1, CAdapt< CComPtr< T > >* p2) 
   {
      HRESULT Hr = p2->m_T->QueryInterface(IID_IDispatch, (void**)&p1->pdispVal);
      if( SUCCEEDED(Hr) ) {
         p1->vt = VT_DISPATCH;
      }
      else {
         Hr = p2->m_T->QueryInterface(IID_IUnknown, (void**)&p1->punkVal);
         if( SUCCEEDED(Hr) ) p1->vt = VT_UNKNOWN;
      };
      return Hr;
   };
   static void init(VARIANT* p) { ::VariantInit(p); }
   static void destroy(VARIANT* p) { ::VariantClear(p); }
};
template< class T >
struct _CopyItfFromAdaptItf 
{
   static HRESULT copy(T** p1, CAdapt< CComPtr< T > >* p2) 
   {
      if( *p1=p2->m_T ) return (*p1)->AddRef(), S_OK;
      return E_POINTER;
   }
   static void init(T** p) {}
   static void destroy(T** p) { if(*p) return (*p)->Release(); }
};

// My copy-policy classes for CComObject<T>
template< typename T >
struct _CopyVariantFromAdaptComObj
{
   static HRESULT copy(VARIANT* p1, CAdapt< CComObject<T> >* p2) 
   {
      HRESULT Hr = p2->m_T->QueryInterface(IID_IDispatch, (void**)&p1->pdispVal);
      if( SUCCEEDED(Hr) ) {
         p1->vt = VT_DISPATCH;
      }
      else {
         Hr = p2->m_T->QueryInterface(IID_IUnknown, (void**)&p1->punkVal);
         if( SUCCEEDED(Hr) ) p1->vt = VT_UNKNOWN;
      };
      return Hr;
   };
   static void init(VARIANT* p) { ::VariantInit(p); }
   static void destroy(VARIANT* p) { ::VariantClear(p); }
};
template< typename T, typename Base >
struct _CopyItfFromAdaptComObj
{
   static HRESULT copy(T** p1, CAdapt< CComObject<T> >* p2) 
   {
      if( *p1 = p2->m_T ) return (*p1)->AddRef(), S_OK;
      return E_POINTER;
   }
   static void init(T** p) {};
   static void destroy(T** p) { if(*p) return (*p)->Release(); }
};
#endif // _ATL_VER 

//
// QI for 'this' (also from "ATL Internals"):
// Note that this will not work if caller and callee do not run in the same context!
//
inline HRESULT WINAPI _This(void* pv, REFIID iid, void** ppvObject, DWORD) 
{
   ATLASSERT(iid==IID_NULL);
   iid;
   *ppvObject = pv;
   return S_OK;
}
#define COM_INTERFACE_ENTRY_THIS() COM_INTERFACE_ENTRY_FUNC(IID_NULL, 0, _This)


#endif // !defined(AFX_ATLHELPERS_H__6B3ABF84_BEF6_11D3_82EA_0080AD509054__INCLUDED_)
