#if !defined(AFX_ATLCTLHELPERS_H__6B3ABF84_BEF6_11D3_82EA_0080AD509054__INCLUDED_)
#define AFX_ATLCTLHELPERS_H__6B3ABF84_BEF6_11D3_82EA_0080AD509054__INCLUDED_

#pragma once

//
// atlctlhelpers.h - My ATL ActiveX control helper functions
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000-2001 Bjarke Viksoe.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//

#ifndef __cplusplus
   #error ATL requires C++ compilation (use a .cpp suffix)
#endif

#ifndef __ATLCTL_H__
   #error atlctlhelper.h requires atlctl.h to be included first
#endif

// Implements a scroll view for a control
template<class T>
class CScrollView
{
public:
   RECT m_rcView;
   POINT m_ptViewPos;
   int m_iScrollPage;
   int m_iScrollLine;

   BEGIN_MSG_MAP(CScrollView)
      MESSAGE_HANDLER(WM_VSCROLL, OnVScroll)
      MESSAGE_HANDLER(WM_HSCROLL, OnHScroll)
   END_MSG_MAP()

   CScrollView()
   {
      m_iScrollPage = 50;
      m_iScrollLine = 5;
   }

   void UpdateScrollView(RECT &rcPage)
   {
      T* pT = static_cast<T*>(this);
      SIZE sizeView = { m_rcView.right - m_rcView.left, m_rcView.bottom - m_rcView.top };
      SIZE sizeClient = { rcPage.right - rcPage.left, rcPage.bottom - rcPage.top };
      SCROLLINFO si;
      si.cbSize = sizeof(si);
      si.fMask = SIF_DISABLENOSCROLL | SIF_RANGE | SIF_PAGE;
      si.nMin = 0;
      si.nMax = sizeView.cx-1;
      si.nPage = sizeClient.cx;
      pT->SetScrollInfo(SB_HORZ, &si, TRUE);   
      si.nMin = 0;
      si.nMax = sizeView.cy-1;
      si.nPage = sizeClient.cy;
      pT->SetScrollInfo(SB_VERT, &si, TRUE);   
   }

   LRESULT OnHScroll(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      T* pT = static_cast<T*>(this);
      int xNewPos;    // new position 

      switch (LOWORD(wParam)) { 
      case SB_PAGEUP: 
         xNewPos = m_ptViewPos.x - m_iScrollPage; 
         break; 
      case SB_PAGEDOWN: 
         xNewPos = m_ptViewPos.x + m_iScrollPage; 
         break; 
      case SB_LINEUP: 
         xNewPos = m_ptViewPos.x - m_iScrollLine; 
         break; 
      case SB_LINEDOWN: 
         xNewPos = m_ptViewPos.x + m_iScrollLine; 
         break; 
      case SB_THUMBPOSITION: 
         xNewPos = HIWORD(wParam); 
         break; 
      default: 
         xNewPos = m_ptViewPos.x; 
      } 
   
      // New position must be between 0 and the screen width. 
      int xMinScroll, xMaxScroll;
      pT->GetScrollRange(SB_HORZ, &xMinScroll, &xMaxScroll);
      xNewPos = max(0, xNewPos); 
      xNewPos = min(xMaxScroll, xNewPos); 

      // If the current position does not change, do not si.
      if( xNewPos==m_ptViewPos.x ) return 0; 

      // Reset the current scroll position. 
      m_ptViewPos.x = xNewPos; 

      // Reset the scroll bar. 
      SCROLLINFO si;
      si.cbSize = sizeof(si); 
      si.fMask  = SIF_POS; 
      si.nPos   = m_ptViewPos.x; 
      pT->SetScrollInfo(SB_HORZ, &si, TRUE); 

      pT->FireViewChange();
      return 0;
   };

   LRESULT OnVScroll(UINT /*uMsg*/, WPARAM wParam, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      T* pT = static_cast<T*>(this);
      int yNewPos;    // new position 

      switch( LOWORD(wParam) ) { 
      case SB_PAGEUP: 
         yNewPos = m_ptViewPos.y - 50; 
         break; 
      case SB_PAGEDOWN: 
         yNewPos = m_ptViewPos.y + 50; 
         break; 
      case SB_LINEUP: 
         yNewPos = m_ptViewPos.y - 5; 
         break; 
      case SB_LINEDOWN: 
         yNewPos = m_ptViewPos.y + 5; 
         break; 
      case SB_THUMBPOSITION: 
         yNewPos = HIWORD(wParam); 
         break; 
      default: 
         yNewPos = m_ptViewPos.y; 
      } 

      // New position must be between 0 and the screen height. 
      int yMinScroll, yMaxScroll;
      pT->GetScrollRange(SB_VERT, &yMinScroll, &yMaxScroll);
      yNewPos = max(0, yNewPos); 
      yNewPos = min(yMaxScroll, yNewPos); 

      // If the current position does not change, do not scroll.
      if( yNewPos==m_ptViewPos.y ) return 0;

      // Reset the current scroll position. 
      m_ptViewPos.y = yNewPos; 

      // Reset the scroll bar. 
      SCROLLINFO si;
      si.cbSize = sizeof(si); 
      si.fMask  = SIF_POS; 
      si.nPos   = m_ptViewPos.y; 
      pT->SetScrollInfo(SB_VERT, &si, TRUE); 

      pT->FireViewChange();
      return 0;
   };
};


//
// Macros for defining properties.
// Works with all native data types. Use the _COPY_ macros
// when dealing with wrapper classes (must support CopyTo() method).
//

#define IMPLEMENT_STD_PROP_RW(type, fname, pname) \
   STDMETHOD(put_##fname)(type newVal) \
   { \
      ATLTRACE2(atlTraceControls,2,_T("Property: put_%s\n"), #fname); \
      ##pname = newVal; \
      m_bRequiresSave = TRUE; \
      SendOnDataChange(NULL); \
      FireViewChange(); \
      return S_OK; \
   } \
   STDMETHOD(get_##fname)(type *pVal) \
   { \
      ATLTRACE2(atlTraceControls,2,_T("Property: get_%s\n"), #fname); \
      if( pVal==NULL ) return E_POINTER; \
      *pVal = ##pname; \
      return S_OK; \
   }

#define IMPLEMENT_STD_PROP_WO(type, fname, pname) \
   STDMETHOD(put_##fname)(type newVal) \
   { \
      ATLTRACE2(atlTraceControls,2,_T("Property: put_%s\n"), #fname); \
      ##pname = newVal; \
      m_bRequiresSave = TRUE; \
      SendOnDataChange(NULL); \
      FireViewChange(); \
      return S_OK; \
   }

#define IMPLEMENT_STD_PROP_RO(type, fname, pname) \
   STDMETHOD(get_##fname)(type *pVal) \
   { \
      ATLTRACE2(atlTraceControls,2,_T("Property: get_%s\n"), #fname); \
      if( pVal==NULL ) return E_POINTER; \
      *pVal = ##pname; \
      return S_OK; \
   }

#define IMPLEMENT_COPY_PROP_RW(type, fname, pname) \
   STDMETHOD(put_##fname)(type newVal) \
   { \
      ATLTRACE2(atlTraceControls,2,_T("Property: put_%s\n"), #fname); \
      ##pname = newVal; \
      m_bRequiresSave = TRUE; \
      SendOnDataChange(NULL); \
      FireViewChange(); \
      return S_OK; \
   } \
   STDMETHOD(get_##fname)(type *pVal) \
   { \
      ATLTRACE2(atlTraceControls,2,_T("Property: get_%s\n"), #fname); \
      if( pVal==NULL ) return E_POINTER; \
      HRESULT hr = ##pname.CopyTo(pVal); \
      return hr; \
   }

#define IMPLEMENT_COPY_PROP_WO(type, fname, pname) \
   STDMETHOD(put_##fname)(type newVal) \
   { \
      ATLTRACE2(atlTraceControls,2,_T("Property: put_%s\n"), #fname); \
      ##pname = newVal; \
      m_bRequiresSave = TRUE; \
      SendOnDataChange(NULL); \
      FireViewChange(); \
      return S_OK; \
   }

#define IMPLEMENT_COPY_PROP_RO(type, fname, pname) \
   STDMETHOD(get_##fname)(type *pVal) \
   { \
      ATLTRACE2(atlTraceControls,2,_T("Property: get_%s\n"), #fname); \
      if( pVal==NULL ) return E_POINTER; \
      HRESULT hr = ##pname.CopyTo(pVal); \
      return hr; \
   }

#endif // !defined(AFX_ATLCTLHELPERS_H__6B3ABF84_BEF6_11D3_82EA_0080AD509054__INCLUDED_)
