// SiteTree.cpp : Implementation of CSiteMap
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000-2001 Bjarke Viksoe.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//

#include "stdafx.h"

#include "SiteMapCtrl.h"
#include "SiteMap.h"


/////////////////////////////////////////////////////////////////////////////
// CSiteMap helper functions

// A little helper function which converts the IItems collection
// (with all its IItem entries) into a C++ array.
// All the item properties are fetched and stuffed into the
// "tNode" structure.
void CSiteMap::_ConvertToTree(CItems *pItems, 
                              tNode *pNodes, long lSize, 
                              BOOL bIncludeAll/*=FALSE*/) const
{
   ATLASSERT(pItems);
   ATLASSERT(!::IsBadReadPtr(pNodes,lSize*sizeof(tNode)));
   ATLASSERT(lSize==pItems->m_coll.size());

   listItems::iterator iter = pItems->m_coll.begin();
   while( iter != pItems->m_coll.end() ) {
      //CComPtr<IItem> spItem(*iter);
      IItem *spItem = (*iter).m_T.p; // avoid ref.count for speed!
      ATLASSERT(spItem);

      // Extract all common properties
      tNode &item = *pNodes;
      spItem->get_ID(&item.ID);
      spItem->get_Left(&item.x);
      spItem->get_Top(&item.y);
      spItem->get_Width(&item.width);
      spItem->get_Height(&item.height);
      VARIANT_BOOL vb;
      spItem->get_Expanded(&vb);
      item.bShowChildren = VARIANTBOOL_TO_BOOL(vb);
      spItem->get_Selected(&vb);
      item.bIsSelected = VARIANTBOOL_TO_BOOL(vb);
      CComPtr<IItem> spParent;
      spItem->get_Parent(&spParent);
      if( spParent!=NULL ) spParent->get_ID(&item.ParentID); else item.ParentID = -1;
      // Include uncommon properties?
      if( bIncludeAll ) {
         spItem->get_Title(&item.Title);
      }
      // Reset custom attributes
      item.bHasChildren = false;
      item.leftIndex = item.rightIndex = item.parentIndex = -1;
      item.oldX = item.x;
      item.oldY = item.y;

      iter++;
      pNodes++;
   }
   return;
}

void CSiteMap::_CalcClientArea()
{
   if( !IsWindow() ) return;
   ATLASSERT(m_pItems);

   // Find the area covered by the graph
   long min_x, min_y, max_x, max_y;

   // Include the current window area
   RECT rcClient;
   GetClientRect(&rcClient);
   ::OffsetRect(&rcClient, m_ptViewPos.x, m_ptViewPos.y);
   min_x = rcClient.left;
   min_y = rcClient.top;
   max_x = rcClient.right;
   max_y = rcClient.bottom;

   // Include all the nodes...
   listItems::iterator iter = m_pItems->m_coll.begin();
   while (iter != m_pItems->m_coll.end()) {
      CComPtr<IItem> spItem(*iter);
      ATLASSERT(spItem);

      long x,y,width,height;
      spItem->get_Left(&x);
      spItem->get_Top(&y);
      spItem->get_Width(&width);
      spItem->get_Height(&height);

      min_x = min(min_x, x);
      min_y = min(min_y, y);
      max_x = max(max_x, x+width);
      max_y = max(max_y, y+height);

      iter++;
   }

   m_rcView.left = min_x;
   m_rcView.top = min_y;
   m_rcView.right = max_x;
   m_rcView.bottom = max_y;
  
   // Update the View properties
   SIZE sizePixels = { m_rcView.right - m_rcView.left, m_rcView.bottom - m_rcView.top };
   SIZE sizeMetrics;
   AtlPixelToHiMetric(&sizePixels, &sizeMetrics);
   m_dwViewWidth = sizeMetrics.cx;
   m_dwViewHeight = sizeMetrics.cy;

   // Update scrollbars
   if( m_vbScrollBars==VARIANT_TRUE ) {
      UpdateScrollView(rcClient);
   }
}

bool CSiteMap::_HitTest(float x, float y, IItem **ppItem, HITTYPE &HitType) const
{
   if( ppItem==NULL ) return false;
   *ppItem = NULL;

   SIZE sizeOut = { (long)x, (long)y };
   sizeOut.cx += m_ptViewPos.x;
   sizeOut.cy += m_ptViewPos.y;

   // For all items, check that the point is not within its
   // painted area...
   listItems::iterator iter = m_pItems->m_coll.begin();      
   while( iter != m_pItems->m_coll.end() ) {
      CComPtr<IItem> spItem(*iter);
      long x,y,width,height;
      spItem->get_Left(&x);
      spItem->get_Top(&y);
      spItem->get_Width(&width);
      spItem->get_Height(&height);

      RECT rcExpander = 
      { 
         x + (width/2) - (EXPANDER_SIZE/2) - 2,
         y + height - (EXPANDER_SIZE/2) - 2,
         x + (width/2) + (EXPANDER_SIZE/2) + 2,
         y + height + (EXPANDER_SIZE/2) + 2
      };

      // Check if it hitting the expander symbol first,
      // then check if it hits the item.
      if( (sizeOut.cx > rcExpander.left) &&
          (sizeOut.cx < rcExpander.right) &
          (sizeOut.cy > rcExpander.top ) &&
          (sizeOut.cy < rcExpander.bottom) ) {
         spItem.QueryInterface(ppItem);
         HitType = HT_EXPANDER;
         return true;
      }
      else if( (sizeOut.cx > x) &&
          (sizeOut.cx < x+width) &
          (sizeOut.cy > y ) &&
          (sizeOut.cy < y+height) ) {
         spItem.QueryInterface(ppItem);
         HitType = HT_ITEM;
         return true;
      }
      
      iter++;
   }
   return false;
}
