// SiteMapPage.h : Declaration of the CSiteMapPage

#ifndef __SITEMAPPAGE_H_
#define __SITEMAPPAGE_H_

#include "resource.h"       // main symbols

EXTERN_C const CLSID CLSID_SiteMapPage;


/////////////////////////////////////////////////////////////////////////////
// CSiteMapPage

class ATL_NO_VTABLE CSiteMapPage :
   public CComObjectRootEx<CComSingleThreadModel>,
   public CComCoClass<CSiteMapPage, &CLSID_SiteMapPage>,
   public IPropertyPageImpl<CSiteMapPage>,
   public CDialogImpl<CSiteMapPage>
{
public:
   CSiteMapPage() 
   {
      m_dwTitleID = IDS_TITLESiteMapPage;
      m_dwHelpFileID = IDS_HELPFILESiteMapPage;
      m_dwDocStringID = IDS_DOCSTRINGSiteMapPage;
   }

   enum { IDD = IDD_SITEMAPPAGE };

DECLARE_REGISTRY_RESOURCEID(IDR_SITEMAPPAGE)
DECLARE_NOT_AGGREGATABLE(CSiteMapPage)
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CSiteMapPage) 
   COM_INTERFACE_ENTRY(IPropertyPage)
END_COM_MAP()

BEGIN_MSG_MAP(CSiteMapPage)
   CHAIN_MSG_MAP(IPropertyPageImpl<CSiteMapPage>)
   MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
   COMMAND_HANDLER(IDC_ALLOWEXPAND, BN_CLICKED, OnDirty)
   COMMAND_HANDLER(IDC_SCROLL, BN_CLICKED, OnDirty)
   COMMAND_HANDLER(IDC_AUTODRAG, BN_CLICKED, OnDirty)
END_MSG_MAP()

   LRESULT OnInitDialog(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
   {
      for (UINT i = 0; i < m_nObjects; i++) {
         CComQIPtr<ISiteMap> spCtl( m_ppUnk[i] );
         if( spCtl!=NULL ) {
            VARIANT_BOOL vb;
            spCtl->get_Scroll(&vb);
            CheckDlgButton(IDC_SCROLL, vb==VARIANT_TRUE);
            spCtl->get_AutoDragDrop(&vb);
            CheckDlgButton(IDC_AUTODRAG, vb==VARIANT_TRUE);
            spCtl->get_AllowCollapse(&vb);
            CheckDlgButton(IDC_ALLOWEXPAND, vb==VARIANT_TRUE);
         }
      }
      return 0;
   }

   LRESULT OnDirty(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
   {
      SetDirty(TRUE);
      return 0;
   }

   STDMETHOD(Apply)(void)
   {
      ATLTRACE(_T("CSiteMapPage::Apply\n"));
      for (UINT i = 0; i < m_nObjects; i++) {
         CComQIPtr<ISiteMap> spCtl( m_ppUnk[i] );
         if( spCtl!=NULL ) {
            spCtl->put_AutoDragDrop( IsDlgButtonChecked(IDC_AUTODRAG)==BST_CHECKED ? VARIANT_TRUE : VARIANT_FALSE );
            spCtl->put_Scroll( IsDlgButtonChecked(IDC_SCROLL)==BST_CHECKED ? VARIANT_TRUE : VARIANT_FALSE );
            spCtl->put_AllowCollapse( IsDlgButtonChecked(IDC_ALLOWEXPAND)==BST_CHECKED ? VARIANT_TRUE : VARIANT_FALSE );
         }
      }
      m_bDirty = FALSE;
      return S_OK;
   }
};

#endif //__SITEMAPPAGE_H_
