// SiteMap.h : Declaration of the CSiteMap
//
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000-2001 Bjarke Viksoe.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//
#ifndef __SITEMAP_H_
#define __SITEMAP_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "Layer.h"
#include "Items.h"
#include "SiteMapCtrlCP.h"
#include "common.h"


/////////////////////////////////////////////////////////////////////////////
// CSiteMap

class ATL_NO_VTABLE CSiteMap : 
   public CComObjectRootEx<CComSingleThreadModel>,
   public CStockPropImpl<CSiteMap, ISiteMap, &IID_ISiteMap, &LIBID_SiteMap>,
   public CComControl<CSiteMap>,
   public IPersistStreamInitImpl<CSiteMap>,
   public IOleControlImpl<CSiteMap>,
   public IOleObjectImpl<CSiteMap>,
   public IOleInPlaceActiveObjectImpl<CSiteMap>,
   public IViewObjectExImpl<CSiteMap>,
   public IOleInPlaceObjectWindowlessImpl<CSiteMap>,
   public ISupportErrorInfoImpl<&IID_ISiteMap>,
   public IConnectionPointContainerImpl<CSiteMap>,
   public IPersistStorageImpl<CSiteMap>,
   public IPersistPropertyBagImpl<CSiteMap>,
   public ISpecifyPropertyPagesImpl<CSiteMap>,
   public IQuickActivateImpl<CSiteMap>,
   public IDataObjectImpl<CSiteMap>,
   public ICategorizeProperties,
   public IPerPropertyBrowsingImpl<CSiteMap>,
   public IProvideClassInfo2Impl<&CLSID_SiteMap, &DIID__ISiteMapEvents, &LIBID_SiteMap>,
   public IPropertyNotifySinkCP<CSiteMap>,
   public CComCoClass<CSiteMap, &CLSID_SiteMap>,
   public CScrollView<CSiteMap>,
   public CVbKeyEvents<CSiteMap>,
   public CProxy_ISiteMapEvents<CSiteMap>
{
public:
   CSiteMap()
   {
      m_bWindowOnly = TRUE;
   }
   HRESULT FinalConstruct();
   void FinalRelease();

   typedef enum HITTYPE { HT_ITEM, HT_EXPANDER };
   enum { EXPANDER_SIZE = 10 };
   enum { TEXTINSET_SIZE = 5, TEXTAREA_HEIGHT = 28 };
   enum { ITEM_WIDTH=40, ITEM_HEIGHT = 80 };

DECLARE_REGISTRY_RESOURCEID(IDR_SITEMAP)
DECLARE_NOT_AGGREGATABLE(CSiteMap)
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CSiteMap)
   COM_INTERFACE_ENTRY(ISiteMap)
   COM_INTERFACE_ENTRY(IDispatch)
   COM_INTERFACE_ENTRY(IViewObjectEx)
   COM_INTERFACE_ENTRY(IViewObject2)
   COM_INTERFACE_ENTRY(IViewObject)
   COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
   COM_INTERFACE_ENTRY(IOleInPlaceObject)
   COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
   COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
   COM_INTERFACE_ENTRY(IOleControl)
   COM_INTERFACE_ENTRY(IOleObject)
   COM_INTERFACE_ENTRY(IPersistStreamInit)
   COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
   COM_INTERFACE_ENTRY(IPersistPropertyBag)
   COM_INTERFACE_ENTRY(ISupportErrorInfo)
   COM_INTERFACE_ENTRY(IConnectionPointContainer)
   COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
   COM_INTERFACE_ENTRY(IQuickActivate)
   COM_INTERFACE_ENTRY(IPersistStorage)
   COM_INTERFACE_ENTRY(IDataObject)
   COM_INTERFACE_ENTRY(ICategorizeProperties)
   COM_INTERFACE_ENTRY(IPerPropertyBrowsing)
   COM_INTERFACE_ENTRY(IProvideClassInfo)
   COM_INTERFACE_ENTRY(IProvideClassInfo2)
   COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CSiteMap)
   PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
   PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
   PROP_ENTRY("AutoDragDrop", DISPID_AUTODRAG, CLSID_SiteMapPage)
   PROP_ENTRY("Scroll", DISPID_SCROLLBARS, CLSID_SiteMapPage)
   PROP_ENTRY("AllowCollapse", DISPID_ALLOWCOLLAPSE, CLSID_SiteMapPage)
   PROP_ENTRY("Enabled", DISPID_ENABLED, CLSID_NULL)
   PROP_ENTRY("Font", DISPID_FONT, CLSID_StockFontPage)
   PROP_ENTRY("BackColor", DISPID_BACKCOLOR, CLSID_StockColorPage)
   PROP_ENTRY("ForeColor", DISPID_FORECOLOR, CLSID_StockColorPage)
   PROP_ENTRY("FillColor", DISPID_FILLCOLOR, CLSID_StockColorPage)
   PROP_ENTRY("ShadowColor", DISPID_SHADOWCOLOR, CLSID_StockColorPage)
   PROP_ENTRY("BorderColor", DISPID_BORDERCOLOR, CLSID_StockColorPage)
   PROP_ENTRY("SelectedColor", DISPID_SELECTEDCOLOR, CLSID_StockColorPage)
   PROP_PAGE(CLSID_StockFontPage)
   PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CSiteMap)
   CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
   CONNECTION_POINT_ENTRY(DIID__ISiteMapEvents)
END_CONNECTION_POINT_MAP()

BEGIN_CATEGORY_MAP(CSiteMap)
   IMPLEMENTED_CATEGORY(CATID_SafeForScripting)
   IMPLEMENTED_CATEGORY(CATID_SafeForInitializing)
END_CATEGORY_MAP()

BEGIN_MSG_MAP(CSiteMap)
   CHAIN_MSG_MAP(CComControl<CSiteMap>)
   MESSAGE_HANDLER(WM_CREATE, OnCreate)
   MESSAGE_HANDLER(WM_SIZE, OnSize)
   MESSAGE_HANDLER(WM_ERASEBKGND, OnEraseBackground)
   CHAIN_MSG_MAP(CVbKeyEvents<CSiteMap>)
   CHAIN_MSG_MAP(CScrollView<CSiteMap>)
   DEFAULT_REFLECTION_HANDLER()
END_MSG_MAP()

// IViewObjectEx
public:
   DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// CComControlBase
public:
   HRESULT SendOnDataChange(DWORD advf);
   HRESULT OnDraw(ATL_DRAWINFO& di);

// ICategorizeProperties
public:
   STDMETHOD(MapPropertyToCategory)(DISPID disid, PROPCAT *pPropCat);
   STDMETHOD(GetCategoryName)(PROPCAT propcat, LCID lcid, BSTR *pVal);

// IPerPropertyBrowsing
public:
   STDMETHOD(GetDisplayString)(DISPID dispid, BSTR *pVal);
   STDMETHOD(MapPropertyToPage)(DISPID dispid, CLSID *pCLSID);

// IQuickActivate
public:
   HRESULT IQuickActivate_QuickActivate(QACONTAINER *pQACont, QACONTROL *pQACtrl);

// IOleObject
public:
   HRESULT IOleObject_SetClientSite(IOleClientSite *pClientSite);

// IOleControl
public:
   STDMETHOD(OnAmbientPropertyChange)(DISPID dispid);

// Attributes
public:
   OLE_COLOR m_clrBackColor;
   OLE_COLOR m_clrFillColor;
   OLE_COLOR m_clrForeColor;
   OLE_COLOR m_clrBorderColor;
   OLE_COLOR m_clrShadowColor;
   BOOL m_bEnabled;
   CComPtr<IFontDisp> m_pFont;
   //
   OLE_COLOR m_clrSelectedColor;
   DWORD m_dwViewWidth;
   DWORD m_dwViewHeight;
   VARIANT_BOOL m_vbAutoDragDrop;
   VARIANT_BOOL m_vbScrollBars;
   VARIANT_BOOL m_vbAllowCollapse;
   CComPtr<IItems> m_spItems;
   CComPtr<IItem> m_spSelectedItem;
   //
   CComObject<CItems> *m_pItems;
   bool m_bAmbientsFetched;
   bool m_bRecalcGdi;
   bool m_bNeedsArragement;
   bool m_bDesignMode;
   //
   CDragDropLayer m_wndLayer;
   CPen m_penFore;
   CPen m_penBorder;
   CPen m_penShadow;
   CPen m_penSelected;
   CBrush m_brushFill;
   CBrush m_brushBack;
   CBrush m_brushBorder;
   CFontHandle m_fontText;

// CSiteMap message handlers
public:
   LRESULT OnCreate(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
   LRESULT OnSize(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
   LRESULT OnEraseBackground(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
   LRESULT OnHScroll(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
   LRESULT OnVScroll(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);

// CSiteMap
public:
   void _Arrange();
   bool _HitTest(float x, float y, IItem **ppItem, HITTYPE &HitType) const;
   void _ConvertToTree(CItems *pItems, tNode *pNodes, long lSize, BOOL bIncludeAll=FALSE) const;
   void _CalcClientArea();
private:
   void _DrawItem(CDCHandle &dc, tNode *pItems, long lSize, long index) const;
   void _DrawConnector(CDCHandle &dc, tNode *pItems, long lSize, long index) const;
   //
   void _TreeBuild(tNode *pItems, long lSize, long RootIndex, long Index) const;
   void _TreeGetWidth(tNode *pItems, long lSize, long Index, long *pX) const;

// ISiteMap
public:
   STDMETHOD(AboutBox)();
   STDMETHOD(Refresh)();
   STDMETHOD(Arrange)();
   STDMETHOD(HitTest)(float x, float y, IItem **ppRetVal);

   IMPLEMENT_STD_PROP_RO(long, ViewWidth, m_dwViewWidth);
   IMPLEMENT_STD_PROP_RO(long, ViewHeight, m_dwViewHeight);
   IMPLEMENT_STD_PROP_RW(VARIANT_BOOL, AutoDragDrop, m_vbAutoDragDrop);
   IMPLEMENT_STD_PROP_RW(VARIANT_BOOL, AllowCollapse, m_vbAllowCollapse);
   IMPLEMENT_STD_PROP_RW(OLE_COLOR, SelectedColor, m_clrSelectedColor);
   IMPLEMENT_STD_PROP_RW(OLE_COLOR, ShadowColor, m_clrShadowColor);
   IMPLEMENT_COPY_PROP_RO(IItems *, Items, m_spItems);
   IMPLEMENT_COPY_PROP_RO(IItem *, SelectedItem, m_spSelectedItem);

   IMPLEMENT_STD_PROP_RO(VARIANT_BOOL, Scroll, m_vbScrollBars);
   STDMETHOD(put_Scroll)(VARIANT_BOOL newVal);
};

#endif //__SITEMAP_H_
