// SiteMap.cpp : Implementation of CSiteMap
//
// Written by Bjarke Viksoe (bjarke@viksoe.dk)
// Copyright (c) 2000-2001 Bjarke Viksoe.
//
// This code may be used in compiled form in any way you desire. This
// file may be redistributed by any means PROVIDING it is 
// not sold for profit without the authors written consent, and 
// providing that this notice and the authors name is included. 
//
// This file is provided "as is" with no expressed or implied warranty.
// The author accepts no liability if it causes any damage to you or your
// computer whatsoever. It's free, so don't hassle me about it.
//
// Beware of bugs.
//

#include "stdafx.h"

#include "SiteMapCtrl.h"
#include "SiteMap.h"


/////////////////////////////////////////////////////////////////////////////
// Construction/destruction

HRESULT CSiteMap::FinalConstruct()
{
   HRESULT Hr;
   //
   m_bAmbientsFetched = false;
   m_bRecalcGdi = true;
   m_bNeedsArragement = false;
   m_bDesignMode = false;

   // Create Item collection
   HR( CComObject<CItems>::CreateInstance(&m_pItems) );
   m_pItems->_Init(this);
   m_spItems = m_pItems;
   
   // Prepare font
   LOGFONT lfDefault;
   ::GetObject(::GetStockObject(ANSI_VAR_FONT), sizeof(lfDefault), &lfDefault);
   USES_CONVERSION;
   FONTDESC fontdesc =
   {
      sizeof(FONTDESC),
      A2W(lfDefault.lfFaceName),
      FONTSIZE(8),
      FW_BOLD,
      ANSI_CHARSET,
      TRUE,
      FALSE,
      FALSE
   };
   ::OleCreateFontIndirect(&fontdesc,  IID_IFontDisp, (void**)&m_pFont);
   
   // Calculate new client rect
   m_ptViewPos.x = m_ptViewPos.y = 0;
   _CalcClientArea(); 

   return S_OK;
}

void CSiteMap::FinalRelease()
{
   ATLASSERT(m_pItems);
   m_pItems->_Close();
   m_spItems = NULL;
}


/////////////////////////////////////////////////////////////////////////////
// CComControlBase

HRESULT CSiteMap::SendOnDataChange(DWORD advf)
{
   m_bRecalcGdi = true;
   return CComControlBase::SendOnDataChange(advf);
}


/////////////////////////////////////////////////////////////////////////////
// CSiteMap message handlers

LRESULT CSiteMap::OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& bHandled)
{
   if( m_vbScrollBars==VARIANT_TRUE ) {
      ModifyStyle(0, WS_VSCROLL | WS_HSCROLL, SWP_NOREDRAW | SWP_FRAMECHANGED);
   }
   else {
      ModifyStyle(WS_VSCROLL | WS_HSCROLL, 0, SWP_NOREDRAW | SWP_FRAMECHANGED);
   }

   RECT rc;
   GetClientRect(&rc);
   m_wndLayer.m_pSite = this;
   m_wndLayer.Create(m_hWnd, rc);
   ATLASSERT(m_wndLayer.IsWindow());
   _CalcClientArea();

   bHandled = FALSE;
   return S_OK;
};

LRESULT CSiteMap::OnSize(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM lParam, BOOL& bHandled)
{
   _CalcClientArea();
   m_wndLayer.Resize(GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam));
   bHandled = FALSE;
   return S_OK;
};

LRESULT CSiteMap::OnEraseBackground(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
   return 1;   // no background needed
}


/////////////////////////////////////////////////////////////////////////////
// IOleObject

HRESULT CSiteMap::IOleObject_SetClientSite(IOleClientSite *pClientSite)
{
   HRESULT hr = CComControlBase::IOleObject_SetClientSite(pClientSite);
   if( !m_bAmbientsFetched ) {
      HRESULT hr;
      hr = GetAmbientBackColor(m_clrBackColor);
      hr = GetAmbientForeColor(m_clrForeColor);
      m_bAmbientsFetched = true;
   }
   OnAmbientPropertyChange(DISPID_AMBIENT_USERMODE);
   m_clrBorderColor = RGB(0,0,0);
   m_clrFillColor = RGB(247,231,189);
   m_clrSelectedColor = RGB(200,0,0);
   m_clrShadowColor = RGB(189,162,231);
   m_vbAutoDragDrop = VARIANT_TRUE;
   m_vbScrollBars = VARIANT_TRUE;
   m_vbAllowCollapse = VARIANT_TRUE;
   return hr;
}

/////////////////////////////////////////////////////////////////////////////
// IOleControl

// Catch switch from design/runtime mode
STDMETHODIMP CSiteMap::OnAmbientPropertyChange(DISPID dispid)
{
   if( dispid==DISPID_AMBIENT_USERMODE ) {
      m_bDesignMode = false;
      CComVariant var;
      HRESULT hRes = GetAmbientProperty(DISPID_AMBIENT_USERMODE, var);
      if( SUCCEEDED(hRes) && (var.vt==VT_BOOL) && !var.boolVal) m_bDesignMode=true;
   }
   return IOleControlImpl<CSiteMap>::OnAmbientPropertyChange(dispid);
}


/////////////////////////////////////////////////////////////////////////////
// IQuickActivate

// Use QuickActivate to grab ambient properties
HRESULT CSiteMap::IQuickActivate_QuickActivate(QACONTAINER *pQACont, QACONTROL *pQACtrl)
{
   m_clrForeColor = pQACont->colorFore;
   m_clrBackColor = pQACont->colorBack;
   m_bAmbientsFetched = true;
   return CComControlBase::IQuickActivate_QuickActivate(pQACont, pQACtrl);
}


/////////////////////////////////////////////////////////////////////////////
// ICategorizeProperties

STDMETHODIMP CSiteMap::MapPropertyToCategory(DISPID dispid, PROPCAT *pPropCat)
{
   if( pPropCat==NULL ) return E_POINTER;
   switch( dispid) {
   case DISPID_FORECOLOR:
   case DISPID_BACKCOLOR:
   case DISPID_FILLCOLOR:
   case DISPID_BORDERCOLOR:
   case DISPID_SELECTEDCOLOR:
   case DISPID_SHADOWCOLOR:
   case DISPID_BACKSTYLE:
   case DISPID_ALLOWCOLLAPSE:
      *pPropCat = PROPCAT_Appearance;
      return S_OK;
   case DISPID_FONT:
      *pPropCat = PROPCAT_Font;
      return S_OK;
   case DISPID_VIEWWIDTH:
   case DISPID_VIEWHEIGHT:
      *pPropCat = PROPCAT_Scale;
      return S_OK;
   case DISPID_AUTODRAG:
   case DISPID_SCROLLBARS:
      *pPropCat = PROPCAT_Behavior;
      return S_OK;
   };
   return E_FAIL;
};

STDMETHODIMP CSiteMap::GetCategoryName(PROPCAT /*propcat*/, LCID /*lcid*/, BSTR *pVal)
{
   if( pVal==NULL ) return E_POINTER;
   *pVal = NULL;
   return E_FAIL;
}


/////////////////////////////////////////////////////////////////////////////
// IPerPropertyBrowsing

STDMETHODIMP CSiteMap::GetDisplayString(DISPID dispid, BSTR *pVal)
{
   if( pVal==NULL ) return E_POINTER;
   *pVal = NULL;
   switch( dispid ) {
   case DISPID_BACKCOLOR:
   case DISPID_FORECOLOR:
   case DISPID_BORDERCOLOR:
   case DISPID_SELECTEDCOLOR:
   case DISPID_FILLCOLOR:
   case DISPID_SHADOWCOLOR:
   case DISPID_AUTODRAG:
   case DISPID_SCROLLBARS:
   case DISPID_ALLOWCOLLAPSE:
      return S_FALSE; // Secret VB return code. Applies default formatting.
   }
   return IPerPropertyBrowsingImpl<CSiteMap>::GetDisplayString(dispid, pVal);
}

// Fixes MapPropertyToPage CLSID_NULL bug
STDMETHODIMP CSiteMap::MapPropertyToPage(DISPID dispid, CLSID *pCLSID)
{
   HRESULT hr = IPerPropertyBrowsingImpl<CSiteMap>::MapPropertyToPage(dispid, pCLSID);
   if( SUCCEEDED(hr) && CLSID_NULL==*pCLSID ) hr = PERPROP_E_NOPAGEAVAILABLE;
   return hr;
}


/////////////////////////////////////////////////////////////////////////////
// ISiteMap

STDMETHODIMP CSiteMap::AboutBox()
{
   CSimpleDialog<IDD_ABOUTDLG, TRUE> dlg;
   dlg.DoModal();
   return S_OK;
};

STDMETHODIMP CSiteMap::Refresh()
{
   FireViewChange();
   return S_OK;
};

STDMETHODIMP CSiteMap::Arrange()
{
   // Calling Arrange() does not arrange the items right away.
   // Instead it flags the layout algorithm to be run when the
   // control is repainted.
   // A repaint is then requested...
   m_bNeedsArragement = true;
   FireViewChange();
   return S_OK;
};

STDMETHODIMP CSiteMap::put_Scroll(VARIANT_BOOL newVal)
{
   m_vbScrollBars = newVal;
   m_bRequiresSave = TRUE;
   if( IsWindow() ) {
      if( newVal==VARIANT_TRUE ) {
         ModifyStyle(0, WS_VSCROLL | WS_HSCROLL, SWP_FRAMECHANGED);
      }
      else {
         ModifyStyle(WS_VSCROLL | WS_HSCROLL, 0, SWP_FRAMECHANGED);
      }
      FireViewChange();
   }
   SendOnDataChange(NULL);
   return S_OK;
};

STDMETHODIMP CSiteMap::HitTest(float x, float y, IItem **ppRetVal)
{
   if( ppRetVal==NULL ) return E_POINTER;
   *ppRetVal = NULL;
   HITTYPE HitType;
   // Returning S_OK or S_FALSE. VB won't know the difference though.
   return _HitTest(x,y, ppRetVal, HitType) ? S_OK : S_FALSE;
}
