
#pragma once

#include "resource.h"       // main symbols
#include "common.h"
#include "Item.h"


typedef CWinTraits<WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS, WS_EX_TRANSPARENT> CDragDropLayerWinTraits;

// The LayerWindow which sits on top of the controls and catches all
// mouse events. Needed to make drag'n'drop easier...
class CDragDropLayer : 
   public CWindowImpl< CDragDropLayer, CWindow, CDragDropLayerWinTraits >
{
public:
   DECLARE_WND_CLASS_EX(_T("SiteMapLayer"), CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS, NULL)

   BEGIN_MSG_MAP(CDragDropLayer)
      MESSAGE_HANDLER(WM_CREATE, OnCreate)
      MESSAGE_HANDLER(WM_MOUSEMOVE, OnMouseMove)
      MESSAGE_HANDLER(WM_LBUTTONDOWN, OnButtonDown)
      MESSAGE_HANDLER(WM_RBUTTONDOWN, OnButtonDown)
      MESSAGE_HANDLER(WM_LBUTTONUP, OnButtonUp)
      MESSAGE_HANDLER(WM_RBUTTONUP, OnButtonUp)
      MESSAGE_HANDLER(WM_LBUTTONDBLCLK, OnButtonDblClick)
      MESSAGE_HANDLER(WM_ERASEBKGND, OnEraseBackground)
   END_MSG_MAP()

   CSiteMap *m_pSite;
   //
   bool m_bIsDragging;
   CComPtr<IItem> m_spDraggedItem;
   long m_lDragItemIndex;
   long m_lAttachItemIndex;
   POINTS m_ptOrgMousePos;
   //
   POINT m_ptOldTreeOffset;

public:
   LRESULT OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/);
   LRESULT OnMouseMove(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
   LRESULT OnButtonUp(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
   LRESULT OnButtonDown(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
   LRESULT OnButtonDblClick(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM lParam, BOOL& bHandled);
   LRESULT OnEraseBackground(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& bHandled);

public:
   void Resize(long width, long height);

private:
   void GetMouseInfo(WPARAM wParam, LPARAM lParam, 
                     short &Button, short &Shift, 
                     OLE_XPOS_PIXELS &x, OLE_YPOS_PIXELS &y) const;
   //
   void BeginDrag(CComPtr<IItem> &spItem, LPARAM lParam);
   void EndDrag(LPARAM lParam);
   void CancelDrag();
   //
   bool HitTestMap(tNode *pNodes, long lSize, POINT ptOffset, long *pHitIndex) const;
   void TraverseHitMap(tNode *pNodes, long lSize, long Index, POINT &pt, long *pCloseness, long *pHitIndex) const;
   //
   void DrawNewConnector(CDCHandle &dc, tNode *pNodes, long ParentIndex, long ChildIndex, POINT &ptOffset) const;
   void DrawConnector(CDCHandle &dc, tNode *pItems, long lSize, long Index, long xoffset, long yoffset) const;
   void DrawItem(CDCHandle &dc, tNode *pItems, long lSize, long Index, long xoffset, long yoffset) const;
   HRESULT DrawTree(HDC hdc, POINT ptOffset);

};

