
#include "stdafx.h"

#include "SiteMap.h"
#include "Layer.h"


/////////////////////////////////////////////////////////////////////////////
// CDragDropLayer message handlers

LRESULT CDragDropLayer::OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& bHandled)
{
   ATLASSERT(m_pSite);
   m_bIsDragging = false;
   bHandled = FALSE;
   return 0;
}

LRESULT CDragDropLayer::OnButtonDown(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& /*bHandled*/)
{
   if( m_pSite->m_bDesignMode ) return 0; // not in design mode
   
   short Button, Shift;
   OLE_XPOS_PIXELS x;
   OLE_YPOS_PIXELS y;
   GetMouseInfo(wParam, lParam, Button, Shift, x, y);
   m_pSite->Fire_MouseDown(Button, Shift, x, y);

   if( (wParam & MK_LBUTTON)==0 ) return 0;

   // In case of a left-button mouse-click we need to
   // generate Click, drag'n'drop or ItemClick events...

   CComPtr<IItem> spItem;
   CSiteMap::HITTYPE HitType;
   m_pSite->_HitTest((float)x, (float)y, &spItem, HitType);
   if( spItem==NULL ) {
      // No node hit, fire standard click event
      m_pSite->Fire_Click();
   }
   else {
      ATLASSERT(spItem);
      // We hit a node, select it and figure out what on the node
      // we hit...
      switch( HitType ) {
      case CSiteMap::HT_ITEM: 
         {
            POINT pt = { GET_X_LPARAM(lParam), GET_Y_LPARAM(lParam) };
            BOOL bDrag = FALSE;
            if( m_pSite->m_vbAutoDragDrop==VARIANT_TRUE ) bDrag = ::DragDetect(m_hWnd, pt);
            if( bDrag ) {
               BeginDrag(spItem, lParam);
               CClientDC dc(*this);
               POINT ptOffset = { 0,0 };
               DrawTree(dc, ptOffset);
            }
            else {
               spItem->put_Selected(VARIANT_TRUE);
               m_pSite->Fire_ItemClick(spItem);
               // Hmm, the DragDetect() call will block the MouseUp
               // event, so we cheat and generate it...
               m_pSite->Fire_MouseUp(Button, Shift, x, y);
            }
         }
         break;
      case CSiteMap::HT_EXPANDER:
         {
            spItem->put_Selected(VARIANT_TRUE);
            VARIANT_BOOL vb;
            spItem->get_Expanded(&vb);
            vb = vb==VARIANT_TRUE ? VARIANT_FALSE : VARIANT_TRUE;
            spItem->put_Expanded(vb);
            if( vb==VARIANT_TRUE ) m_pSite->Fire_Exapand(spItem); else m_pSite->Fire_Collapse(spItem);
         }
         break;
      default:
         ATLASSERT(false);
      }
   }
   return 0;
}

LRESULT CDragDropLayer::OnButtonUp(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& /*bHandled*/)
{
   if( m_pSite->m_bDesignMode ) return 0; // not in design mode
   
   short Button, Shift;
   OLE_XPOS_PIXELS x;
   OLE_YPOS_PIXELS y;
   GetMouseInfo(wParam, lParam, Button, Shift, x, y);
   m_pSite->Fire_MouseUp(Button, Shift, x, y);

   if( m_bIsDragging ) {
     CClientDC dc(*this);
     DrawTree(dc, m_ptOldTreeOffset);
     EndDrag(lParam);
   }

   return 0;
}

LRESULT CDragDropLayer::OnMouseMove(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& /*bHandled*/)
{
   if( m_pSite->m_bDesignMode ) return 0; // not in design mode

   if( !m_bIsDragging ) {
      short Button, Shift;
      OLE_XPOS_PIXELS x;
      OLE_YPOS_PIXELS y;
      GetMouseInfo(wParam, lParam, Button, Shift, x, y);
      m_pSite->Fire_MouseMove(Button, Shift, x, y);
   }
   else {
      // Move dragged item
      POINTS ptNewMousePos = MAKEPOINTS(lParam);
      POINT ptOffset;
      ptOffset.x = ptNewMousePos.x - m_ptOrgMousePos.x;
      ptOffset.y = ptNewMousePos.y - m_ptOrgMousePos.y;

      CClientDC dc(*this);
      DrawTree(dc, m_ptOldTreeOffset);
      DrawTree(dc, ptOffset);
   }
   
   return 0;
}

LRESULT CDragDropLayer::OnButtonDblClick(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
   if( m_pSite->m_bDesignMode ) return 0; // not in design mode
   m_pSite->Fire_DblClick();
   return 0;
}

LRESULT CDragDropLayer::OnEraseBackground(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
{
   return 1; // no background paint
}


/////////////////////////////////////////////////////////////////////////////
// Helper functions

void CDragDropLayer::Resize(long width, long height)
{
   if( IsWindow() ) MoveWindow(0,0, width, height, FALSE);
}

void CDragDropLayer::GetMouseInfo(WPARAM wParam, LPARAM lParam, 
                                 short &Button, short &Shift, 
                                 OLE_XPOS_PIXELS &x, OLE_YPOS_PIXELS &y) const
{
   Button = 0;
   Shift = 0;
   if( wParam & MK_LBUTTON ) Button |= 1;
   if( wParam & MK_RBUTTON ) Button |= 2;
   if( wParam & MK_MBUTTON ) Button |= 4;
   if( wParam & MK_SHIFT ) Shift |= 1;
   if( wParam & MK_CONTROL ) Shift |= 2;
   if( ::GetKeyState(VK_MENU)<0 ) Shift |= 4;
   //
   x = (OLE_XPOS_PIXELS)GET_X_LPARAM(lParam);
   y = (OLE_YPOS_PIXELS)GET_Y_LPARAM(lParam);
}

