// Items.h: Definition of the Items class
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ITEMS_H__EB8CE98E_8141_4BE2_B19D_225745E5F46E__INCLUDED_)
#define AFX_ITEMS_H__EB8CE98E_8141_4BE2_B19D_225745E5F46E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"       // main symbols

#include <list>
using namespace std;

#include "common.h"
#include "Item.h"


/////////////////////////////////////////////////////////////////////////////
// Items

typedef list< CAdapt< CComPtr<IItem> > >
   listItems;
typedef CComEnumOnSTL< IEnumVARIANT, &IID_IEnumVARIANT, VARIANT, _CopyVariantFromAdaptItf<IItem>, listItems >
   CComEnumVariantOnListOfItems;
typedef ICollectionOnSTLImpl< IDispatchImpl< IItems, &IID_IItems >, listItems, IItem *, _CopyItfFromAdaptItf<IItem>, CComEnumVariantOnListOfItems>
   IItemsCollectionImpl;

class CItems : 
   public IItemsCollectionImpl,
   public CComObjectRoot,
   public CComCoClass<Items,&CLSID_Items>,
   public ISupportErrorInfoImpl<&IID_IItems>
{
public:
   CItems() 
   {
   }

BEGIN_COM_MAP(CItems)
   COM_INTERFACE_ENTRY(IDispatch)
   COM_INTERFACE_ENTRY(IItems)
   COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

DECLARE_NOT_AGGREGATABLE(Items) 
DECLARE_REGISTRY_RESOURCEID(IDR_Items)

// Attributes
public:
   CSiteMap *m_pBase;
   static DWORD m_dwID;

// CItems
public:
   void _Init(CSiteMap *pBase);
   void _Close();

// IItems
public:
   STDMETHOD(Add)(IItem *Parent, BSTR Title, long x, long y, IItem **ppVal);
   STDMETHOD(Remove)(long Index);
   STDMETHOD(Clear)();

};

__declspec(selectany) DWORD CItems::m_dwID = 0;


#endif // !defined(AFX_ITEMS_H__EB8CE98E_8141_4BE2_B19D_225745E5F46E__INCLUDED_)
