
#include "stdafx.h"

#include "SiteMap.h"
#include "Items.h"


/////////////////////////////////////////////////////////////////////////////
// CItems

void CItems::_Init(CSiteMap *pBase)
{
   ATLASSERT(pBase);
   // Keep a weak C++ reference back to CSiteMap.
   // This is perfectly valid since CSiteMap has a reference count
   // on this COM object, thus keeping it alive during its entire
   // own life-span.
   m_pBase = pBase;
}

void CItems::_Close()
{
   m_coll.clear();
}


/////////////////////////////////////////////////////////////////////////////
// IItems

STDMETHODIMP CItems::Add(IItem *Parent, BSTR Title, long x, long y, IItem **ppVal)
{
   ATLASSERT(m_pBase);
   ATLASSERT(ppVal);
   if( ppVal==NULL ) return E_POINTER;

   // Add to collection
   HRESULT Hr;
   CComObject<CItem> *pItem;
   HR( CComObject<CItem>::CreateInstance(&pItem) );
   CComPtr<IItem> spItem( pItem );
   m_coll.push_back(spItem);
   pItem->_Init(this, m_dwID++, Title, x, y);
   if( Parent!=NULL ) {
      HR( spItem->put_Parent(Parent) );
      // Setting parent will also cause Arrange() to be called!
   }
   else {
      m_pBase->Arrange();
   }
   return spItem.CopyTo(ppVal);
}

STDMETHODIMP CItems::Remove(long Index)
{
   if( Index<=0 ) return E_INVALIDARG;
   HRESULT hr = E_FAIL;
   Index--;
   listItems::iterator iter = m_coll.begin();
   while( iter != m_coll.end() && Index > 0 ) {
      iter++;
      Index--;
   }
   if( iter != m_coll.end() ) {
      CComPtr<IItem> spItem = *iter;
      ATLASSERT(spItem);
      spItem->put_Selected(VARIANT_FALSE);
      spItem->_Close();
      m_coll.erase(iter);
      m_pBase->Arrange();
      hr = S_OK;
   }
   return hr;
}

STDMETHODIMP CItems::Clear()
{
   m_coll.clear();
   m_pBase->FireViewChange();
   return S_OK;
}
