// Item.h: Definition of the Item class
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ITEM_H__46DFEFEA_BB9F_4218_8A69_06A93F9853C7__INCLUDED_)
#define AFX_ITEM_H__46DFEFEA_BB9F_4218_8A69_06A93F9853C7__INCLUDED_

#pragma once

#include "resource.h"       // main symbols
#include "SiteMapCtrl.h"
#include "common.h"


/////////////////////////////////////////////////////////////////////////////
// Item

class CItem : 
   public IDispatchImpl<IItem, &IID_IItem, &LIBID_SiteMap>, 
   public ISupportErrorInfoImpl<&IID_IItem>,
   public CComObjectRoot,
   public CComCoClass<Item,&CLSID_Item>
{
public:
   CItem() 
   {
      m_bRequiresSave = false;
   }

BEGIN_COM_MAP(CItem)
   COM_INTERFACE_ENTRY(IDispatch)
   COM_INTERFACE_ENTRY(IItem)
   COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

DECLARE_NOT_AGGREGATABLE(Item) 
DECLARE_REGISTRY_RESOURCEID(IDR_Item)

// Attributes
public:
   long m_lID;
   CComBSTR m_bstrTitle;
   long m_lLeft, m_lTop, m_lWidth, m_lHeight;
   long m_lLeftOffset, m_lTopOffset;
   CComPtr<IItem> m_spParent;
   VARIANT_BOOL m_vbShowChildren;
   VARIANT_BOOL m_vbSelected;
   CComVariant m_vTag;
   //
   CSiteMap *m_pBase;
   CItems *m_pColl;
   bool m_bRequiresSave;

// CItem
public:
   void _Init(CItems *pColl, long ID, BSTR Title, long x, long y);

// IItem
public:
   STDMETHOD(get_ID)(long *pRetVal);
   STDMETHOD(get_Left)(long *pRetVal);
   STDMETHOD(put_Left)(long newVal);
   STDMETHOD(get_Top)(long *pRetVal);
   STDMETHOD(put_Top)(long newVal);
   STDMETHOD(get__LeftOffset)(long *pRetVal);
   STDMETHOD(put__LeftOffset)(long newVal);
   STDMETHOD(get__TopOffset)(long *pRetVal);
   STDMETHOD(put__TopOffset)(long newVal);
   STDMETHOD(_Close)();
   STDMETHOD(get_Tag)(VARIANT *pRetVal);
   STDMETHOD(put_Tag)(VARIANT newVal);
   STDMETHOD(putref_Tag)(IDispatch *newVal);
   STDMETHOD(get_Expanded)(VARIANT_BOOL *pRetVal);
   STDMETHOD(put_Expanded)(VARIANT_BOOL newVal);
   STDMETHOD(get_Parent)(IItem **ppRetVal);
   STDMETHOD(put_Parent)(IItem *newVal);
   STDMETHOD(get_Selected)(VARIANT_BOOL *pRetVal);
   STDMETHOD(put_Selected)(VARIANT_BOOL newVal);
   STDMETHOD(get_Index)(long *pRetVal);

   IMPLEMENT_COPY_PROP_RW(BSTR, Title, m_bstrTitle);
   IMPLEMENT_STD_PROP_RW(long, Width, m_lWidth);
   IMPLEMENT_STD_PROP_RW(long, Height, m_lHeight);

   // My IMPLEMENT macros require this.
   // Nice because we can call FireViewChange() on control.
   void FireViewChange();
   HRESULT SendOnDataChange(DWORD advf);

};

#endif // !defined(AFX_ITEM_H__46DFEFEA_BB9F_4218_8A69_06A93F9853C7__INCLUDED_)
