
#include "stdafx.h"

#include "SiteMap.h"
#include "Item.h"


/////////////////////////////////////////////////////////////////////////////
// CItem

void CItem::_Init(CItems *pColl, long ID, BSTR Title, long x, long y)
{
   ATLASSERT(pColl);
   m_pColl = pColl;
   m_pBase = pColl->m_pBase;
   ATLASSERT(m_pBase);
   //
   m_lID = ID;
   m_bstrTitle = Title;
   m_lLeft = x;
   m_lTop = y;
   m_lWidth = 70;
   m_lHeight = 50;
   m_lLeftOffset = m_lTopOffset = 0;
   m_vbShowChildren = VARIANT_TRUE;
   m_vbSelected = VARIANT_FALSE;
}


/////////////////////////////////////////////////////////////////////////////
// IItem

STDMETHODIMP CItem::get_ID(long *pRetVal)
{
   ATLASSERT(pRetVal);
   *pRetVal = m_lID;
   return S_OK;
}

STDMETHODIMP CItem::get_Left(long *pRetVal)
{
   if( pRetVal==NULL ) return E_POINTER;
   *pRetVal = m_lLeft + m_lLeftOffset;
   return S_OK;
}

STDMETHODIMP CItem::put_Left(long newVal)
{
   ATLASSERT(m_pColl);
   ATLASSERT(m_pBase);
   if( m_pColl==NULL ) return E_UNEXPECTED;
   // Calc new X-pos.
   // This is tricky because the x-position depends on the children attached below
   // the moved item (they push it out-wards).
   // To get things right, we call the graph layout algorithm, so this is 
   // a really expensive operation.
   m_lLeft = newVal;
   m_lLeftOffset = 0;
   m_pBase->_Arrange();
   m_lLeft -= m_lLeftOffset;
   m_lLeftOffset = 0;
   m_pBase->Arrange();
   return S_OK;
}

STDMETHODIMP CItem::get_Top(long *pRetVal)
{
   if( pRetVal==NULL ) return E_POINTER;
   *pRetVal = m_lTop + m_lTopOffset;
   return S_OK;
}

STDMETHODIMP CItem::put_Top(long newVal)
{
   ATLASSERT(m_pColl);
   ATLASSERT(m_pBase);
   if( m_pColl==NULL ) return E_UNEXPECTED;
   m_lTop = newVal;
   m_lTopOffset = 0;
   m_pBase->Arrange();
   return S_OK;
}

STDMETHODIMP CItem::get__LeftOffset(long *pRetVal)
{
   if( pRetVal==NULL ) return E_POINTER;
   *pRetVal = m_lLeftOffset;
   return S_OK;
}

STDMETHODIMP CItem::put__LeftOffset(long newVal)
{
   m_lLeftOffset = newVal;
   return S_OK;
}

STDMETHODIMP CItem::get__TopOffset(long *pRetVal)
{
   if( pRetVal==NULL ) return E_POINTER;
   *pRetVal = m_lTopOffset;
   return S_OK;
}

STDMETHODIMP CItem::put__TopOffset(long newVal)
{
   m_lTopOffset = newVal;
   return S_OK;
}

STDMETHODIMP CItem::_Close()
{
   m_pColl = NULL;
   m_pBase = NULL;
   m_spParent = NULL;
   return S_OK;
}

STDMETHODIMP CItem::get_Tag(VARIANT *pRetVal)
{
   if( pRetVal==NULL ) return E_POINTER;
   return CComVariant(m_vTag).Detach(pRetVal); // Where's the CopyTo()?
}

STDMETHODIMP CItem::put_Tag(VARIANT newVal)
{
   m_vTag = newVal;
   return S_OK;
}

STDMETHODIMP CItem::putref_Tag(IDispatch *newVal)
{
   m_vTag = newVal;
   return S_OK;
}

STDMETHODIMP CItem::get_Expanded(VARIANT_BOOL *pRetVal)
{
   if( pRetVal==NULL ) return E_POINTER;
   *pRetVal = m_vbShowChildren;
   return S_OK;
}

STDMETHODIMP CItem::put_Expanded(VARIANT_BOOL newVal)
{
   ATLASSERT(m_pColl);
   ATLASSERT(m_pBase);
   if( m_pColl==NULL ) return E_UNEXPECTED;
   if( newVal==m_vbShowChildren ) return S_OK;
   m_vbShowChildren = newVal;
   m_pBase->Arrange();
   return S_OK;
}

STDMETHODIMP CItem::get_Parent(IItem **ppRetVal)
{
   if( ppRetVal==NULL ) return E_POINTER;
   m_spParent.CopyTo(ppRetVal);
   return S_OK;
}

STDMETHODIMP CItem::put_Parent(IItem *newVal)
{
   ATLASSERT(m_pColl);
   ATLASSERT(m_pBase);
   if( m_pColl==NULL ) return E_UNEXPECTED;
   // TODO: Add check for cyclic references
   m_spParent = newVal;
   m_pBase->Arrange();
   return S_OK;
}

STDMETHODIMP CItem::get_Selected(VARIANT_BOOL *pRetVal)
{
   if( pRetVal==NULL ) return E_POINTER;
   *pRetVal = m_vbSelected;
   return S_OK;
}

STDMETHODIMP CItem::put_Selected(VARIANT_BOOL newVal)
{
   ATLASSERT(m_pColl);
   ATLASSERT(m_pBase);
   if( m_pColl==NULL ) return E_UNEXPECTED;
   if( m_pBase==NULL ) return E_UNEXPECTED;
   if( m_vbSelected==newVal ) return S_OK;

   // Reset state on previously selected item.
   CComPtr<IItem> spCurSel = m_pBase->m_spSelectedItem;
   if( (newVal==VARIANT_TRUE) &&
       (spCurSel!=NULL) && 
       (spCurSel.IsEqualObject(GetUnknown())==false) ) {
      spCurSel->put_Selected(VARIANT_FALSE);
   }
   // I'm selected now, update control...
   m_vbSelected = newVal;
   if( newVal==VARIANT_TRUE ) {
      m_pBase->m_spSelectedItem = this;
   }
   else {
      m_pBase->m_spSelectedItem = NULL;
   }
   FireViewChange();
   return S_OK;
}

STDMETHODIMP CItem::get_Index(long *pRetVal)
{
   ATLASSERT(m_pColl);
   ATLASSERT(m_pBase);
   if( pRetVal==NULL ) return E_POINTER;
   if( m_pColl==NULL ) return E_UNEXPECTED;
   // We don't know where the index is, so we must look through
   // the complete collection to find it...
   long lIndex = 1;
   listItems::iterator iter = m_pColl->m_coll.begin();
   while( iter != m_pColl->m_coll.end() ) {
      CComPtr<IItem> spItem = *iter;
      ATLASSERT(spItem);
      long ID;
      spItem->get_ID(&ID);
      if( ID==m_lID ) {
         *pRetVal = lIndex;
         return S_OK;
      }
      iter++;
      lIndex++;
   }
   return E_FAIL;
}


/////////////////////////////////////////////////////////////////////////////
// IItem misc

void CItem::FireViewChange() 
{ 
   if( m_pColl && m_pBase ) m_pBase->FireViewChange(); 
};

HRESULT CItem::SendOnDataChange(DWORD /*advf*/) 
{ 
   return S_OK; 
};
