
#include "stdafx.h"

#include "SiteMapCtrl.h"
#include "SiteMap.h"


//
// TreeLayout (an algorithm from some German University site).
// The linked list is converted to a tree structure while processing
// items from top to bottom, left to right.
//
// The algorithm will place each node in a new position.
// We don't actually set a new X/Y value, but instead we use the
// hidden Offset properties. This will allow us to move the root
// node back to the original position when the tree is collapsed.
//

void CSiteMap::_TreeGetWidth(tNode *pNodes, long lSize, long Index, long *pX) const
{
   if( Index<0 ) return;
   tNode &item = pNodes[Index];
   // Is the x-pos greater?
   if( item.x > *pX ) *pX = item.x;
   // Process children?
   if( item.bShowChildren ) {
      for( int i=0; i<lSize; i++ ) {
         if( pNodes[i].parentIndex==Index ) {
            _TreeGetWidth(pNodes,lSize,i,pX);
         }
      }
   }
}

void CSiteMap::_TreeBuild(tNode *pNodes, long lSize, long RootIndex, long ParentIndex) const
{
   tNode &parent = pNodes[ParentIndex];

   long left, right;
   left = right = -1;
   for( int i=0; i<lSize; i++ ) {
      if( pNodes[i].ParentID==parent.ID ) {
         tNode &item = pNodes[i];
         item.leftIndex = left;
         item.rightIndex = -1;
         item.parentIndex = ParentIndex;
         left = i;

         item.y = parent.y + ITEM_HEIGHT;

         if( item.leftIndex>=0 ) {
            item.x = parent.x;
            _TreeGetWidth(pNodes, lSize, RootIndex, &item.x);
            item.x += ITEM_WIDTH*2;

            // Move all "above" and "to the right" (since there is no right,
            // its easy)...
            long MoveIndex = i;
            while( TRUE ) {
               MoveIndex = pNodes[MoveIndex].parentIndex;
               pNodes[MoveIndex].x += ITEM_WIDTH;
               if( MoveIndex==RootIndex ) break;
            }
         }
         else {
            item.x = parent.x;
         }

         if( right>=0 ) pNodes[right].rightIndex = i;
         right = i;
         if( item.bShowChildren ) _TreeBuild(pNodes, lSize, RootIndex, i);
      }
   }

}

void CSiteMap::_Arrange()
{
   ATLASSERT("CSiteMap::_Arrange()\n");
   ATLASSERT(m_pItems);

   m_bNeedsArragement = false;

   long lSize = m_pItems->m_coll.size();
   if( lSize==0 ) return;
   tNode *pNodes = new tNode[lSize];
   if( pNodes==NULL ) return;
   int i;

   // Reset all previous offsets
   listItems::iterator iter;
   iter = m_pItems->m_coll.begin();
   i = 0;
   while( iter != m_pItems->m_coll.end() ) {
      CComPtr<IItem> spItem(*iter);
      spItem->put__LeftOffset(0);
      spItem->put__TopOffset(0);

      iter++;
      i++;
   }

   // Construct internal array of items...
   _ConvertToTree(m_pItems, pNodes, lSize);

   // For all root items, process subtree...
   for( i=0; i<lSize; i++ ) {
      tNode &item = pNodes[i];
      if( item.ParentID<0 ) _TreeBuild(pNodes, lSize, i, i);
   }

   // Store new positions back to items...
   iter = m_pItems->m_coll.begin();
   i = 0;
   while( iter != m_pItems->m_coll.end() ) {
      CComPtr<IItem> spItem(*iter);
      tNode &item = pNodes[i];
      spItem->put__LeftOffset(item.x - item.oldX);
      spItem->put__TopOffset(item.y - item.oldY);

      iter++;
      i++;
   }

   delete [] pNodes;
}
