#if !defined(AFX_TCPIPSERVER_H__20010923_D9C8_4110_F2D4_0080AD509054__INCLUDED_)
#define AFX_TCPIPSERVER_H__20010923_D9C8_4110_F2D4_0080AD509054__INCLUDED_

#pragma once

class CTcpipServer : public CThreadImpl<CTcpipServer>
{
public:
   enum { DEFAULT_PORT = 9155 };
   enum { DEFAULT_BACKLOG = 8 };

   typedef struct 
   {
      CTcpipServer *pT;
      SOCKET hSocket;
   } THREADARGS;

   volatile LONG m_nThreads;

   CTcpipServer() : m_nThreads(0L)
   {
   }

   void Stop()
   {
      Abort();
      // Need to send something to the socket so the thread gets
      // out of a possible idle state
      CHAR szHost[128] = { 0 };
      ::gethostname(szHost, sizeof(szHost));
      CSocket tcp;
      if( tcp.Open(DEFAULT_PORT, szHost) ) {
         tcp.Close();
      }
      // Then we need to wait on all worker threads
      while( m_nThreads > 0 ) ::Sleep(200L);
      // Stop dispatcher thread
      CThreadImpl<CTcpipServer>::Stop();
   }

   DWORD Run()
   {
      CSocket hServer;
      if( hServer.Create(DEFAULT_PORT, NULL, DEFAULT_BACKLOG)==FALSE ) {
         lprintf(_T("Failed to create TCP/IP socket!\n"));
         return FALSE;
      }

      while( !IsAborted() ) {

         SOCKADDR client;
         int iAddrSize = sizeof(client);
         SOCKET hClient = hServer.Accept(&client, &iAddrSize);
         if( IsAborted() ) {
            // The service is about to stop
            break;
         }
         if( hClient==INVALID_SOCKET ) {
            // The Client could not connect
            continue;
         }

         // Prepare thread arguments
         THREADARGS *pArgs = new THREADARGS;
         pArgs->pT = this;
         pArgs->hSocket = hClient;
         // Create a thread for this client. 
         DWORD dwThreadId;
         HANDLE hThread = ::CreateThread( 
            NULL,              // No security attribute 
            0,                 // Default stack size 
            (LPTHREAD_START_ROUTINE)TcpProc, 
            pArgs,             // Thread parameter 
            0,                 // Not suspended 
            &dwThreadId);      // Returns thread ID 
         if( hThread==NULL ) {
            lprintf(_T("Unable to create TCP/IP thread.\n"));
            continue;
         }
         ::CloseHandle(hThread); 
      }
      return 0;
   }

   static DWORD WINAPI TcpProc(LPVOID lParam)
   {
      THREADARGS *pArgs = (THREADARGS *)lParam;
      _ASSERTE(pArgs);
      CTcpipServer *pThis = pArgs->pT;
      SOCKET hSocket = pArgs->hSocket;
      delete pArgs;

      ::InterlockedIncrement(&pThis->m_nThreads);
      lprintf(_T("Creating TCP/IP client.\n"));

      CServerProtocol<CSocket> sp(&pThis->m_bStopped);
      sp.m_tp.Attach(hSocket);
      sp.ServeClient();

      lprintf(_T("Closing TCP/IP client.\n"));
      ::InterlockedDecrement(&pThis->m_nThreads);

      return 0;
   }
};


#endif // !defined(AFX_TCPIPSERVER_H__20010923_D9C8_4110_F2D4_0080AD509054__INCLUDED_)

