// Server1.cpp : Implementation of WinMain

#pragma once

#include "stdafx.h"

#include "ConsoleScreen.h"
#include "Thread.h"
#include "NetApiWrappers.h"
#include "ServerProtocol.h"
#include "MailSlotServer.h"
#include "NamedPipeServer.h"
#include "TcpipServer.h"


///////////////////////////////////////////////////////////////////////////////////////
// Server main loop

void CServiceModule::Execute()
{
   CConsole console;
   console.Create();
   console.SetCtrlHandler(_ConsoleHandler);
   console.ModifyConsoleMode(ENABLE_MOUSE_INPUT|ENABLE_WINDOW_INPUT, 0);

   LogEvent(_T("Service started."));

   // TCP/IP server
   WSAInit wsa;
   CTcpipServer ips;
   ips.Start();

   // Named Pipe server
   CNamedPipeServer nps;
   nps.Start();

   // MailSlot server
   CMailSlotServer mss;
   mss.Start();

   MSG msg;
   while( ::GetMessage(&msg, 0, 0, 0) ) ::DispatchMessage(&msg);

   lprintf(_T("Stopping service...\n"));

   // Allow worker/client threads to terminate
   mss.Abort();
   nps.Abort();
   ips.Abort();
   // Stop and wait for thread termination
   mss.Stop();
   nps.Stop();
   ips.Stop();

   LogEvent(_T("Service stopped."));
};

// The ConsoleHandler allows us to catch when the command
// window is closed. We need to gently close down the
// server threads as well...
BOOL WINAPI CServiceModule::_ConsoleHandler(DWORD dwOpcode)
{
   switch( dwOpcode ) {
   case CTRL_CLOSE_EVENT:
   case CTRL_LOGOFF_EVENT:
   case CTRL_SHUTDOWN_EVENT:
      ::PostThreadMessage(_Module.m_dwThreadID, WM_QUIT, 0, 0);
      return TRUE;
   default:
      return FALSE;
   }
};
