#if !defined(AFX_SERVERPROTOCOL_H__20010923_CAA0_15A1_DFDC_0080AD509054__INCLUDED_)
#define AFX_SERVERPROTOCOL_H__20010923_CAA0_15A1_DFDC_0080AD509054__INCLUDED_

#pragma once

//
// Commands:
//   Name: Get item value
//     Command:  "GET <char>"
//     Response: "<errorcode> <value>"
//   Name: Set item value
//     Command:  "SET <char> <value>"
//     Response: "<errorcode> <error description>"
//

template< class TTransport >
class CServerProtocol
{
public:
   enum { BUFFERSIZE = 1024 };

   TTransport m_tp;                   // Network transport implementation (templated class).
   BYTE m_bBuffer[BUFFERSIZE+2];      // An overflow buffer for network data.
                                      // The buffer is exactly 1 UNICODE char too long for
                                      // a NULL-termination string character.
   DWORD m_dwBufferSize;              // Current size of buffer.
   const volatile bool *m_pbStopped;  // Ref. to owner-class flag. Indicates app stop.

   CServerProtocol(const volatile bool* pbStopped) : m_dwBufferSize(0L), m_pbStopped(pbStopped)
   {
      ::ZeroMemory(m_bBuffer, sizeof(m_bBuffer));      
   }

   BOOL ServeClient()
   {
      while( true ) {
         // Wait until we receive a message...
         WCHAR wszMsg[256] = { 0 };
         if( ReceiveString(wszMsg, (sizeof(wszMsg)/sizeof(WCHAR))-1)==FALSE ) return FALSE;
         // Disect string input
         LPWSTR pwstr = wcschr(wszMsg, L' ');
         if( pwstr==NULL ) pwstr = wszMsg + wcslen(wszMsg);
         WCHAR wszCmd[32] = { 0 };
         wcsncpy(wszCmd, wszMsg, min(31, pwstr-wszMsg));
         ::CharUpperBuffW(wszCmd, wcslen(wszCmd));
         LPCWSTR pwstrData = pwstr+1; 

         // Parse the command
         if( wcscmp(wszCmd, L"SET")==0 ) {
            WCHAR wKey = pwstrData[0];
            if( _Module.m_data.Set(wKey, pwstrData+2) ) {
               SendString(L"0 Ok.");
            }
            else {
               SendString(L"1 Unable to set value.");
            }
         }
         else if( wcscmp(wszCmd, L"GET")==0 ) {
            WCHAR wKey = pwstrData[0];
            CComBSTR bstr;            
            if( _Module.m_data.Get(wKey, bstr) ) {
               WCHAR wszSend[256];
               wcscpy( wszSend, L"0 " );
               wcscat( wszSend, bstr.m_str );
               SendString(wszSend);
            }
            else {
               SendString(L"1 Not found.");
            }
         }
         else {
            return FALSE;
         }
      }
   }

   BOOL SendString(LPCWSTR pwstrString)
   {
      // Send the new message using the network api.
      // First we need to add the terminating new-line character.
      LPWSTR pwstr = (LPWSTR)_alloca((wcslen(pwstrString)+2)*sizeof(WCHAR));
      if( pwstr==NULL ) return FALSE;
      wcscpy(pwstr, pwstrString);
      wcscat(pwstr, L"\n");
      return m_tp.Write(pwstr, wcslen(pwstr)*sizeof(WCHAR));
   }
   BOOL ReceiveString(LPWSTR pstr, DWORD cchMax)
   {
      // Receive a message from network api.
      // Basically a network protocol may send more than just a single message in one data packet
      // so we need to look for a termination character (new-line char) in the available buffer.
      // If one is found we can grab the message and treat the remaining buffer as the start of 
      // the next message.
      // If a termination character is not found, the entire buffer is part of the new message and
      // we keep appending received data until a termination character is found.
      *pstr = L'\0';
      while( true ) {
         LPWSTR pwstr = wcschr((LPCWSTR)m_bBuffer, L'\n');
         if( pwstr!=NULL ) {
            *pwstr = L'\0';
            if( wcslen(pstr) + wcslen((LPCWSTR)m_bBuffer) >= cchMax ) return FALSE;
            wcscat( pstr, (LPCWSTR)m_bBuffer );
            m_dwBufferSize = (m_bBuffer+BUFFERSIZE)-(LPBYTE)(pwstr+1);
            memcpy( m_bBuffer, pwstr+1, m_dwBufferSize+2 );
            return TRUE;
         }
         wcscat( pstr, (LPCWSTR)m_bBuffer );
         while( true ) {
            // Data polling is basically considered a bad (network) programming
            // practice. In this case we're trying to handle multiple protocols
            // uniformly so until I've written some more advanced wrappers,
            // it's the way we do it...
            BOOL ok = m_tp.WaitForData(1000L);
            if( ok ) break;
            // Check if we're stopped
            if( *m_pbStopped ) return FALSE;
         }
         DWORD dwRead;
         if( m_tp.Read(m_bBuffer, BUFFERSIZE, &dwRead)==FALSE ) return FALSE;
         m_bBuffer[dwRead] = 0; m_bBuffer[dwRead+1] = 0; // UNICODE sz-char
         m_dwBufferSize = dwRead;
      }
   }
};


#endif // !defined(AFX_SERVERPROTOCOL_H__20010923_CAA0_15A1_DFDC_0080AD509054__INCLUDED_)

