#if !defined(AFX_DATASTORAGE_H__20010924_C193_75AF_90F8_0080AD509054__INCLUDED_)
#define AFX_DATASTORAGE_H__20010924_C193_75AF_90F8_0080AD509054__INCLUDED_

#pragma once

template< class T=CComAutoCriticalSection >
class CAutoLock
{
public:
   T *m_p;
   CAutoLock(T *p) : m_p(p)
   {
      m_p->Lock();
   }
   ~CAutoLock()
   {
      m_p->Unlock();
   }
};


class CDataStorage
{
public:
   CSimpleMap<WCHAR, CComBSTR> m_data;
   CComAutoCriticalSection m_cs;

   BOOL Set(WCHAR Key, LPCWSTR pwstrData)
   {
      if( Key<L'A' || Key>L'Z' ) return FALSE;
      CAutoLock<> lock(&m_cs);
      if( m_data.FindKey(Key)==-1 ) {
         m_data.Add(Key, CComBSTR(pwstrData));
      }
      else {
         m_data.SetAt(Key, CComBSTR(pwstrData));
      }
      return TRUE;
   }
   BOOL Get(WCHAR Key, CComBSTR &bstr)
   {
      if( Key<L'A' || Key>L'Z' ) return FALSE;
      CAutoLock<> lock(&m_cs);
      if( m_data.FindKey(Key)==-1 ) return FALSE;
      bstr = m_data.Lookup(Key);
      return TRUE;
   }
};


#endif // !defined(AFX_DATASTORAGE_H__20010924_C193_75AF_90F8_0080AD509054__INCLUDED_)

