// stdafx.h : include file for standard system include files,
//      or project specific include files that are used frequently,
//      but are changed infrequently

#if !defined(AFX_STDAFX_H__2B6133DE_6AA6_4C58_94A3_C7ADF0D0094C__INCLUDED_)
#define AFX_STDAFX_H__2B6133DE_6AA6_4C58_94A3_C7ADF0D0094C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#define STRICT
#ifndef _WIN32_WINNT
#define _WIN32_WINNT 0x0400
#endif
#define _ATL_APARTMENT_THREADED

#include <atlbase.h>
extern CComModule _Module;
#include <atlcom.h>
#include <atlctl.h>

// If you have installed MS Platform SDK this can
// prevent a collision with the ATL version.
#define InlineIsEqualGUID ::InlineIsEqualGUID

#include <atldb.h>

extern const GUID CLSID_ServerDb;

#if _ATL_VER >= 0x0700
template <class T>
class CRunTimeFree
{
public:
   static void Free(T* pData) { delete [] pData; }
};
template <class T>
class CComFree
{
public:
   static void Free(T* pData) { ::CoTaskMemFree(pData); }
};
template <class T, class DeAllocator = CRunTimeFree< T > >
class CAutoMemRelease
{
public:
   CAutoMemRelease()
   {
      m_pData = NULL;
   }
   CAutoMemRelease(T* pData)
   {
      m_pData = pData;
   }
   ~CAutoMemRelease()
   {
      Attach(NULL);
   }
   void Attach(T* pData)
   {
      DeAllocator::Free(m_pData);
      m_pData = pData;
   }
   T* Detach()
   {
      T* pTemp = m_pData;
      m_pData = NULL;
      return pTemp;
   }
   T* m_pData;
};
#endif


//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_STDAFX_H__2B6133DE_6AA6_4C58_94A3_C7ADF0D0094C__INCLUDED)
